/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.level;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.concurrent.CompletableFuture;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.erosion.packet.backendbound.BackendboundBatchBlockRequestPacket;
import org.geysermc.erosion.packet.backendbound.BackendboundBlockRequestPacket;
import org.geysermc.erosion.packet.backendbound.BackendboundPacket;
import org.geysermc.erosion.util.BlockPositionIterator;
import org.geysermc.geyser.erosion.ErosionCancellationException;
import org.geysermc.geyser.erosion.GeyserboundPacketHandlerImpl;
import org.geysermc.geyser.level.GameRule;
import org.geysermc.geyser.level.WorldManager;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.GameMode;

public class GeyserWorldManager
extends WorldManager {
    private final Object2ObjectMap<String, String> gameruleCache = new Object2ObjectOpenHashMap();

    @Override
    public int getBlockAt(GeyserSession session, int x, int y, int z) {
        GeyserboundPacketHandlerImpl erosionHandler = session.getErosionHandler().getAsActive();
        if (erosionHandler == null) {
            return session.getChunkCache().getBlockAt(x, y, z);
        }
        if (session.isClosed()) {
            throw new ErosionCancellationException();
        }
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        erosionHandler.setPendingLookup(future);
        erosionHandler.sendPacket((BackendboundPacket)new BackendboundBlockRequestPacket(0, Vector3i.from((int)x, (int)y, (int)z)));
        return future.join();
    }

    @Override
    public CompletableFuture<Integer> getBlockAtAsync(GeyserSession session, int x, int y, int z) {
        GeyserboundPacketHandlerImpl erosionHandler = session.getErosionHandler().getAsActive();
        if (erosionHandler == null) {
            return super.getBlockAtAsync(session, x, y, z);
        }
        if (session.isClosed()) {
            return CompletableFuture.failedFuture(new ErosionCancellationException());
        }
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        int transactionId = erosionHandler.getNextTransactionId();
        erosionHandler.getAsyncPendingLookups().put(transactionId, future);
        erosionHandler.sendPacket((BackendboundPacket)new BackendboundBlockRequestPacket(transactionId, Vector3i.from((int)x, (int)y, (int)z)));
        return future;
    }

    @Override
    public int[] getBlocksAt(GeyserSession session, BlockPositionIterator iter) {
        GeyserboundPacketHandlerImpl erosionHandler = session.getErosionHandler().getAsActive();
        if (erosionHandler == null) {
            return super.getBlocksAt(session, iter);
        }
        if (session.isClosed()) {
            throw new ErosionCancellationException();
        }
        CompletableFuture<int[]> future = new CompletableFuture<int[]>();
        erosionHandler.setPendingBatchLookup(future);
        erosionHandler.sendPacket((BackendboundPacket)new BackendboundBatchBlockRequestPacket(iter));
        return future.join();
    }

    @Override
    public boolean hasOwnChunkCache() {
        return false;
    }

    @Override
    public void setGameRule(GeyserSession session, String name, Object value) {
        super.setGameRule(session, name, value);
        this.gameruleCache.put((Object)name, (Object)String.valueOf(value));
    }

    @Override
    public boolean getGameRuleBool(GeyserSession session, GameRule gameRule) {
        String value = (String)this.gameruleCache.get((Object)gameRule.getJavaID());
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return gameRule.getDefaultBooleanValue();
    }

    @Override
    public int getGameRuleInt(GeyserSession session, GameRule gameRule) {
        String value = (String)this.gameruleCache.get((Object)gameRule.getJavaID());
        if (value != null) {
            return Integer.parseInt(value);
        }
        return gameRule.getDefaultIntValue();
    }

    @Override
    public GameMode getDefaultGameMode(GeyserSession session) {
        return GameMode.SURVIVAL;
    }
}

