/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.SetDifficultyPacket;
import org.geysermc.cumulus.component.DropdownComponent;
import org.geysermc.cumulus.form.CustomForm;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.Permissions;
import org.geysermc.geyser.level.GameRule;
import org.geysermc.geyser.level.WorldManager;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.text.MinecraftLocale;
import org.geysermc.geyser.util.CooldownUtils;
import org.geysermc.mcprotocollib.protocol.data.game.setting.Difficulty;

public class SettingsUtils {
    public static CustomForm buildForm(GeyserSession session) {
        boolean showGamerules;
        boolean showClientSettings;
        String language = session.locale();
        CustomForm.Builder builder = ((CustomForm.Builder)((CustomForm.Builder)CustomForm.builder().translator(SettingsUtils::translateEntry, language)).title("geyser.settings.title.main")).iconPath("textures/ui/settings_glyph_color_2x.png");
        boolean showCoordinates = session.getPreferencesCache().isAllowShowCoordinates();
        boolean cooldownShown = session.getGeyser().config().gameplay().showCooldown() != CooldownUtils.CooldownType.DISABLED;
        boolean customSkulls = session.getGeyser().config().gameplay().maxVisibleCustomSkulls() != 0;
        boolean bl = showClientSettings = showCoordinates || cooldownShown || customSkulls;
        if (showClientSettings) {
            builder.label("geyser.settings.title.client");
            if (showCoordinates) {
                builder.toggle("%createWorldScreen.showCoordinates", session.getPreferencesCache().isPrefersShowCoordinates());
            }
            if (cooldownShown) {
                DropdownComponent.Builder cooldownDropdown = DropdownComponent.builder((String)"options.attackIndicator");
                CooldownUtils.CooldownType currentCooldownType = session.getPreferencesCache().getCooldownPreference();
                cooldownDropdown.option("options.attack.crosshair", currentCooldownType == CooldownUtils.CooldownType.TITLE);
                cooldownDropdown.option("options.attack.hotbar", currentCooldownType == CooldownUtils.CooldownType.ACTIONBAR);
                cooldownDropdown.option("options.off", currentCooldownType == CooldownUtils.CooldownType.DISABLED);
                builder.dropdown(cooldownDropdown);
            }
            if (customSkulls) {
                builder.toggle("geyser.settings.option.customSkulls", session.getPreferencesCache().isPrefersCustomSkulls());
            }
        }
        boolean bl2 = showGamerules = session.getOpPermissionLevel() >= 2 || session.hasPermission(Permissions.SETTINGS_GAMERULES);
        if (showGamerules) {
            builder.label("geyser.settings.title.game_rules").translator(MinecraftLocale::getLocaleString);
            WorldManager worldManager = GeyserImpl.getInstance().getWorldManager();
            for (GameRule gamerule : GameRule.VALUES) {
                if (Boolean.class.equals(gamerule.getType())) {
                    builder.toggle("gamerule." + gamerule.getJavaID(), worldManager.getGameRuleBool(session, gamerule));
                    continue;
                }
                if (!Integer.class.equals(gamerule.getType())) continue;
                builder.input("gamerule." + gamerule.getJavaID(), "", String.valueOf(worldManager.getGameRuleInt(session, gamerule)));
            }
        }
        builder.validResultHandler(response -> {
            SettingsUtils.applyDifficultyFix(session);
            if (showClientSettings) {
                if (showCoordinates && session.getPreferencesCache().isAllowShowCoordinates()) {
                    session.getPreferencesCache().setPrefersShowCoordinates((Boolean)response.next());
                    session.getPreferencesCache().updateShowCoordinates();
                }
                if (cooldownShown) {
                    CooldownUtils.CooldownType cooldownType = CooldownUtils.CooldownType.VALUES[(Integer)response.next()];
                    session.getPreferencesCache().setCooldownPreference(cooldownType);
                }
                if (customSkulls) {
                    session.getPreferencesCache().setPrefersCustomSkulls((Boolean)response.next());
                }
            }
            if (showGamerules) {
                for (GameRule gamerule : GameRule.VALUES) {
                    int value;
                    if (Boolean.class.equals(gamerule.getType())) {
                        value = ((Boolean)response.next()).booleanValue();
                        if (value == session.getGeyser().getWorldManager().getGameRuleBool(session, gamerule)) continue;
                        session.getGeyser().getWorldManager().setGameRule(session, gamerule.getJavaID(), value != 0);
                        continue;
                    }
                    if (!Integer.class.equals(gamerule.getType()) || (value = Integer.parseInt((String)response.next())) == session.getGeyser().getWorldManager().getGameRuleInt(session, gamerule)) continue;
                    session.getGeyser().getWorldManager().setGameRule(session, gamerule.getJavaID(), value);
                }
            }
        });
        builder.closedOrInvalidResultHandler($ -> SettingsUtils.applyDifficultyFix(session));
        return (CustomForm)builder.build();
    }

    private static void applyDifficultyFix(GeyserSession session) {
        if (session.getWorldCache().getDifficulty() == Difficulty.PEACEFUL) {
            SetDifficultyPacket setDifficultyPacket = new SetDifficultyPacket();
            setDifficultyPacket.setDifficulty(Difficulty.EASY.ordinal());
            session.sendUpstreamPacket((BedrockPacket)setDifficultyPacket);
        }
    }

    private static String translateEntry(String key, String locale) {
        if (key.startsWith("%")) {
            return key;
        }
        if (key.startsWith("geyser.")) {
            return GeyserLocale.getPlayerLocaleString(key, locale);
        }
        return MinecraftLocale.getLocaleString(key, locale);
    }
}

