/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.hashing;

import java.util.function.Supplier;
import org.geysermc.geyser.item.hashing.MapBuilder;
import org.geysermc.geyser.item.hashing.MinecraftHasher;
import org.geysermc.geyser.item.hashing.data.ObjectContentsType;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.Component;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.KeybindComponent;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.NBTComponent;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.ObjectComponent;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.ScoreComponent;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.SelectorComponent;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.TextComponent;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.TranslatableComponent;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.event.ClickEvent;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.event.HoverEvent;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.format.NamedTextColor;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.format.ShadowColor;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.format.Style;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.format.StyleGetter;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.format.TextColor;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.format.TextDecoration;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.object.ObjectContents;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.object.PlayerHeadObjectContents;

public interface ComponentHasher {
    public static final MinecraftHasher<Component> COMPONENT = MinecraftHasher.lazyInitialize(new Supplier<MinecraftHasher<Component>>(){

        @Override
        public MinecraftHasher<Component> get() {
            return ACTUAL_COMPONENT;
        }
    });
    public static final MinecraftHasher<PlayerHeadObjectContents.ProfileProperty> PROFILE_PROPERTY = MinecraftHasher.mapBuilder(builder -> builder.accept("name", MinecraftHasher.STRING, PlayerHeadObjectContents.ProfileProperty::name).accept("value", MinecraftHasher.STRING, PlayerHeadObjectContents.ProfileProperty::value).accept("signature", MinecraftHasher.STRING, PlayerHeadObjectContents.ProfileProperty::signature));
    public static final MinecraftHasher<PlayerHeadObjectContents> RESOLVABLE_PROFILE = MinecraftHasher.mapBuilder(builder -> builder.optionalNullable("name", MinecraftHasher.STRING, PlayerHeadObjectContents::name).optionalNullable("id", MinecraftHasher.UUID, PlayerHeadObjectContents::id).optionalList("properties", PROFILE_PROPERTY, PlayerHeadObjectContents::profileProperties).optionalNullable("texture", MinecraftHasher.KEY, PlayerHeadObjectContents::texture));
    public static final MinecraftHasher<NamedTextColor> NAMED_COLOR = MinecraftHasher.STRING.cast(NamedTextColor::toString);
    public static final MinecraftHasher<TextColor> DIRECT_COLOR = MinecraftHasher.STRING.cast(TextColor::asHexString);
    public static final MinecraftHasher<TextColor> COLOR = (value, encoder) -> {
        if (value instanceof NamedTextColor) {
            NamedTextColor named = (NamedTextColor)value;
            return NAMED_COLOR.hash(named, encoder);
        }
        return DIRECT_COLOR.hash((TextColor)value, encoder);
    };
    public static final MinecraftHasher<TextDecoration.State> DECORATION_STATE = MinecraftHasher.BOOL.cast(state -> switch (state) {
        default -> throw new IncompatibleClassChangeError();
        case TextDecoration.State.NOT_SET -> null;
        case TextDecoration.State.FALSE -> false;
        case TextDecoration.State.TRUE -> true;
    });
    public static final MinecraftHasher<ClickEvent.Action> CLICK_EVENT_ACTION = MinecraftHasher.STRING.cast(ClickEvent.Action::toString);
    public static final MinecraftHasher<ClickEvent.Payload.Text> CLICK_EVENT_TEXT_PAYLOAD = MinecraftHasher.STRING.cast(ClickEvent.Payload.Text::value);
    public static final MinecraftHasher<ClickEvent.Payload.Int> CLICK_EVENT_INT_PAYLOAD = MinecraftHasher.INT.cast(ClickEvent.Payload.Int::integer);
    public static final MinecraftHasher<ClickEvent> CLICK_EVENT = CLICK_EVENT_ACTION.dispatch("action", ClickEvent::action, action -> switch (action) {
        default -> throw new IncompatibleClassChangeError();
        case ClickEvent.Action.OPEN_URL -> builder -> builder.accept("url", CLICK_EVENT_TEXT_PAYLOAD, event -> (ClickEvent.Payload.Text)event.payload());
        case ClickEvent.Action.OPEN_FILE -> builder -> builder.accept("path", CLICK_EVENT_TEXT_PAYLOAD, event -> (ClickEvent.Payload.Text)event.payload());
        case ClickEvent.Action.RUN_COMMAND, ClickEvent.Action.SUGGEST_COMMAND -> builder -> builder.accept("command", CLICK_EVENT_TEXT_PAYLOAD, event -> (ClickEvent.Payload.Text)event.payload());
        case ClickEvent.Action.CHANGE_PAGE -> builder -> builder.accept("page", CLICK_EVENT_INT_PAYLOAD, event -> (ClickEvent.Payload.Int)event.payload());
        case ClickEvent.Action.COPY_TO_CLIPBOARD -> builder -> builder.accept("value", CLICK_EVENT_TEXT_PAYLOAD, event -> (ClickEvent.Payload.Text)event.payload());
        case ClickEvent.Action.SHOW_DIALOG, ClickEvent.Action.CUSTOM -> MapBuilder.unit();
    });
    public static final MinecraftHasher<HoverEvent.Action<?>> HOVER_EVENT_ACTION = MinecraftHasher.STRING.cast(HoverEvent.Action::toString);
    public static final MinecraftHasher<HoverEvent<?>> HOVER_EVENT = HOVER_EVENT_ACTION.dispatch("action", HoverEvent::action, action -> {
        if (action == HoverEvent.Action.SHOW_TEXT) {
            return builder -> builder.accept("value", COMPONENT, event -> (Component)event.value());
        }
        if (action == HoverEvent.Action.SHOW_ITEM) {
            return builder -> builder.accept("id", MinecraftHasher.KEY, event -> ((HoverEvent.ShowItem)event.value()).item()).accept("count", MinecraftHasher.INT, event -> ((HoverEvent.ShowItem)event.value()).count());
        }
        return builder -> builder.accept("id", MinecraftHasher.KEY, event -> ((HoverEvent.ShowEntity)event.value()).type()).accept("uuid", MinecraftHasher.UUID, event -> ((HoverEvent.ShowEntity)event.value()).id()).optionalNullable("name", COMPONENT, event -> ((HoverEvent.ShowEntity)event.value()).name());
    });
    public static final MapBuilder<Style> STYLE = builder -> builder.optionalNullable("color", COLOR, Style::color).optionalNullable("shadow_color", MinecraftHasher.INT.cast(ShadowColor::value), StyleGetter::shadowColor).optional("bold", DECORATION_STATE, style -> style.decoration(TextDecoration.BOLD), TextDecoration.State.NOT_SET).optional("italic", DECORATION_STATE, style -> style.decoration(TextDecoration.ITALIC), TextDecoration.State.NOT_SET).optional("underlined", DECORATION_STATE, style -> style.decoration(TextDecoration.UNDERLINED), TextDecoration.State.NOT_SET).optional("strikethrough", DECORATION_STATE, style -> style.decoration(TextDecoration.STRIKETHROUGH), TextDecoration.State.NOT_SET).optional("obfuscated", DECORATION_STATE, style -> style.decoration(TextDecoration.OBFUSCATED), TextDecoration.State.NOT_SET).optionalNullable("click_event", CLICK_EVENT, Style::clickEvent).optionalNullable("hover_event", HOVER_EVENT, Style::hoverEvent).optionalNullable("insertion", MinecraftHasher.STRING, Style::insertion).optionalNullable("font", MinecraftHasher.KEY, Style::font);
    public static final MinecraftHasher<TextComponent> SIMPLE_TEXT_COMPONENT = MinecraftHasher.STRING.cast(TextComponent::content);
    public static final MinecraftHasher<TextComponent> FULL_TEXT_COMPONENT = ComponentHasher.component(builder -> builder.accept("text", MinecraftHasher.STRING, TextComponent::content));
    public static final MinecraftHasher<TextComponent> TEXT_COMPONENT = MinecraftHasher.dispatch(component -> {
        if (component.children().isEmpty() && component.style().isEmpty()) {
            return SIMPLE_TEXT_COMPONENT;
        }
        return FULL_TEXT_COMPONENT;
    });
    public static final MinecraftHasher<TranslatableComponent> TRANSLATABLE_COMPONENT = ComponentHasher.component(builder -> builder.accept("translate", MinecraftHasher.STRING, TranslatableComponent::key).optionalNullable("fallback", MinecraftHasher.STRING, TranslatableComponent::fallback));
    public static final MinecraftHasher<KeybindComponent> KEYBIND_COMPONENT = ComponentHasher.component(builder -> builder.accept("keybind", MinecraftHasher.STRING, component -> component.keybind()));
    public static final MinecraftHasher<ScoreComponent> SCORE_COMPONENT = ComponentHasher.component(builder -> builder.accept("name", MinecraftHasher.STRING, ScoreComponent::name).accept("objective", MinecraftHasher.STRING, ScoreComponent::objective));
    public static final MinecraftHasher<SelectorComponent> SELECTOR_COMPONENT = ComponentHasher.component(builder -> builder.accept("selector", MinecraftHasher.STRING, SelectorComponent::pattern).optionalNullable("separator", COMPONENT, SelectorComponent::separator));
    public static final MinecraftHasher<NBTComponent<?, ?>> NBT_COMPONENT = ComponentHasher.component(builder -> builder.accept("nbt", MinecraftHasher.STRING, NBTComponent::nbtPath).optional("interpret", MinecraftHasher.BOOL, NBTComponent::interpret, false).optionalNullable("separator", COMPONENT, NBTComponent::separator));
    public static final MinecraftHasher<ObjectContentsType> OBJECT_CONTENTS_TYPE = MinecraftHasher.fromEnum(ObjectContentsType::getName);
    public static final MapBuilder<ObjectContents> OBJECT_CONTENTS = MapBuilder.dispatch("object", OBJECT_CONTENTS_TYPE, ObjectContentsType::fromContents, ObjectContentsType::mapBuilder);
    public static final MinecraftHasher<ObjectComponent> OBJECT_COMPONENT = ComponentHasher.component(builder -> builder.accept(OBJECT_CONTENTS, ObjectComponent::contents));
    public static final MinecraftHasher<Component> ACTUAL_COMPONENT = (component, encoder) -> {
        if (component instanceof TextComponent) {
            TextComponent text = (TextComponent)component;
            return TEXT_COMPONENT.hash(text, encoder);
        }
        if (component instanceof TranslatableComponent) {
            TranslatableComponent translatable = (TranslatableComponent)component;
            return TRANSLATABLE_COMPONENT.hash(translatable, encoder);
        }
        if (component instanceof KeybindComponent) {
            KeybindComponent keybind = (KeybindComponent)component;
            return KEYBIND_COMPONENT.hash(keybind, encoder);
        }
        if (component instanceof ScoreComponent) {
            ScoreComponent score = (ScoreComponent)component;
            return SCORE_COMPONENT.hash(score, encoder);
        }
        if (component instanceof SelectorComponent) {
            SelectorComponent selector = (SelectorComponent)component;
            return SELECTOR_COMPONENT.hash(selector, encoder);
        }
        if (component instanceof NBTComponent) {
            NBTComponent nbt = (NBTComponent)component;
            return NBT_COMPONENT.hash(nbt, encoder);
        }
        if (component instanceof ObjectComponent) {
            ObjectComponent object = (ObjectComponent)component;
            return OBJECT_COMPONENT.hash(object, encoder);
        }
        throw new UnsupportedOperationException("Unimplemented component hasher: " + String.valueOf(component));
    };

    private static <T extends Component> MinecraftHasher<T> component(MapBuilder<T> componentBuilder) {
        return MinecraftHasher.mapBuilder(builder -> builder.accept(componentBuilder).accept(STYLE, Component::style).optionalList("extra", COMPONENT, Component::children));
    }
}

