/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ServerboundMovePlayerPosRotPacket
implements MinecraftPacket {
    private final boolean onGround;
    private final boolean horizontalCollision;
    private final double x;
    private final double y;
    private final double z;
    private final float yaw;
    private final float pitch;

    public ServerboundMovePlayerPosRotPacket(ByteBuf in) {
        this.x = in.readDouble();
        this.y = in.readDouble();
        this.z = in.readDouble();
        this.yaw = in.readFloat();
        this.pitch = in.readFloat();
        short flags = in.readUnsignedByte();
        this.onGround = (flags & 1) != 0;
        this.horizontalCollision = (flags & 2) != 0;
    }

    @Override
    public void serialize(ByteBuf out) {
        out.writeDouble(this.x);
        out.writeDouble(this.y);
        out.writeDouble(this.z);
        out.writeFloat(this.yaw);
        out.writeFloat(this.pitch);
        int flags = 0;
        if (this.onGround) {
            flags |= 1;
        }
        if (this.horizontalCollision) {
            flags |= 2;
        }
        out.writeByte(flags);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public boolean isHorizontalCollision() {
        return this.horizontalCollision;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundMovePlayerPosRotPacket)) {
            return false;
        }
        ServerboundMovePlayerPosRotPacket other = (ServerboundMovePlayerPosRotPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isOnGround() != other.isOnGround()) {
            return false;
        }
        if (this.isHorizontalCollision() != other.isHorizontalCollision()) {
            return false;
        }
        if (Double.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Double.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (Double.compare(this.getZ(), other.getZ()) != 0) {
            return false;
        }
        if (Float.compare(this.getYaw(), other.getYaw()) != 0) {
            return false;
        }
        return Float.compare(this.getPitch(), other.getPitch()) == 0;
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundMovePlayerPosRotPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOnGround() ? 79 : 97);
        result = result * 59 + (this.isHorizontalCollision() ? 79 : 97);
        long $x = Double.doubleToLongBits(this.getX());
        result = result * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.getY());
        result = result * 59 + (int)($y >>> 32 ^ $y);
        long $z = Double.doubleToLongBits(this.getZ());
        result = result * 59 + (int)($z >>> 32 ^ $z);
        result = result * 59 + Float.floatToIntBits(this.getYaw());
        result = result * 59 + Float.floatToIntBits(this.getPitch());
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundMovePlayerPosRotPacket(onGround=" + this.isOnGround() + ", horizontalCollision=" + this.isHorizontalCollision() + ", x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", yaw=" + this.getYaw() + ", pitch=" + this.getPitch() + ")";
    }

    public @NonNull ServerboundMovePlayerPosRotPacket withOnGround(boolean onGround) {
        return this.onGround == onGround ? this : new ServerboundMovePlayerPosRotPacket(onGround, this.horizontalCollision, this.x, this.y, this.z, this.yaw, this.pitch);
    }

    public @NonNull ServerboundMovePlayerPosRotPacket withHorizontalCollision(boolean horizontalCollision) {
        return this.horizontalCollision == horizontalCollision ? this : new ServerboundMovePlayerPosRotPacket(this.onGround, horizontalCollision, this.x, this.y, this.z, this.yaw, this.pitch);
    }

    public @NonNull ServerboundMovePlayerPosRotPacket withX(double x) {
        return this.x == x ? this : new ServerboundMovePlayerPosRotPacket(this.onGround, this.horizontalCollision, x, this.y, this.z, this.yaw, this.pitch);
    }

    public @NonNull ServerboundMovePlayerPosRotPacket withY(double y) {
        return this.y == y ? this : new ServerboundMovePlayerPosRotPacket(this.onGround, this.horizontalCollision, this.x, y, this.z, this.yaw, this.pitch);
    }

    public @NonNull ServerboundMovePlayerPosRotPacket withZ(double z) {
        return this.z == z ? this : new ServerboundMovePlayerPosRotPacket(this.onGround, this.horizontalCollision, this.x, this.y, z, this.yaw, this.pitch);
    }

    public @NonNull ServerboundMovePlayerPosRotPacket withYaw(float yaw) {
        return this.yaw == yaw ? this : new ServerboundMovePlayerPosRotPacket(this.onGround, this.horizontalCollision, this.x, this.y, this.z, yaw, this.pitch);
    }

    public @NonNull ServerboundMovePlayerPosRotPacket withPitch(float pitch) {
        return this.pitch == pitch ? this : new ServerboundMovePlayerPosRotPacket(this.onGround, this.horizontalCollision, this.x, this.y, this.z, this.yaw, pitch);
    }

    public ServerboundMovePlayerPosRotPacket(boolean onGround, boolean horizontalCollision, double x, double y, double z, float yaw, float pitch) {
        this.onGround = onGround;
        this.horizontalCollision = horizontalCollision;
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
    }
}

