/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.bedrock.util;

import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.protocol.bedrock.util.EncryptionUtils;
import org.cloudburstmc.protocol.bedrock.util.JsonUtils;
import org.jose4j.json.JsonUtil;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.lang.JoseException;

public final class ChainValidationResult {
    private final boolean signed;
    private final Map<String, Object> parsedPayload;
    private final JwtContext jwtContext;
    private IdentityClaims identityClaims;

    public ChainValidationResult(boolean signed, String rawPayload) throws JoseException {
        this(signed, JsonUtil.parseJson(rawPayload));
    }

    public ChainValidationResult(boolean signed, Map<String, Object> parsedPayload) {
        this.signed = signed;
        this.parsedPayload = Objects.requireNonNull(parsedPayload);
        this.jwtContext = null;
    }

    public ChainValidationResult(boolean signed, JwtContext context) {
        this.signed = signed;
        this.jwtContext = Objects.requireNonNull(context);
        this.parsedPayload = null;
    }

    public boolean signed() {
        return this.signed;
    }

    public Map<String, Object> rawIdentityClaims() {
        if (this.parsedPayload == null) {
            return this.jwtContext.getJwtClaims().getClaimsMap();
        }
        return new HashMap<String, Object>(this.parsedPayload);
    }

    public IdentityClaims identityClaims() throws IllegalStateException {
        if (this.identityClaims == null) {
            this.identityClaims = this.parsedPayload == null ? this.createClaims() : this.createLegacyClaims();
        }
        return this.identityClaims;
    }

    private IdentityClaims createLegacyClaims() {
        UUID identity;
        String identityPublicKey = JsonUtils.childAsType(this.parsedPayload, "identityPublicKey", String.class);
        Map extraData = JsonUtils.childAsType(this.parsedPayload, "extraData", Map.class);
        String displayName = JsonUtils.childAsType(extraData, "displayName", String.class);
        String identityString = JsonUtils.childAsType(extraData, "identity", String.class);
        String xuid = JsonUtils.childAsType(extraData, "XUID", String.class);
        Object titleId = extraData.get("titleId");
        try {
            identity = UUID.fromString(identityString);
        }
        catch (Exception exception) {
            throw new IllegalStateException("identity node is an invalid UUID");
        }
        return new IdentityClaims(new IdentityData(displayName, identity, xuid, (String)titleId, null), identityPublicKey);
    }

    private IdentityClaims createClaims() {
        JwtClaims claims = this.jwtContext.getJwtClaims();
        String identityPublicKey = claims.getClaimValueAsString("cpk");
        String displayName = claims.getClaimValueAsString("xname");
        String xuid = claims.getClaimValueAsString("xid");
        String minecraftId = claims.getClaimValueAsString("mid");
        UUID identity = UUID.nameUUIDFromBytes(xuid.getBytes(StandardCharsets.UTF_8));
        return new IdentityClaims(new IdentityData(displayName, identity, xuid, null, minecraftId), identityPublicKey);
    }

    public static final class IdentityData {
        public final String displayName;
        public final @Nullable UUID identity;
        public final String xuid;
        public final @Nullable String titleId;
        public final @Nullable String minecraftId;

        private IdentityData(String displayName, UUID identity, String xuid, @Nullable String titleId, @Nullable String minecraftId) {
            this.displayName = displayName;
            this.identity = identity;
            this.xuid = xuid;
            this.titleId = titleId;
            this.minecraftId = minecraftId;
        }
    }

    public static final class IdentityClaims {
        public final IdentityData extraData;
        public final String identityPublicKey;
        private PublicKey parsedIdentityPublicKey;

        private IdentityClaims(IdentityData extraData, String identityPublicKey) {
            this.extraData = extraData;
            this.identityPublicKey = identityPublicKey;
        }

        public PublicKey parsedIdentityPublicKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
            if (this.parsedIdentityPublicKey == null) {
                this.parsedIdentityPublicKey = EncryptionUtils.parseKey(this.identityPublicKey);
            }
            return this.parsedIdentityPublicKey;
        }
    }
}

