/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.cumulus.form.impl;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.util.FormBuilder;
import org.geysermc.cumulus.response.FormResponse;
import org.geysermc.cumulus.response.result.FormResponseResult;
import org.geysermc.cumulus.response.result.InvalidFormResponseResult;
import org.geysermc.cumulus.response.result.ResultType;
import org.geysermc.cumulus.response.result.ValidFormResponseResult;

public abstract class FormImpl<R extends FormResponse>
implements Form {
    protected Consumer<FormResponseResult<R>> responseHandler;
    protected Consumer<@Nullable String> rawResponseConsumer;
    private final String title;

    public FormImpl(@NonNull String title) {
        this.title = Objects.requireNonNull(title, "title");
    }

    public boolean callRawResponseConsumer(@Nullable String responseData) throws Exception {
        if (this.rawResponseConsumer != null) {
            this.rawResponseConsumer.accept(responseData);
            return true;
        }
        return false;
    }

    public void rawResponseConsumer(Consumer<@Nullable String> rawResponseConsumer) {
        this.rawResponseConsumer = rawResponseConsumer;
    }

    public void callResultHandler(@Nullable FormResponseResult<R> response) throws Exception {
        if (this.responseHandler != null) {
            this.responseHandler.accept(response);
        }
    }

    public void resultHandler(@NonNull Consumer<FormResponseResult<R>> responseHandler) {
        this.responseHandler = Objects.requireNonNull(responseHandler);
    }

    @Override
    public @NonNull String title() {
        return this.title;
    }

    public static abstract class Builder<B extends FormBuilder<B, F, R>, F extends Form, R extends FormResponse>
    implements FormBuilder<B, F, R> {
        protected String title = "";
        protected BiFunction<String, String, String> translationHandler = null;
        protected String locale;
        protected BiConsumer<F, FormResponseResult<R>> selectedResultHandler;
        protected Runnable closedResultHandlerRunnable;
        protected Consumer<F> closedResultHandlerConsumer;
        protected Runnable invalidResultHandlerRunnable;
        protected Consumer<InvalidFormResponseResult<R>> invalidResultHandlerConsumer;
        protected BiConsumer<F, InvalidFormResponseResult<R>> invalidResultHandlerBiConsumer;
        protected Runnable closedOrInvalidResultHandlerRunnable;
        protected Consumer<FormResponseResult<R>> closedOrInvalidResultHandlerConsumer;
        protected BiConsumer<F, FormResponseResult<R>> closedOrInvalidResultHandlerBiConsumer;
        protected Consumer<R> validResultHandlerConsumer;
        protected BiConsumer<F, R> validResultHandlerBiConsumer;

        @Override
        public B title(@NonNull String title) {
            this.title = this.translate(Objects.requireNonNull(title, "title"));
            return this.self();
        }

        @Override
        public B translator(@NonNull BiFunction<String, String, String> translator, @NonNull String locale) {
            this.translationHandler = Objects.requireNonNull(translator, "translator");
            this.locale = Objects.requireNonNull(locale, "locale");
            return this.title(this.title);
        }

        @Override
        public B translator(@NonNull BiFunction<String, String, String> translator) {
            return this.translator(translator, this.locale);
        }

        @Override
        public B closedResultHandler(@NonNull Consumer<F> resultHandler) {
            this.closedResultHandlerConsumer = Objects.requireNonNull(resultHandler, "resultHandler");
            return this.self();
        }

        @Override
        public B closedResultHandler(@NonNull Runnable resultHandler) {
            this.closedResultHandlerRunnable = Objects.requireNonNull(resultHandler, "resultHandler");
            return this.self();
        }

        @Override
        public B invalidResultHandler(@NonNull Runnable resultHandler) {
            this.invalidResultHandlerRunnable = Objects.requireNonNull(resultHandler, "resultHandler");
            return this.self();
        }

        @Override
        public B invalidResultHandler(@NonNull Consumer<InvalidFormResponseResult<R>> resultHandler) {
            this.invalidResultHandlerConsumer = Objects.requireNonNull(resultHandler, "resultHandler");
            return this.self();
        }

        @Override
        public B invalidResultHandler(@NonNull BiConsumer<F, InvalidFormResponseResult<R>> resultHandler) {
            this.invalidResultHandlerBiConsumer = Objects.requireNonNull(resultHandler, "resultHandler");
            return this.self();
        }

        @Override
        public B closedOrInvalidResultHandler(@NonNull Runnable resultHandler) {
            this.closedOrInvalidResultHandlerRunnable = Objects.requireNonNull(resultHandler, "resultHandler");
            return this.self();
        }

        @Override
        public B closedOrInvalidResultHandler(@NonNull Consumer<FormResponseResult<R>> resultHandler) {
            this.closedOrInvalidResultHandlerConsumer = Objects.requireNonNull(resultHandler, "resultHandler");
            return this.self();
        }

        @Override
        public B closedOrInvalidResultHandler(@NonNull BiConsumer<F, FormResponseResult<R>> resultHandler) {
            this.closedOrInvalidResultHandlerBiConsumer = Objects.requireNonNull(resultHandler, "resultHandler");
            return this.self();
        }

        @Override
        public B validResultHandler(@NonNull Consumer<R> resultHandler) {
            this.validResultHandlerConsumer = Objects.requireNonNull(resultHandler, "resultHandler");
            return this.self();
        }

        @Override
        public B validResultHandler(@NonNull BiConsumer<F, R> resultHandler) {
            this.validResultHandlerBiConsumer = Objects.requireNonNull(resultHandler, "resultHandler");
            return this.self();
        }

        @Override
        public B resultHandler(@NonNull BiConsumer<F, FormResponseResult<R>> resultHandler) {
            this.selectedResultHandler = Objects.requireNonNull(resultHandler, "resultHandler");
            return this.self();
        }

        @Override
        public B resultHandler(@NonNull BiConsumer<F, FormResponseResult<R>> resultHandler, @NonNull ResultType[] selectedTypes) {
            Objects.requireNonNull(resultHandler, "resultHandler");
            Objects.requireNonNull(selectedTypes, "selectedTypes");
            if (selectedTypes.length == 0) {
                return this.self();
            }
            EnumSet<ResultType> selected = EnumSet.noneOf(ResultType.class);
            selected.addAll(Arrays.asList(selectedTypes));
            this.selectedResultHandler = (form, response) -> {
                if (selected.contains((Object)response.responseType())) {
                    resultHandler.accept((Object)form, (FormResponseResult)response);
                }
            };
            return this.self();
        }

        @Override
        public abstract @NonNull F build();

        protected void setResponseHandler(FormImpl<R> impl, F form) {
            impl.resultHandler((FormResponseResult<R> result) -> {
                if (this.selectedResultHandler != null) {
                    this.selectedResultHandler.accept(form, (FormResponseResult<R>)result);
                }
                if (result.isClosed()) {
                    if (this.closedResultHandlerRunnable != null) {
                        this.closedResultHandlerRunnable.run();
                    }
                    if (this.closedResultHandlerConsumer != null) {
                        this.closedResultHandlerConsumer.accept(form);
                    }
                    if (this.closedOrInvalidResultHandlerRunnable != null) {
                        this.closedOrInvalidResultHandlerRunnable.run();
                    }
                    if (this.closedOrInvalidResultHandlerConsumer != null) {
                        this.closedOrInvalidResultHandlerConsumer.accept((FormResponseResult<R>)result);
                    }
                    if (this.closedOrInvalidResultHandlerBiConsumer != null) {
                        this.closedOrInvalidResultHandlerBiConsumer.accept(form, (FormResponseResult<R>)result);
                    }
                }
                if (result.isInvalid()) {
                    if (this.invalidResultHandlerRunnable != null) {
                        this.invalidResultHandlerRunnable.run();
                    }
                    if (this.invalidResultHandlerConsumer != null) {
                        this.invalidResultHandlerConsumer.accept((InvalidFormResponseResult)result);
                    }
                    if (this.invalidResultHandlerBiConsumer != null) {
                        this.invalidResultHandlerBiConsumer.accept(form, (InvalidFormResponseResult)result);
                    }
                    if (this.closedResultHandlerRunnable != null) {
                        this.closedResultHandlerRunnable.run();
                    }
                    if (this.closedOrInvalidResultHandlerConsumer != null) {
                        this.closedOrInvalidResultHandlerConsumer.accept((FormResponseResult<R>)result);
                    }
                    if (this.closedOrInvalidResultHandlerBiConsumer != null) {
                        this.closedOrInvalidResultHandlerBiConsumer.accept(form, (FormResponseResult<R>)result);
                    }
                }
                if (result.isValid()) {
                    Object response = ((ValidFormResponseResult)result).response();
                    if (this.validResultHandlerConsumer != null) {
                        this.validResultHandlerConsumer.accept(response);
                    }
                    if (this.validResultHandlerBiConsumer != null) {
                        this.validResultHandlerBiConsumer.accept(form, response);
                    }
                }
            });
        }

        protected @NonNull String translate(@NonNull String text) {
            Objects.requireNonNull(text, "text");
            if (this.translationHandler != null && !text.isEmpty()) {
                String result = this.translationHandler.apply(text, this.locale);
                return result != null ? result : text;
            }
            return text;
        }

        protected B self() {
            return (B)this;
        }
    }
}

