/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory;

import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerSlotType;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequestSlotData;
import org.geysermc.geyser.inventory.BedrockContainerSlot;
import org.geysermc.geyser.inventory.Container;
import org.geysermc.geyser.inventory.updater.InventoryUpdater;
import org.geysermc.geyser.inventory.updater.UIInventoryUpdater;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.translator.inventory.AbstractBlockInventoryTranslator;

public class SmithingInventoryTranslator
extends AbstractBlockInventoryTranslator<Container> {
    public static final int TEMPLATE = 0;
    public static final int INPUT = 1;
    public static final int MATERIAL = 2;
    public static final int OUTPUT = 3;

    public SmithingInventoryTranslator() {
        super(4, Blocks.SMITHING_TABLE, ContainerType.SMITHING_TABLE, (InventoryUpdater)UIInventoryUpdater.INSTANCE, new Block[0]);
    }

    @Override
    public int bedrockSlotToJava(ItemStackRequestSlotData slotInfoData) {
        return switch (slotInfoData.getContainerName().getContainer()) {
            case ContainerSlotType.SMITHING_TABLE_TEMPLATE -> 0;
            case ContainerSlotType.SMITHING_TABLE_INPUT -> 1;
            case ContainerSlotType.SMITHING_TABLE_MATERIAL -> 2;
            case ContainerSlotType.SMITHING_TABLE_RESULT, ContainerSlotType.CREATED_OUTPUT -> 3;
            default -> super.bedrockSlotToJava(slotInfoData);
        };
    }

    @Override
    public BedrockContainerSlot javaSlotToBedrockContainer(int slot, Container container) {
        return switch (slot) {
            case 0 -> new BedrockContainerSlot(ContainerSlotType.SMITHING_TABLE_TEMPLATE, 53);
            case 1 -> new BedrockContainerSlot(ContainerSlotType.SMITHING_TABLE_INPUT, 51);
            case 2 -> new BedrockContainerSlot(ContainerSlotType.SMITHING_TABLE_MATERIAL, 52);
            case 3 -> new BedrockContainerSlot(ContainerSlotType.SMITHING_TABLE_RESULT, 50);
            default -> super.javaSlotToBedrockContainer(slot, container);
        };
    }

    @Override
    public int javaSlotToBedrock(int slot) {
        return switch (slot) {
            case 0 -> 53;
            case 1 -> 51;
            case 2 -> 52;
            case 3 -> 50;
            default -> super.javaSlotToBedrock(slot);
        };
    }

    @Override
    public ContainerType closeContainerType(Container container) {
        return null;
    }
}

