/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.properties.type;

import java.util.List;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.geyser.api.util.Identifier;
import org.geysermc.geyser.entity.properties.type.PropertyType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.IntEntityProperty;

public interface AbstractEnumProperty<T>
extends PropertyType<T, IntEntityProperty> {
    public static final Pattern VALUE_VALIDATION_REGEX = Pattern.compile("^[A-Za-z][A-Za-z0-9_]{0,31}$");

    @Override
    default public NbtMap nbtMap() {
        return NbtMap.builder().putString("name", this.identifier().toString()).putList("enum", NbtType.STRING, this.allBedrockValues()).putInt("type", 3).build();
    }

    default public void validateAllValues(Identifier name, List<String> values) {
        if (values.size() > 16) {
            throw new IllegalArgumentException("Cannot register enum property with name " + String.valueOf(name) + " because it has more than 16 values!");
        }
        for (String value : values) {
            if (VALUE_VALIDATION_REGEX.matcher(value).matches()) continue;
            throw new IllegalArgumentException("Cannot register enum property with name " + String.valueOf(name) + " and value " + value + " because enum values can only contain alphanumeric characters and underscores.");
        }
    }

    public List<String> allBedrockValues();

    @Override
    default public IntEntityProperty defaultValue(int index) {
        return new IntEntityProperty(index, this.defaultIndex());
    }

    @Override
    default public IntEntityProperty createValue(int index, @Nullable T value) {
        if (value == null) {
            return this.defaultValue(index);
        }
        int valueIndex = this.indexOf(value);
        if (valueIndex == -1) {
            throw new IllegalArgumentException("Enum value " + String.valueOf(value) + " is not a valid enum value!");
        }
        return new IntEntityProperty(index, valueIndex);
    }

    public int indexOf(T var1);

    public int defaultIndex();
}

