/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.title;

import org.cloudburstmc.protocol.bedrock.packet.SetTitlePacket;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.title.ClientboundSetTitlesAnimationPacket;

@Translator(packet=ClientboundSetTitlesAnimationPacket.class)
public class JavaSetTitlesAnimationTranslator
extends PacketTranslator<ClientboundSetTitlesAnimationPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundSetTitlesAnimationPacket packet) {
        int fadeInTime = packet.getFadeIn();
        int stayTime = packet.getStay();
        int fadeOutTime = packet.getFadeOut();
        session.getWorldCache().setTitleTimes(fadeInTime, stayTime, fadeOutTime);
        int tickrateMultiplier = Math.round(session.getMillisecondsPerTick()) / 50;
        SetTitlePacket titlePacket = new SetTitlePacket();
        titlePacket.setType(SetTitlePacket.Type.TIMES);
        titlePacket.setText("");
        titlePacket.setFadeInTime(fadeInTime * tickrateMultiplier);
        titlePacket.setFadeOutTime(fadeOutTime * tickrateMultiplier);
        titlePacket.setStayTime(stayTime * tickrateMultiplier);
        titlePacket.setXuid("");
        titlePacket.setPlatformOnlineId("");
        session.sendUpstreamPacket(titlePacket);
    }
}

