/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.msa.request;

import java.net.MalformedURLException;
import java.util.HashMap;
import net.lenni0451.commons.gson.elements.GsonObject;
import net.lenni0451.commons.httpclient.HttpResponse;
import net.lenni0451.commons.httpclient.content.impl.URLEncodedFormContent;
import net.lenni0451.commons.httpclient.requests.impl.PostRequest;
import net.raphimc.minecraftauth.msa.model.MsaApplicationConfig;
import net.raphimc.minecraftauth.msa.model.MsaDeviceCode;
import net.raphimc.minecraftauth.msa.model.MsaToken;
import net.raphimc.minecraftauth.msa.responsehandler.MsaResponseHandler;

public class MsaDeviceCodeTokenRequest
extends PostRequest
implements MsaResponseHandler<MsaToken> {
    public MsaDeviceCodeTokenRequest(MsaApplicationConfig applicationConfig, MsaDeviceCode deviceCode) throws MalformedURLException {
        this(applicationConfig, deviceCode.getDeviceCode());
    }

    public MsaDeviceCodeTokenRequest(MsaApplicationConfig applicationConfig, String deviceCode) throws MalformedURLException {
        super(applicationConfig.getEnvironment().getTokenUrl());
        HashMap<String, String> postData = new HashMap<String, String>();
        postData.put("client_id", applicationConfig.getClientId());
        postData.put("grant_type", "device_code");
        postData.put("device_code", deviceCode);
        this.setContent(new URLEncodedFormContent(postData));
    }

    @Override
    public MsaToken handle(HttpResponse response, GsonObject json) {
        return new MsaToken(System.currentTimeMillis() + (long)json.reqInt("expires_in") * 1000L, json.reqString("access_token"), json.getString("refresh_token", null));
    }
}

