/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser;

import io.netty.channel.epoll.Epoll;
import io.netty.util.NettyRuntime;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.internal.SystemPropertyUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.security.Key;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.protocol.bedrock.util.EncryptionUtils;
import org.geysermc.api.Geyser;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.util.FormBuilder;
import org.geysermc.erosion.packet.Packets;
import org.geysermc.floodgate.crypto.AesCipher;
import org.geysermc.floodgate.crypto.AesKeyProducer;
import org.geysermc.floodgate.crypto.Base64Topping;
import org.geysermc.floodgate.crypto.FloodgateCipher;
import org.geysermc.floodgate.news.NewsItemAction;
import org.geysermc.geyser.BuildData;
import org.geysermc.geyser.GeyserBootstrap;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.Permissions;
import org.geysermc.geyser.api.GeyserApi;
import org.geysermc.geyser.api.command.CommandSource;
import org.geysermc.geyser.api.event.EventRegistrar;
import org.geysermc.geyser.api.event.lifecycle.GeyserPostInitializeEvent;
import org.geysermc.geyser.api.event.lifecycle.GeyserPostReloadEvent;
import org.geysermc.geyser.api.event.lifecycle.GeyserPreInitializeEvent;
import org.geysermc.geyser.api.event.lifecycle.GeyserPreReloadEvent;
import org.geysermc.geyser.api.event.lifecycle.GeyserRegisterPermissionsEvent;
import org.geysermc.geyser.api.event.lifecycle.GeyserShutdownEvent;
import org.geysermc.geyser.api.network.AuthType;
import org.geysermc.geyser.api.network.BedrockListener;
import org.geysermc.geyser.api.network.RemoteServer;
import org.geysermc.geyser.api.util.MinecraftVersion;
import org.geysermc.geyser.api.util.PlatformType;
import org.geysermc.geyser.command.CommandRegistry;
import org.geysermc.geyser.configuration.GeyserConfiguration;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.erosion.UnixSocketClientListener;
import org.geysermc.geyser.event.GeyserEventBus;
import org.geysermc.geyser.event.type.SessionDisconnectEventImpl;
import org.geysermc.geyser.extension.GeyserExtensionManager;
import org.geysermc.geyser.impl.MinecraftVersionImpl;
import org.geysermc.geyser.level.BedrockDimension;
import org.geysermc.geyser.level.WorldManager;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.network.netty.GeyserServer;
import org.geysermc.geyser.platform.spigot.shaded.com.fasterxml.jackson.core.JsonParser;
import org.geysermc.geyser.platform.spigot.shaded.com.fasterxml.jackson.core.type.TypeReference;
import org.geysermc.geyser.platform.spigot.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import org.geysermc.geyser.platform.spigot.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.Component;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.format.NamedTextColor;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.format.TextColor;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.loader.ResourcePackLoader;
import org.geysermc.geyser.registry.provider.ProviderSupplier;
import org.geysermc.geyser.scoreboard.ScoreboardUpdater;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.PendingMicrosoftAuthentication;
import org.geysermc.geyser.session.SessionDisconnectListener;
import org.geysermc.geyser.session.SessionManager;
import org.geysermc.geyser.session.cache.RegistryCache;
import org.geysermc.geyser.skin.FloodgateSkinUploader;
import org.geysermc.geyser.skin.ProvidedSkins;
import org.geysermc.geyser.skin.SkinProvider;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.text.MinecraftLocale;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.geyser.util.AssetUtils;
import org.geysermc.geyser.util.CodeOfConductManager;
import org.geysermc.geyser.util.CooldownUtils;
import org.geysermc.geyser.util.Metrics;
import org.geysermc.geyser.util.NewsHandler;
import org.geysermc.geyser.util.VersionCheckUtils;
import org.geysermc.geyser.util.WebUtils;

public class GeyserImpl
implements GeyserApi,
EventRegistrar {
    public static final ObjectMapper JSON_MAPPER = new ObjectMapper().enable(JsonParser.Feature.IGNORE_UNDEFINED).enable(JsonParser.Feature.ALLOW_COMMENTS).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).enable(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES).enable(JsonParser.Feature.ALLOW_SINGLE_QUOTES);
    public static final String NAME = "Geyser";
    public static final String GIT_VERSION = "git-master-d5b0091";
    public static final String VERSION = "2.9.0-b977 (git-master-d5b0091)";
    public static final String BUILD_NUMBER = "977";
    public static final String BRANCH = "master";
    public static final String COMMIT = "d5b0091108aa852a5359cddb81310a9649c90c52";
    public static final String REPOSITORY = "https://github.com/GeyserMC/Geyser";
    public static final boolean IS_DEV = BuildData.isDevBuild();
    public static final String OAUTH_CLIENT_ID = "204cefd1-4818-4de1-b98d-513fae875d88";
    private static final Pattern IP_REGEX = Pattern.compile("\\b\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\b");
    private final SessionManager sessionManager = new SessionManager();
    private FloodgateCipher cipher;
    private FloodgateSkinUploader skinUploader;
    private NewsHandler newsHandler;
    private UnixSocketClientListener erosionUnixListener;
    private volatile boolean shuttingDown = false;
    private ScheduledExecutorService scheduledThread;
    private GeyserServer geyserServer;
    private final PlatformType platformType;
    private final GeyserBootstrap bootstrap;
    private final GeyserEventBus eventBus;
    private final GeyserExtensionManager extensionManager;
    private Metrics metrics;
    private PendingMicrosoftAuthentication pendingMicrosoftAuthentication;
    private Map<String, String> savedAuthChains;
    private static GeyserImpl instance;
    private boolean isReloading;
    private boolean isEnabled;

    private GeyserImpl(PlatformType platformType, GeyserBootstrap bootstrap) {
        instance = this;
        Geyser.set(this);
        this.platformType = platformType;
        this.bootstrap = bootstrap;
        this.eventBus = new GeyserEventBus();
        this.extensionManager = new GeyserExtensionManager();
        GeyserLocale.finalizeDefaultLocale(this);
        this.extensionManager.init();
        this.eventBus.fire(new GeyserPreInitializeEvent(this.extensionManager, this.eventBus));
    }

    public void initialize() {
        try {
            EncryptionUtils.getMojangPublicKey();
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot setup authentication! Are you offline? ", e);
        }
        long startupTime = System.currentTimeMillis();
        GeyserLogger logger = this.bootstrap.getGeyserLogger();
        logger.info("******************************************");
        logger.info("");
        logger.info(GeyserLocale.getLocaleStringLog("geyser.core.load", NAME, VERSION));
        logger.info("");
        if (IS_DEV) {
            logger.info(GeyserLocale.getLocaleStringLog("geyser.core.dev_build", "https://discord.gg/geysermc"));
            logger.info("");
        }
        logger.info("******************************************");
        Registries.load();
        BlockRegistries.populate();
        Registries.populate();
        RegistryCache.init();
        EntityDefinitions.init();
        MessageTranslator.init();
        AssetUtils.generateAssetCache().whenComplete((aVoid, ex) -> {
            if (ex != null) {
                return;
            }
            MinecraftLocale.ensureEN_US();
            String locale = GeyserLocale.getDefaultLocale();
            if (!"en_us".equals(locale)) {
                MinecraftLocale.downloadAndLoadLocale(locale);
            }
            ProvidedSkins.init();
            CompletableFuture.runAsync(AssetUtils::downloadAndRunClientJarTasks);
        });
        this.eventBus.subscribe(this, GeyserRegisterPermissionsEvent.class, Permissions::register);
        this.eventBus.subscribe(this, SessionDisconnectEventImpl.class, SessionDisconnectListener::onSessionDisconnect);
        this.startInstance();
        GeyserConfiguration config = this.bootstrap.getGeyserConfig();
        double completeTime = (double)(System.currentTimeMillis() - startupTime) / 1000.0;
        Object message = GeyserLocale.getLocaleStringLog("geyser.core.finish.done", new DecimalFormat("#.###").format(completeTime));
        message = (String)message + " " + GeyserLocale.getLocaleStringLog("geyser.core.finish.console");
        logger.info((String)message);
        if (this.platformType == PlatformType.STANDALONE) {
            if (config.getRemote().authType() != AuthType.FLOODGATE) {
                logger.warning(GeyserLocale.getLocaleStringLog("geyser.core.movement_warn"));
            }
        } else if (config.getRemote().authType() == AuthType.FLOODGATE) {
            VersionCheckUtils.checkForOutdatedFloodgate(logger);
        }
        VersionCheckUtils.checkForOutdatedJava(logger);
    }

    private void startInstance() {
        String[] record;
        String remoteAddress;
        String broadcastPort;
        String pluginUdpPort;
        this.scheduledThread = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("Geyser Scheduled Thread"));
        if (this.isReloading) {
            GeyserLocale.finalizeDefaultLocale(this);
        } else {
            CodeOfConductManager.load();
        }
        GeyserLogger logger = this.bootstrap.getGeyserLogger();
        GeyserConfiguration config = this.bootstrap.getGeyserConfig();
        ScoreboardUpdater.init();
        SkinProvider.registerCacheImageTask(this);
        Registries.RESOURCE_PACKS.load();
        String geyserUdpPort = System.getProperty("geyserUdpPort", "");
        String string = pluginUdpPort = geyserUdpPort.isEmpty() ? System.getProperty("pluginUdpPort", "") : geyserUdpPort;
        if ("-1".equals(pluginUdpPort)) {
            throw new UnsupportedOperationException("This hosting/service provider does not support applications running on the UDP port");
        }
        boolean portPropertyApplied = false;
        String pluginUdpAddress = System.getProperty("geyserUdpAddress", System.getProperty("pluginUdpAddress", ""));
        if (this.platformType != PlatformType.STANDALONE) {
            int javaPort = this.bootstrap.getServerPort();
            if (config.getRemote().address().equals("auto")) {
                config.setAutoconfiguredRemote(true);
                String serverAddress = this.bootstrap.getServerBindAddress();
                if (!serverAddress.isEmpty() && !"0.0.0.0".equals(serverAddress)) {
                    config.getRemote().setAddress(serverAddress);
                } else {
                    try {
                        config.getRemote().setAddress(InetAddress.getLocalHost().getHostAddress());
                    }
                    catch (UnknownHostException ex) {
                        logger.debug("Unknown host when trying to find localhost.");
                        if (config.isDebugMode()) {
                            ex.printStackTrace();
                        }
                        config.getRemote().setAddress(InetAddress.getLoopbackAddress().getHostAddress());
                    }
                }
                if (javaPort != -1) {
                    config.getRemote().setPort(javaPort);
                }
            }
            boolean forceMatchServerPort = "server".equals(pluginUdpPort);
            if ((config.getBedrock().isCloneRemotePort() || forceMatchServerPort) && javaPort != -1) {
                config.getBedrock().setPort(javaPort);
                if (forceMatchServerPort) {
                    if (geyserUdpPort.isEmpty()) {
                        logger.info("Port set from system generic property to match Java server.");
                    } else {
                        logger.info("Port set from system property to match Java server.");
                    }
                    portPropertyApplied = true;
                }
            }
            if ("server".equals(pluginUdpAddress)) {
                String address = this.bootstrap.getServerBindAddress();
                if (!address.isEmpty()) {
                    config.getBedrock().setAddress(address);
                }
            } else if (!pluginUdpAddress.isEmpty()) {
                config.getBedrock().setAddress(pluginUdpAddress);
            }
            if (!portPropertyApplied && !pluginUdpPort.isEmpty()) {
                int port = Integer.parseInt(pluginUdpPort);
                config.getBedrock().setPort(port);
                if (geyserUdpPort.isEmpty()) {
                    logger.info("Port set from generic system property: " + port);
                } else {
                    logger.info("Port set from system property: " + port);
                }
            }
            if (this.platformType != PlatformType.VIAPROXY) {
                boolean floodgatePresent = this.bootstrap.testFloodgatePluginPresent();
                if (config.getRemote().authType() == AuthType.FLOODGATE && !floodgatePresent) {
                    logger.severe(GeyserLocale.getLocaleStringLog("geyser.bootstrap.floodgate.not_installed") + " " + GeyserLocale.getLocaleStringLog("geyser.bootstrap.floodgate.disabling"));
                    return;
                }
                if (config.isAutoconfiguredRemote() && floodgatePresent) {
                    logger.debug("Auto-setting to Floodgate authentication.");
                    config.getRemote().setAuthType(AuthType.FLOODGATE);
                }
            }
        }
        if (!(broadcastPort = System.getProperty("geyserBroadcastPort", "")).isEmpty()) {
            try {
                int parsedPort = Integer.parseInt(broadcastPort);
                if (parsedPort < 1 || parsedPort > 65535) {
                    throw new NumberFormatException("The broadcast port must be between 1 and 65535 inclusive!");
                }
                config.getBedrock().setBroadcastPort(parsedPort);
                logger.info("Broadcast port set from system property: " + parsedPort);
            }
            catch (NumberFormatException e) {
                logger.error(String.format("Invalid broadcast port from system property: %s! Defaulting to configured port.", broadcastPort + " (" + e.getMessage() + ")"));
            }
        }
        if (config.getBedrock().broadcastPort() == 0) {
            config.getBedrock().setBroadcastPort(config.getBedrock().port());
        }
        if (!IP_REGEX.matcher(remoteAddress = config.getRemote().address()).matches() && !remoteAddress.equalsIgnoreCase("localhost") && (record = WebUtils.findSrvRecord(this, remoteAddress)) != null) {
            int remotePort = Integer.parseInt(record[2]);
            remoteAddress = record[3];
            config.getRemote().setAddress(remoteAddress);
            config.getRemote().setPort(remotePort);
            logger.debug("Found SRV record \"" + remoteAddress + ":" + remotePort + "\"");
        }
        this.pendingMicrosoftAuthentication = new PendingMicrosoftAuthentication(config.getPendingAuthenticationTimeout());
        this.newsHandler = new NewsHandler(BRANCH, this.buildNumber());
        Packets.initGeyser();
        if (Epoll.isAvailable()) {
            this.erosionUnixListener = new UnixSocketClientListener();
        } else {
            logger.debug("Epoll is not available; Erosion's Unix socket handling will not work.");
        }
        CooldownUtils.setDefaultShowCooldown(config.getShowCooldown());
        BedrockDimension.changeBedrockNetherId(config.isAboveBedrockNetherBuilding());
        Integer bedrockThreadCount = Integer.getInteger("Geyser.BedrockNetworkThreads");
        if (bedrockThreadCount == null) {
            bedrockThreadCount = Math.max(1, SystemPropertyUtil.getInt((String)"io.netty.eventLoopThreads", (int)(NettyRuntime.availableProcessors() * 2)));
        }
        this.geyserServer = new GeyserServer(this, bedrockThreadCount);
        ((CompletableFuture)this.geyserServer.bind(new InetSocketAddress(config.getBedrock().address(), config.getBedrock().port())).whenComplete((avoid, throwable) -> {
            String address = config.getBedrock().address();
            String port = String.valueOf(config.getBedrock().port());
            if (throwable == null) {
                if ("0.0.0.0".equals(address)) {
                    logger.info(GeyserLocale.getLocaleStringLog("geyser.core.start.ip_suppressed", port));
                } else {
                    logger.info(GeyserLocale.getLocaleStringLog("geyser.core.start", address, port));
                }
            } else {
                logger.severe(GeyserLocale.getLocaleStringLog("geyser.core.fail", address, port));
                if (!"0.0.0.0".equals(address)) {
                    logger.info(Component.text("Suggestion: try setting `address` under `bedrock` in the Geyser config back to 0.0.0.0", (TextColor)NamedTextColor.GREEN));
                    logger.info(Component.text("Then, restart this server.", (TextColor)NamedTextColor.GREEN));
                }
            }
        })).join();
        if (config.getRemote().authType() == AuthType.FLOODGATE) {
            try {
                Key key = new AesKeyProducer().produceFrom(config.getFloodgateKeyPath());
                this.cipher = new AesCipher(new Base64Topping());
                this.cipher.init(key);
                logger.debug("Loaded Floodgate key!");
                this.skinUploader = new FloodgateSkinUploader(this).start();
            }
            catch (Exception exception) {
                logger.severe(GeyserLocale.getLocaleStringLog("geyser.auth.floodgate.bad_key"), exception);
            }
        }
        if (config.getMetrics().isEnabled()) {
            this.metrics = new Metrics(this, "GeyserMC", config.getMetrics().getUniqueId(), false, Logger.getLogger(""));
            this.metrics.addCustomChart(new Metrics.SingleLineChart("players", this.sessionManager::size));
            this.metrics.addCustomChart(new Metrics.SimplePie("authMode", () -> config.getRemote().authType().toString().toLowerCase(Locale.ROOT)));
            HashMap platformTypeMap = new HashMap();
            HashMap<String, Integer> serverPlatform = new HashMap<String, Integer>();
            serverPlatform.put(this.bootstrap.getServerPlatform(), 1);
            platformTypeMap.put(this.platformType().platformName(), serverPlatform);
            this.metrics.addCustomChart(new Metrics.DrilldownPie("platform", () -> platformTypeMap));
            this.metrics.addCustomChart(new Metrics.SimplePie("defaultLocale", GeyserLocale::getDefaultLocale));
            this.metrics.addCustomChart(new Metrics.SimplePie("version", () -> VERSION));
            this.metrics.addCustomChart(new Metrics.SimplePie("javaHaProxyProtocol", () -> String.valueOf(config.getRemote().isUseProxyProtocol())));
            this.metrics.addCustomChart(new Metrics.SimplePie("bedrockHaProxyProtocol", () -> String.valueOf(config.getBedrock().isEnableProxyProtocol())));
            this.metrics.addCustomChart(new Metrics.AdvancedPie("playerPlatform", () -> {
                HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
                for (GeyserSession session : this.sessionManager.getAllSessions()) {
                    if (session == null || session.getClientData() == null) continue;
                    String os = session.getClientData().getDeviceOs().toString();
                    if (!valueMap.containsKey(os)) {
                        valueMap.put(os, 1);
                        continue;
                    }
                    valueMap.put(os, (Integer)valueMap.get(os) + 1);
                }
                return valueMap;
            }));
            this.metrics.addCustomChart(new Metrics.AdvancedPie("playerVersion", () -> {
                HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
                for (GeyserSession session : this.sessionManager.getAllSessions()) {
                    if (session == null || session.getClientData() == null) continue;
                    String version = session.getClientData().getGameVersion();
                    if (!valueMap.containsKey(version)) {
                        valueMap.put(version, 1);
                        continue;
                    }
                    valueMap.put(version, (Integer)valueMap.get(version) + 1);
                }
                return valueMap;
            }));
            String minecraftVersion = this.bootstrap.getMinecraftServerVersion();
            if (minecraftVersion != null) {
                HashMap versionMap = new HashMap();
                HashMap<String, Integer> platformMap = new HashMap<String, Integer>();
                platformMap.put(this.bootstrap.getServerPlatform(), 1);
                versionMap.put(minecraftVersion, platformMap);
                this.metrics.addCustomChart(new Metrics.DrilldownPie("minecraftServerVersion", () -> versionMap));
            }
            this.metrics.addCustomChart(new Metrics.DrilldownPie("javaVersion", () -> {
                String release;
                HashMap map = new HashMap();
                String javaVersion = System.getProperty("java.version");
                HashMap<String, Integer> entry = new HashMap<String, Integer>();
                entry.put(javaVersion, 1);
                String majorVersion = javaVersion.split("\\.")[0];
                int indexOf = javaVersion.lastIndexOf(46);
                if (majorVersion.equals("1")) {
                    release = "Java " + javaVersion.substring(0, indexOf);
                } else {
                    Matcher versionMatcher = Pattern.compile("\\d+").matcher(majorVersion);
                    if (versionMatcher.find()) {
                        majorVersion = versionMatcher.group(0);
                    }
                    release = "Java " + majorVersion;
                }
                map.put((CallSite)((Object)release), entry);
                return map;
            }));
        } else {
            this.metrics = null;
        }
        if (config.getRemote().authType() == AuthType.ONLINE) {
            this.savedAuthChains = new ConcurrentHashMap<String, String>();
            File authChainsFile = this.bootstrap.getSavedUserLoginsFolder().resolve("saved-auth-chains.json").toFile();
            if (authChainsFile.exists()) {
                TypeReference<Map<String, String>> type = new TypeReference<Map<String, String>>(){};
                Map<String, String> authChainFile = null;
                try {
                    authChainFile = JSON_MAPPER.readValue(authChainsFile, type);
                }
                catch (IOException e) {
                    logger.error("Cannot load saved user tokens!", e);
                }
                if (authChainFile != null) {
                    List<String> validUsers = config.getSavedUserLogins();
                    boolean doWrite = false;
                    for (Map.Entry<String, String> entry : authChainFile.entrySet()) {
                        String user = entry.getKey();
                        if (!validUsers.contains(user)) {
                            doWrite = true;
                            continue;
                        }
                        this.savedAuthChains.put(user, entry.getValue());
                    }
                    if (doWrite) {
                        this.scheduleAuthChainsWrite();
                    }
                }
            }
        } else {
            this.savedAuthChains = null;
        }
        this.newsHandler.handleNews(null, NewsItemAction.ON_SERVER_STARTED);
        if (this.isReloading) {
            this.eventBus.fire(new GeyserPostReloadEvent(this.extensionManager, this.eventBus));
        } else {
            this.eventBus.fire(new GeyserPostInitializeEvent(this.extensionManager, this.eventBus));
        }
        if (config.isNotifyOnNewBedrockUpdate()) {
            VersionCheckUtils.checkForGeyserUpdate(this::getLogger);
        }
    }

    public @NonNull List<GeyserSession> onlineConnections() {
        return this.sessionManager.getAllSessions();
    }

    @Override
    public int onlineConnectionsCount() {
        return this.sessionManager.size();
    }

    @Override
    public @MonotonicNonNull String usernamePrefix() {
        return null;
    }

    @Override
    public @Nullable GeyserSession connectionByUuid(@NonNull UUID uuid) {
        return this.sessionManager.getSessions().get(uuid);
    }

    @Override
    public @Nullable GeyserSession connectionByXuid(@NonNull String xuid) {
        return this.sessionManager.sessionByXuid(xuid);
    }

    @Override
    public boolean isBedrockPlayer(@NonNull UUID uuid) {
        return this.connectionByUuid(uuid) != null;
    }

    @Override
    public boolean sendForm(@NonNull UUID uuid, @NonNull Form form) {
        Objects.requireNonNull(uuid);
        Objects.requireNonNull(form);
        GeyserSession session = this.connectionByUuid(uuid);
        if (session == null) {
            return false;
        }
        return session.sendForm(form);
    }

    @Override
    public boolean sendForm(@NonNull UUID uuid, @NonNull FormBuilder<?, ?, ?> formBuilder) {
        return this.sendForm(uuid, (Form)formBuilder.build());
    }

    @Override
    public boolean transfer(@NonNull UUID uuid, @NonNull String address, int port) {
        Objects.requireNonNull(uuid);
        GeyserSession session = this.connectionByUuid(uuid);
        if (session == null) {
            return false;
        }
        return session.transfer(address, port);
    }

    public void disable() {
        this.bootstrap.getGeyserLogger().info(GeyserLocale.getLocaleStringLog("geyser.core.shutdown"));
        if (this.sessionManager.size() >= 1) {
            this.bootstrap.getGeyserLogger().info(GeyserLocale.getLocaleStringLog("geyser.core.shutdown.kick.log", this.sessionManager.size()));
            this.sessionManager.disconnectAll("geyser.core.shutdown.kick.message");
            this.bootstrap.getGeyserLogger().info(GeyserLocale.getLocaleStringLog("geyser.core.shutdown.kick.done"));
        }
        this.runIfNonNull(this.scheduledThread, ExecutorService::shutdown);
        this.runIfNonNull(this.geyserServer, GeyserServer::shutdown);
        this.runIfNonNull(this.skinUploader, FloodgateSkinUploader::close);
        this.runIfNonNull(this.newsHandler, NewsHandler::shutdown);
        this.runIfNonNull(this.erosionUnixListener, UnixSocketClientListener::close);
        ResourcePackLoader.clear();
        CodeOfConductManager.getInstance().save();
        this.setEnabled(false);
    }

    public void shutdown() {
        this.shuttingDown = true;
        if (this.isEnabled) {
            this.disable();
        }
        this.eventBus.fire(new GeyserShutdownEvent(this.extensionManager, this.eventBus));
        this.extensionManager.disableExtensions();
        this.bootstrap.getGeyserLogger().info(GeyserLocale.getLocaleStringLog("geyser.core.shutdown.done"));
    }

    public void reloadGeyser() {
        this.isReloading = true;
        this.eventBus.fire(new GeyserPreReloadEvent(this.extensionManager, this.eventBus));
        this.bootstrap.onGeyserDisable();
        this.bootstrap.onGeyserEnable();
        this.isReloading = false;
    }

    public boolean isProductionEnvironment() {
        return !"git-local/dev-0000000".equals(GIT_VERSION) && !"${gitVersion}".equals(GIT_VERSION);
    }

    @Override
    public @NonNull GeyserExtensionManager extensionManager() {
        return this.extensionManager;
    }

    public @NonNull CommandRegistry commandRegistry() {
        return this.bootstrap.getCommandRegistry();
    }

    @Override
    public <R extends T, T> @NonNull R provider(@NonNull Class<T> apiClass, Object ... args) {
        ProviderSupplier provider = (ProviderSupplier)Registries.PROVIDERS.get(apiClass);
        if (provider == null) {
            throw new IllegalArgumentException("No provider found for " + String.valueOf(apiClass));
        }
        return (R)provider.create(args);
    }

    public @NonNull GeyserEventBus eventBus() {
        return this.eventBus;
    }

    @Override
    public @NonNull RemoteServer defaultRemoteServer() {
        return this.getConfig().getRemote();
    }

    @Override
    public @NonNull BedrockListener bedrockListener() {
        return this.getConfig().getBedrock();
    }

    @Override
    public @NonNull Path configDirectory() {
        return this.bootstrap.getConfigFolder();
    }

    @Override
    public @NonNull Path packDirectory() {
        return this.bootstrap.getConfigFolder().resolve("packs");
    }

    @Override
    public @NonNull PlatformType platformType() {
        return this.platformType;
    }

    @Override
    public @NonNull MinecraftVersion supportedJavaVersion() {
        return new MinecraftVersionImpl(GameProtocol.getJavaMinecraftVersion(), GameProtocol.getJavaProtocolVersion());
    }

    @Override
    public @NonNull List<MinecraftVersion> supportedBedrockVersions() {
        return Collections.unmodifiableList(GameProtocol.SUPPORTED_BEDROCK_VERSIONS);
    }

    @Override
    public @NonNull CommandSource consoleCommandSource() {
        return this.getLogger();
    }

    public int buildNumber() {
        if (!this.isProductionEnvironment()) {
            return 0;
        }
        return Integer.parseInt(BUILD_NUMBER);
    }

    public static GeyserImpl load(PlatformType platformType, GeyserBootstrap bootstrap) {
        if (instance == null) {
            return new GeyserImpl(platformType, bootstrap);
        }
        return instance;
    }

    public static void start() {
        if (instance == null) {
            throw new RuntimeException("Geyser has not been loaded yet!");
        }
        if (GeyserImpl.getInstance().isReloading()) {
            instance.startInstance();
        } else {
            instance.initialize();
        }
        instance.setEnabled(true);
    }

    public GeyserLogger getLogger() {
        return this.bootstrap.getGeyserLogger();
    }

    public GeyserConfiguration getConfig() {
        return this.bootstrap.getGeyserConfig();
    }

    public WorldManager getWorldManager() {
        return this.bootstrap.getWorldManager();
    }

    public @Nullable String authChainFor(@NonNull String bedrockName) {
        return this.savedAuthChains.get(bedrockName);
    }

    public void saveAuthChain(@NonNull String bedrockName, @NonNull String authChain) {
        if (!this.getConfig().getSavedUserLogins().contains(bedrockName)) {
            return;
        }
        if (!Objects.equals(authChain, this.savedAuthChains.put(bedrockName, authChain))) {
            this.scheduleAuthChainsWrite();
        }
    }

    private <T> void runIfNonNull(T nullable, Consumer<T> consumer) {
        if (nullable != null) {
            consumer.accept(nullable);
        }
    }

    private void scheduleAuthChainsWrite() {
        this.scheduledThread.execute(() -> {
            File savedAuthChains = this.getBootstrap().getSavedUserLoginsFolder().resolve("saved-auth-chains.json").toFile();
            TypeReference<Map<String, String>> type = new TypeReference<Map<String, String>>(){};
            try (FileWriter writer = new FileWriter(savedAuthChains);){
                JSON_MAPPER.writerFor(type).withDefaultPrettyPrinter().writeValue(writer, this.savedAuthChains);
            }
            catch (IOException e) {
                this.getLogger().error("Unable to write saved refresh tokens!", e);
            }
        });
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public FloodgateCipher getCipher() {
        return this.cipher;
    }

    public FloodgateSkinUploader getSkinUploader() {
        return this.skinUploader;
    }

    public NewsHandler getNewsHandler() {
        return this.newsHandler;
    }

    public UnixSocketClientListener getErosionUnixListener() {
        return this.erosionUnixListener;
    }

    public boolean isShuttingDown() {
        return this.shuttingDown;
    }

    public ScheduledExecutorService getScheduledThread() {
        return this.scheduledThread;
    }

    public GeyserServer getGeyserServer() {
        return this.geyserServer;
    }

    public PlatformType getPlatformType() {
        return this.platformType;
    }

    public GeyserBootstrap getBootstrap() {
        return this.bootstrap;
    }

    public GeyserEventBus getEventBus() {
        return this.eventBus;
    }

    public GeyserExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public PendingMicrosoftAuthentication getPendingMicrosoftAuthentication() {
        return this.pendingMicrosoftAuthentication;
    }

    public boolean isReloading() {
        return this.isReloading;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setShuttingDown(boolean shuttingDown) {
        this.shuttingDown = shuttingDown;
    }

    public static GeyserImpl getInstance() {
        return instance;
    }

    public void setReloading(boolean isReloading) {
        this.isReloading = isReloading;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }
}

