/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.event.type;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.api.event.bedrock.SessionLoadResourcePacksEvent;
import org.geysermc.geyser.api.pack.ResourcePack;
import org.geysermc.geyser.session.GeyserSession;

public class SessionLoadResourcePacksEventImpl
extends SessionLoadResourcePacksEvent {
    private final Map<UUID, ResourcePack> packs;

    public SessionLoadResourcePacksEventImpl(GeyserSession session, Map<UUID, ResourcePack> packMap) {
        super(session);
        this.packs = packMap;
    }

    public @NonNull Map<UUID, ResourcePack> getPacks() {
        return this.packs;
    }

    @Override
    public @NonNull List<ResourcePack> resourcePacks() {
        return List.copyOf(this.packs.values());
    }

    @Override
    public boolean register(@NonNull ResourcePack resourcePack) {
        UUID packID = resourcePack.manifest().header().uuid();
        if (this.packs.containsValue(resourcePack) || this.packs.containsKey(packID)) {
            return false;
        }
        this.packs.put(resourcePack.manifest().header().uuid(), resourcePack);
        return true;
    }

    @Override
    public boolean unregister(@NonNull UUID uuid) {
        return this.packs.remove(uuid) != null;
    }
}

