/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock.entity.player.input;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cloudburstmc.math.GenericMath;
import org.cloudburstmc.math.vector.Vector2f;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.InputMode;
import org.cloudburstmc.protocol.bedrock.data.PlayerAuthInputData;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.data.inventory.transaction.ItemUseTransaction;
import org.cloudburstmc.protocol.bedrock.packet.AnimatePacket;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.PlayerAuthInputPacket;
import org.geysermc.geyser.entity.type.BoatEntity;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.living.animal.horse.AbstractHorseEntity;
import org.geysermc.geyser.entity.type.living.animal.horse.LlamaEntity;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.entity.vehicle.ClientVehicle;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.translator.protocol.bedrock.entity.player.input.BedrockMovePlayer;
import org.geysermc.geyser.util.CooldownUtils;
import org.geysermc.mcprotocollib.network.packet.Packet;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.GameMode;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.PlayerState;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.ServerboundClientTickEndPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.level.ServerboundMoveVehiclePacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundPlayerAbilitiesPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundPlayerCommandPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundSwingPacket;

@Translator(packet=PlayerAuthInputPacket.class)
public final class BedrockPlayerAuthInputTranslator
extends PacketTranslator<PlayerAuthInputPacket> {
    @Override
    public void translate(GeyserSession session, PlayerAuthInputPacket packet) {
        SessionPlayerEntity entity = session.getPlayerEntity();
        session.setClientTicks(packet.getTick());
        boolean wasJumping = session.getInputCache().wasJumping();
        session.getInputCache().processInputs(entity, packet);
        session.getBlockBreakHandler().handlePlayerAuthInputPacket(packet);
        ServerboundPlayerCommandPacket sprintPacket = null;
        Set inputData = packet.getInputData();
        HashSet leftOverInputData = new HashSet(packet.getInputData());
        for (PlayerAuthInputData input : inputData) {
            leftOverInputData.remove(input);
            switch (input) {
                case PERFORM_ITEM_INTERACTION: {
                    BedrockPlayerAuthInputTranslator.processItemUseTransaction(session, packet.getItemUseTransaction());
                    break;
                }
                case PERFORM_ITEM_STACK_REQUEST: {
                    session.getPlayerInventoryHolder().translateRequests(List.of(packet.getItemStackRequest()));
                    break;
                }
                case START_SWIMMING: {
                    session.setSwimming(true);
                    break;
                }
                case STOP_SWIMMING: {
                    session.setSwimming(false);
                    break;
                }
                case START_CRAWLING: {
                    session.setCrawling(true);
                    break;
                }
                case STOP_CRAWLING: {
                    session.setCrawling(false);
                    break;
                }
                case START_SPRINTING: {
                    if (leftOverInputData.contains(PlayerAuthInputData.STOP_SPRINTING) || session.isSprinting()) break;
                    sprintPacket = new ServerboundPlayerCommandPacket(entity.javaId(), PlayerState.START_SPRINTING);
                    session.setSprinting(true);
                    break;
                }
                case STOP_SPRINTING: {
                    if (leftOverInputData.contains(PlayerAuthInputData.START_SPRINTING) || !session.isSprinting()) break;
                    sprintPacket = new ServerboundPlayerCommandPacket(entity.javaId(), PlayerState.STOP_SPRINTING);
                    session.setSprinting(false);
                    break;
                }
                case START_FLYING: {
                    if (session.isCanFly()) {
                        if (session.getGameMode() == GameMode.SPECTATOR) {
                            session.sendAdventureSettings();
                            break;
                        }
                        if (session.getPlayerEntity().getFlag(EntityFlag.SWIMMING) && session.getCollisionManager().isPlayerInWater()) {
                            session.sendAdventureSettings();
                            break;
                        }
                        session.setFlying(true);
                        session.sendDownstreamGamePacket((Packet)new ServerboundPlayerAbilitiesPacket(true));
                        break;
                    }
                    session.setFlying(false);
                    session.sendAdventureSettings();
                    break;
                }
                case STOP_FLYING: {
                    session.setFlying(false);
                    session.sendDownstreamGamePacket((Packet)new ServerboundPlayerAbilitiesPacket(false));
                    break;
                }
                case START_GLIDING: {
                    if (leftOverInputData.contains(PlayerAuthInputData.STOP_GLIDING)) break;
                    if (entity.canStartGliding()) {
                        if (session.isFlying()) {
                            session.setFlying(false);
                            session.sendDownstreamGamePacket((Packet)new ServerboundPlayerAbilitiesPacket(false));
                        }
                        session.setGliding(true);
                        session.sendDownstreamGamePacket((Packet)new ServerboundPlayerCommandPacket(entity.getEntityId(), PlayerState.START_ELYTRA_FLYING));
                        break;
                    }
                    entity.forceFlagUpdate();
                    session.setGliding(false);
                    if (!session.isFlying()) break;
                    session.sendAdventureSettings();
                    break;
                }
                case START_SPIN_ATTACK: {
                    session.setSpinAttack(true);
                    break;
                }
                case STOP_SPIN_ATTACK: {
                    session.setSpinAttack(false);
                    break;
                }
                case STOP_GLIDING: {
                    boolean shouldBeGliding = entity.isGliding() && entity.canStartGliding();
                    entity.forceFlagUpdate();
                    session.setGliding(shouldBeGliding);
                    break;
                }
                case MISSED_SWING: {
                    session.setLastAirHitTick(session.getTicks());
                    if (session.getArmAnimationTicks() != 0 && session.getArmAnimationTicks() != 1) {
                        session.sendDownstreamGamePacket((Packet)new ServerboundSwingPacket(Hand.MAIN_HAND));
                        session.activateArmAnimationTicking();
                    }
                    if (packet.getInputMode().equals((Object)InputMode.TOUCH)) {
                        AnimatePacket animatePacket = new AnimatePacket();
                        animatePacket.setAction(AnimatePacket.Action.SWING_ARM);
                        animatePacket.setRuntimeEntityId(session.getPlayerEntity().getGeyserId());
                        session.sendUpstreamPacket((BedrockPacket)animatePacket);
                    }
                    CooldownUtils.sendCooldown(session);
                }
            }
        }
        BedrockPlayerAuthInputTranslator.processVehicleInput(session, packet, wasJumping);
        if (sprintPacket != null) {
            session.sendDownstreamGamePacket((Packet)sprintPacket);
        }
        BedrockMovePlayer.translate(session, packet);
        if (session.isSpawned()) {
            session.sendDownstreamGamePacket((Packet)ServerboundClientTickEndPacket.INSTANCE);
        }
        if (entity.getVehicle() instanceof BoatEntity && inputData.contains(PlayerAuthInputData.IN_CLIENT_PREDICTED_IN_VEHICLE)) {
            boolean up = inputData.contains(PlayerAuthInputData.UP);
            session.setSteeringLeft(up || inputData.contains(PlayerAuthInputData.PADDLE_RIGHT));
            session.setSteeringRight(up || inputData.contains(PlayerAuthInputData.PADDLE_LEFT));
        }
    }

    private static void processItemUseTransaction(GeyserSession session, ItemUseTransaction transaction) {
        if (transaction.getActionType() == 2) {
            session.setLastBlockPlaced(null);
            session.setLastBlockPlacePosition(null);
        } else {
            session.getGeyser().getLogger().error("Unhandled item use transaction type!");
            if (session.getGeyser().getLogger().isDebug()) {
                session.getGeyser().getLogger().debug(transaction);
            }
        }
    }

    private static void processVehicleInput(GeyserSession session, PlayerAuthInputPacket packet, boolean wasJumping) {
        Entity vehicle = session.getPlayerEntity().getVehicle();
        if (vehicle == null) {
            return;
        }
        if (vehicle instanceof ClientVehicle) {
            session.getPlayerEntity().setVehicleInput(packet.getMotion());
        }
        boolean sendMovement = false;
        if (vehicle instanceof AbstractHorseEntity && !(vehicle instanceof LlamaEntity)) {
            sendMovement = !(vehicle instanceof ClientVehicle);
        } else if (vehicle instanceof BoatEntity) {
            boolean bl = sendMovement = vehicle.getPassengers().size() == 1 || session.getPlayerEntity().isRidingInFront();
        }
        if (vehicle instanceof AbstractHorseEntity && !vehicle.getFlag(EntityFlag.HAS_DASH_COOLDOWN)) {
            int currentJumpingTicks = session.getInputCache().getJumpingTicks();
            if (currentJumpingTicks < 0) {
                session.getInputCache().setJumpingTicks(++currentJumpingTicks);
                if (currentJumpingTicks == 0) {
                    session.getInputCache().setJumpScale(0.0f);
                }
            }
            boolean holdingJump = packet.getInputData().contains(PlayerAuthInputData.JUMPING);
            if (wasJumping && !holdingJump) {
                int finalVehicleJumpStrength = GenericMath.floor((float)(session.getInputCache().getJumpScale() * 100.0f));
                session.sendDownstreamGamePacket((Packet)new ServerboundPlayerCommandPacket(session.getPlayerEntity().getEntityId(), PlayerState.START_HORSE_JUMP, finalVehicleJumpStrength));
                session.getInputCache().setJumpingTicks(-10);
                session.getPlayerEntity().setVehicleJumpStrength(finalVehicleJumpStrength);
            } else if (!wasJumping && holdingJump) {
                session.getInputCache().setJumpingTicks(0);
                session.getInputCache().setJumpScale(0.0f);
            } else if (holdingJump) {
                session.getInputCache().setJumpingTicks(++currentJumpingTicks);
                if (currentJumpingTicks < 10) {
                    session.getInputCache().setJumpScale((float)session.getInputCache().getJumpingTicks() * 0.1f);
                } else {
                    session.getInputCache().setJumpScale(0.8f + 2.0f / (float)(currentJumpingTicks - 9) * 0.1f);
                }
            }
        } else {
            session.getInputCache().setJumpScale(0.0f);
        }
        if (sendMovement) {
            vehicle.setOnGround(packet.getInputData().contains(PlayerAuthInputData.VERTICAL_COLLISION) && session.getPlayerEntity().getLastTickEndVelocity().getY() < 0.0f);
            Vector3f vehiclePosition = packet.getPosition();
            Vector2f vehicleRotation = packet.getVehicleRotation();
            if (vehicleRotation == null) {
                return;
            }
            if (session.getWorldBorder().isPassingIntoBorderBoundaries(vehiclePosition, false)) {
                Vector3f position = vehicle.getPosition();
                if (vehicle instanceof BoatEntity) {
                    BoatEntity boat = (BoatEntity)vehicle;
                    boat.moveAbsoluteWithoutAdjustments(position, vehicle.getYaw(), vehicle.isOnGround(), true);
                } else {
                    vehicle.moveAbsolute(position, vehicle.getYaw(), vehicle.getPitch(), vehicle.getHeadYaw(), vehicle.isOnGround(), true);
                }
                return;
            }
            if (vehicle instanceof BoatEntity) {
                vehiclePosition = vehiclePosition.down(vehicle.getDefinition().offset());
            }
            vehicle.setPosition(vehiclePosition);
            ServerboundMoveVehiclePacket moveVehiclePacket = new ServerboundMoveVehiclePacket(vehiclePosition.toDouble(), vehicleRotation.getY() - 90.0f, vehiclePosition.getX(), vehicle.isOnGround());
            session.sendDownstreamGamePacket((Packet)moveVehiclePacket);
        }
    }
}

