/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import java.util.concurrent.TimeUnit;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.SetTitlePacket;
import org.geysermc.geyser.session.GeyserSession;

public class CooldownUtils {
    private static CooldownType DEFAULT_SHOW_COOLDOWN;

    public static void setDefaultShowCooldown(String showCooldown) {
        DEFAULT_SHOW_COOLDOWN = CooldownType.getByName(showCooldown);
    }

    public static CooldownType getDefaultShowCooldown() {
        return DEFAULT_SHOW_COOLDOWN;
    }

    public static void sendCooldown(GeyserSession session) {
        if (DEFAULT_SHOW_COOLDOWN == CooldownType.DISABLED) {
            return;
        }
        CooldownType sessionPreference = session.getPreferencesCache().getCooldownPreference();
        if (sessionPreference == CooldownType.DISABLED) {
            return;
        }
        if (session.getAttackSpeed() == 0.0 || session.getAttackSpeed() > 20.0) {
            return;
        }
        SetTitlePacket titlePacket = new SetTitlePacket();
        titlePacket.setType(SetTitlePacket.Type.TIMES);
        titlePacket.setStayTime(1000);
        titlePacket.setText("");
        titlePacket.setXuid("");
        titlePacket.setPlatformOnlineId("");
        session.sendUpstreamPacket((BedrockPacket)titlePacket);
        session.getWorldCache().markTitleTimesAsIncorrect();
        titlePacket = new SetTitlePacket();
        titlePacket.setType(SetTitlePacket.Type.TITLE);
        titlePacket.setText(" ");
        titlePacket.setXuid("");
        titlePacket.setPlatformOnlineId("");
        session.sendUpstreamPacket((BedrockPacket)titlePacket);
        session.setLastHitTime(System.currentTimeMillis());
        long lastHitTime = session.getLastHitTime();
        CooldownUtils.computeCooldown(session, sessionPreference, lastHitTime);
    }

    private static void computeCooldown(GeyserSession session, CooldownType sessionPreference, long lastHitTime) {
        if (session.isClosed()) {
            return;
        }
        if (lastHitTime != session.getLastHitTime()) {
            return;
        }
        SetTitlePacket titlePacket = new SetTitlePacket();
        if (sessionPreference == CooldownType.ACTIONBAR) {
            titlePacket.setType(SetTitlePacket.Type.ACTIONBAR);
        } else {
            titlePacket.setType(SetTitlePacket.Type.SUBTITLE);
        }
        titlePacket.setText(CooldownUtils.getTitle(session));
        titlePacket.setXuid("");
        titlePacket.setPlatformOnlineId("");
        session.sendUpstreamPacket((BedrockPacket)titlePacket);
        if (CooldownUtils.hasCooldown(session)) {
            session.scheduleInEventLoop(() -> CooldownUtils.computeCooldown(session, sessionPreference, lastHitTime), (long)CooldownUtils.restrain(session.getMillisecondsPerTick(), 50.0), TimeUnit.MILLISECONDS);
        } else {
            SetTitlePacket removeTitlePacket = new SetTitlePacket();
            removeTitlePacket.setType(SetTitlePacket.Type.CLEAR);
            removeTitlePacket.setText(" ");
            removeTitlePacket.setXuid("");
            removeTitlePacket.setPlatformOnlineId("");
            session.sendUpstreamPacket((BedrockPacket)removeTitlePacket);
        }
    }

    private static boolean hasCooldown(GeyserSession session) {
        long time = System.currentTimeMillis() - session.getLastHitTime();
        double tickrateMultiplier = Math.max((double)(session.getMillisecondsPerTick() / 50.0f), 1.0);
        double cooldown = CooldownUtils.restrain((double)time * session.getAttackSpeed() / (tickrateMultiplier * 1000.0), 1.0);
        return cooldown < 1.0;
    }

    private static double restrain(double x, double max) {
        if (x < 0.0) {
            return 0.0;
        }
        return Math.min(x, max);
    }

    private static String getTitle(GeyserSession session) {
        int darkGrey;
        long time = System.currentTimeMillis() - session.getLastHitTime();
        double tickrateMultiplier = Math.max((double)(session.getMillisecondsPerTick() / 50.0f), 1.0);
        double cooldown = CooldownUtils.restrain((double)time * session.getAttackSpeed() / (tickrateMultiplier * 1000.0), 1.0);
        int grey = 10 - darkGrey;
        StringBuilder builder = new StringBuilder("\u00a78");
        for (darkGrey = (int)Math.floor(10.0 * cooldown); darkGrey > 0; --darkGrey) {
            builder.append("\u02d9");
        }
        builder.append("\u00a77");
        while (grey > 0) {
            builder.append("\u02d9");
            --grey;
        }
        return builder.toString();
    }

    public static enum CooldownType {
        TITLE,
        ACTIONBAR,
        DISABLED;

        public static final CooldownType[] VALUES;

        public static CooldownType getByName(String name) {
            if (name.equalsIgnoreCase("true")) {
                return TITLE;
            }
            for (CooldownType type : VALUES) {
                if (!type.name().equalsIgnoreCase(name)) continue;
                return type;
            }
            return DISABLED;
        }

        static {
            VALUES = CooldownType.values();
        }
    }
}

