/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.fabric;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.Person;
import net.minecraft.server.MinecraftServer;
import org.geysermc.geyser.dump.BootstrapDumpInfo;
import org.geysermc.geyser.text.AsteriskSerializer;

public class GeyserFabricDumpInfo
extends BootstrapDumpInfo {
    private final String platformName;
    private String platformVersion;
    private final String minecraftVersion;
    private final EnvType environmentType;
    @AsteriskSerializer.Asterisk(isIp=true)
    private final String serverIP;
    private final int serverPort;
    private final boolean onlineMode;
    private final List<ModInfo> mods;

    public GeyserFabricDumpInfo(MinecraftServer server) {
        this.platformName = server.getServerModName();
        FabricLoader.getInstance().getModContainer("fabricloader").ifPresent(mod -> {
            this.platformVersion = mod.getMetadata().getVersion().getFriendlyString();
        });
        this.minecraftVersion = server.method_3827();
        this.environmentType = FabricLoader.getInstance().getEnvironmentType();
        this.serverIP = server.method_3819() == null ? "unknown" : server.method_3819();
        this.serverPort = server.method_3756();
        this.onlineMode = server.method_3828();
        this.mods = new ArrayList<ModInfo>();
        for (ModContainer mod2 : FabricLoader.getInstance().getAllMods()) {
            ModMetadata meta = mod2.getMetadata();
            this.mods.add(new ModInfo(FabricLoader.getInstance().isModLoaded(meta.getId()), meta.getId(), meta.getVersion().getFriendlyString(), meta.getAuthors().stream().map(Person::getName).collect(Collectors.toList())));
        }
    }

    public String getPlatformName() {
        return this.platformName;
    }

    public String getPlatformVersion() {
        return this.platformVersion;
    }

    public String getMinecraftVersion() {
        return this.minecraftVersion;
    }

    public EnvType getEnvironmentType() {
        return this.environmentType;
    }

    public String getServerIP() {
        return this.serverIP;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public boolean isOnlineMode() {
        return this.onlineMode;
    }

    public List<ModInfo> getMods() {
        return this.mods;
    }

    public static class ModInfo {
        public boolean enabled;
        public String name;
        public String version;
        public List<String> authors;

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public List<String> getAuthors() {
            return this.authors;
        }

        public ModInfo(boolean enabled, String name, String version, List<String> authors) {
            this.enabled = enabled;
            this.name = name;
            this.version = version;
            this.authors = authors;
        }
    }
}

