/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.entity.metadata;

import io.netty.buffer.ByteBuf;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.EntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.MetadataType;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.FloatEntityMetadata;

public class FloatMetadataType
extends MetadataType<Float> {
    private final FloatReader primitiveReader;
    private final FloatWriter primitiveWriter;
    private final FloatEntityMetadataFactory primitiveFactory;

    protected FloatMetadataType(int id, FloatReader reader, FloatWriter writer, FloatEntityMetadataFactory metadataFactory) {
        super(id, reader, writer, metadataFactory);
        this.primitiveReader = reader;
        this.primitiveWriter = writer;
        this.primitiveFactory = metadataFactory;
    }

    @Override
    public EntityMetadata<Float, FloatMetadataType> readMetadata(ByteBuf input, int id) {
        return this.primitiveFactory.createPrimitive(id, this, this.primitiveReader.readPrimitive(input));
    }

    public void writeMetadataPrimitive(ByteBuf output, float value) {
        this.primitiveWriter.writePrimitive(output, value);
    }

    @FunctionalInterface
    public static interface FloatReader
    extends MetadataType.BasicReader<Float> {
        public float readPrimitive(ByteBuf var1);

        @Override
        @Deprecated
        default public Float read(ByteBuf input) {
            return Float.valueOf(this.readPrimitive(input));
        }
    }

    @FunctionalInterface
    public static interface FloatWriter
    extends MetadataType.BasicWriter<Float> {
        public void writePrimitive(ByteBuf var1, float var2);

        @Override
        @Deprecated
        default public void write(ByteBuf output, Float value) {
            this.writePrimitive(output, value.floatValue());
        }
    }

    @FunctionalInterface
    public static interface FloatEntityMetadataFactory
    extends MetadataType.EntityMetadataFactory<Float> {
        public FloatEntityMetadata createPrimitive(int var1, FloatMetadataType var2, float var3);

        @Override
        @Deprecated
        default public EntityMetadata<Float, FloatMetadataType> create(int id, MetadataType<Float> type, Float value) {
            throw new UnsupportedOperationException("Unsupported read method! Use primitive createPrimitive!");
        }
    }
}

