/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.level.block.entity;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.structure.StructureMirror;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.structure.StructureRotation;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.UpdateBlockPacket;
import org.geysermc.geyser.translator.level.block.entity.BlockEntity;
import org.geysermc.geyser.translator.level.block.entity.BlockEntityTranslator;
import org.geysermc.geyser.util.StructureBlockUtils;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.BlockEntityType;

@BlockEntity(type={BlockEntityType.STRUCTURE_BLOCK})
public class StructureBlockBlockEntityTranslator
extends BlockEntityTranslator {
    @Override
    public NbtMap getBlockEntityTag(GeyserSession session, BlockEntityType type, int x, int y, int z, @Nullable NbtMap javaNbt, BlockState blockState) {
        int zStructureSize;
        int yStructureSize;
        if (javaNbt == null) {
            return super.getBlockEntityTag(session, type, x, y, z, javaNbt, blockState);
        }
        int xStructureSize = javaNbt.getInt("sizeX");
        Vector3i size = Vector3i.from((int)xStructureSize, (int)(yStructureSize = javaNbt.getInt("sizeY")), (int)(zStructureSize = javaNbt.getInt("sizeZ")));
        if (size.equals(Vector3i.ZERO)) {
            Vector3i position = Vector3i.from((int)x, (int)y, (int)z);
            String mode = javaNbt.getString("mode");
            UpdateBlockPacket emptyBlockPacket = new UpdateBlockPacket();
            emptyBlockPacket.setDataLayer(0);
            emptyBlockPacket.setBlockPosition(position);
            emptyBlockPacket.setDefinition(session.getBlockMappings().getBedrockAir());
            session.sendUpstreamPacket(emptyBlockPacket);
            UpdateBlockPacket spawnerBlockPacket = new UpdateBlockPacket();
            spawnerBlockPacket.setDataLayer(0);
            spawnerBlockPacket.setBlockPosition(position);
            spawnerBlockPacket.setDefinition(session.getBlockMappings().getStructureBlockFromMode(mode));
            session.sendUpstreamPacket(spawnerBlockPacket);
        }
        return super.getBlockEntityTag(session, type, x, y, z, javaNbt, blockState);
    }

    @Override
    public void translateTag(GeyserSession session, NbtMapBuilder bedrockNbt, NbtMap javaNbt, BlockState blockState) {
        String rotation;
        String mirror;
        String mode;
        if (javaNbt.size() < 5) {
            return;
        }
        bedrockNbt.putString("structureName", javaNbt.getString("name"));
        int bedrockData = switch (mode = javaNbt.getString("mode")) {
            case "LOAD" -> 2;
            case "CORNER" -> 3;
            case "DATA" -> 4;
            default -> 1;
        };
        bedrockNbt.putInt("data", bedrockData);
        bedrockNbt.putString("dataField", "");
        StructureMirror bedrockMirror = switch (mirror = javaNbt.getString("mirror")) {
            case "FRONT_BACK" -> StructureMirror.X;
            case "LEFT_RIGHT" -> StructureMirror.Z;
            default -> StructureMirror.NONE;
        };
        bedrockNbt.putByte("mirror", (byte)bedrockMirror.ordinal());
        bedrockNbt.putByte("ignoreEntities", javaNbt.getByte("ignoreEntities"));
        bedrockNbt.putByte("isPowered", javaNbt.getByte("powered"));
        bedrockNbt.putLong("seed", javaNbt.getLong("seed"));
        bedrockNbt.putByte("showBoundingBox", javaNbt.getByte("showboundingbox"));
        StructureRotation bedrockRotation = switch (rotation = javaNbt.getString("rotation")) {
            case "CLOCKWISE_90" -> StructureRotation.ROTATE_90;
            case "CLOCKWISE_180" -> StructureRotation.ROTATE_180;
            case "COUNTERCLOCKWISE_90" -> StructureRotation.ROTATE_270;
            default -> StructureRotation.NONE;
        };
        bedrockNbt.putByte("rotation", (byte)bedrockRotation.ordinal());
        int xStructureSize = javaNbt.getInt("sizeX");
        int yStructureSize = javaNbt.getInt("sizeY");
        int zStructureSize = javaNbt.getInt("sizeZ");
        int posX = javaNbt.getInt("posX");
        int posY = javaNbt.getInt("posY");
        int posZ = javaNbt.getInt("posZ");
        Vector3i offset = StructureBlockUtils.calculateOffset(bedrockRotation, bedrockMirror, xStructureSize, zStructureSize);
        bedrockNbt.putInt("xStructureOffset", posX + offset.getX());
        bedrockNbt.putInt("yStructureOffset", posY);
        bedrockNbt.putInt("zStructureOffset", posZ + offset.getZ());
        bedrockNbt.putInt("xStructureSize", xStructureSize);
        bedrockNbt.putInt("yStructureSize", yStructureSize);
        bedrockNbt.putInt("zStructureSize", zStructureSize);
        bedrockNbt.putFloat("integrity", javaNbt.getFloat("integrity"));
    }
}

