/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.configuration;

import java.nio.file.Path;
import java.util.List;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.api.network.AuthType;
import org.geysermc.geyser.api.network.BedrockListener;
import org.geysermc.geyser.api.network.RemoteServer;
import org.geysermc.geyser.configuration.EmoteOffhandWorkaroundOption;
import org.geysermc.geyser.network.CIDRMatcher;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.platform.velocity.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.geysermc.geyser.text.GeyserLocale;

public interface GeyserConfiguration {
    public static final int CURRENT_CONFIG_VERSION = 4;

    public void setAutoconfiguredRemote(boolean var1);

    public IBedrockConfiguration getBedrock();

    public IRemoteConfiguration getRemote();

    public List<String> getSavedUserLogins();

    public boolean isCommandSuggestions();

    @JsonIgnore
    public boolean isPassthroughMotd();

    @JsonIgnore
    public boolean isPassthroughPlayerCounts();

    @JsonIgnore
    public boolean isLegacyPingPassthrough();

    public int getPingPassthroughInterval();

    public boolean isForwardPlayerPing();

    public int getMaxPlayers();

    public boolean isDebugMode();

    @Deprecated
    public boolean isAllowThirdPartyCapes();

    @Deprecated
    public boolean isAllowThirdPartyEars();

    public String getShowCooldown();

    public boolean isShowCoordinates();

    public boolean isDisableBedrockScaffolding();

    public EmoteOffhandWorkaroundOption getEmoteOffhandWorkaround();

    public String getDefaultLocale();

    public Path getFloodgateKeyPath();

    public boolean isAddNonBedrockItems();

    public boolean isAboveBedrockNetherBuilding();

    public boolean isForceResourcePacks();

    public boolean isXboxAchievementsEnabled();

    public int getCacheImages();

    public boolean isAllowCustomSkulls();

    public int getMaxVisibleCustomSkulls();

    public int getCustomSkullRenderDistance();

    public boolean isLogPlayerIpAddresses();

    public boolean isNotifyOnNewBedrockUpdate();

    public String getUnusableSpaceBlock();

    public IMetricsInfo getMetrics();

    public int getPendingAuthenticationTimeout();

    public boolean isAutoconfiguredRemote();

    public int getScoreboardPacketThreshold();

    public boolean isEnableProxyConnections();

    public int getMtu();

    public boolean isUseDirectConnection();

    public boolean isDisableCompression();

    public int getConfigVersion();

    public static void checkGeyserConfiguration(GeyserConfiguration geyserConfig, GeyserLogger geyserLogger) {
        if (geyserConfig.getConfigVersion() < 4) {
            geyserLogger.warning(GeyserLocale.getLocaleStringLog("geyser.bootstrap.config.outdated"));
        } else if (geyserConfig.getConfigVersion() > 4) {
            geyserLogger.warning(GeyserLocale.getLocaleStringLog("geyser.bootstrap.config.too_new"));
        }
    }

    public static interface IMetricsInfo {
        public boolean isEnabled();

        public String getUniqueId();
    }

    public static interface IRemoteConfiguration
    extends RemoteServer {
        public void setAddress(String var1);

        public void setPort(int var1);

        public boolean isUseProxyProtocol();

        public boolean isForwardHost();

        @Override
        default public String minecraftVersion() {
            return GameProtocol.getJavaMinecraftVersion();
        }

        @Override
        default public int protocolVersion() {
            return GameProtocol.getJavaProtocolVersion();
        }

        public void setAuthType(AuthType var1);
    }

    public static interface IBedrockConfiguration
    extends BedrockListener {
        public void setAddress(String var1);

        public void setPort(int var1);

        public void setBroadcastPort(int var1);

        public boolean isCloneRemotePort();

        public int getCompressionLevel();

        public boolean isEnableProxyProtocol();

        public List<String> getProxyProtocolWhitelistedIPs();

        public List<CIDRMatcher> getWhitelistedIPsMatchers();
    }
}

