/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.pack;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.api.pack.PackCodec;
import org.geysermc.geyser.api.pack.ResourcePack;
import org.geysermc.geyser.api.pack.ResourcePackManifest;

public record GeyserResourcePack(@NonNull PackCodec codec, @NonNull ResourcePackManifest manifest, @NonNull String contentKey) implements ResourcePack
{
    public static final int CHUNK_SIZE = 102400;

    public static class Builder
    implements ResourcePack.Builder {
        private final PackCodec codec;
        private final ResourcePackManifest manifest;
        private String contentKey = "";

        public Builder(PackCodec codec, ResourcePackManifest manifest) {
            this.codec = codec;
            this.manifest = manifest;
        }

        public Builder(PackCodec codec, ResourcePackManifest manifest, String contentKey) {
            this.codec = codec;
            this.manifest = manifest;
            this.contentKey = contentKey;
        }

        @Override
        public ResourcePackManifest manifest() {
            return this.manifest;
        }

        @Override
        public PackCodec codec() {
            return this.codec;
        }

        @Override
        public String contentKey() {
            return this.contentKey;
        }

        @Override
        public Builder contentKey(@NonNull String contentKey) {
            Objects.requireNonNull(contentKey);
            this.contentKey = contentKey;
            return this;
        }

        @Override
        public GeyserResourcePack build() {
            return new GeyserResourcePack(this.codec, this.manifest, this.contentKey);
        }
    }
}

