/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock.entity.player.input;

import org.cloudburstmc.math.vector.Vector3d;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.PlayerAuthInputData;
import org.cloudburstmc.protocol.bedrock.packet.PlayerAuthInputPacket;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.level.physics.CollisionResult;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundMovePlayerPosPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundMovePlayerPosRotPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundMovePlayerRotPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundMovePlayerStatusOnlyPacket;

final class BedrockMovePlayer {
    BedrockMovePlayer() {
    }

    static void translate(GeyserSession session, PlayerAuthInputPacket packet) {
        boolean rotationChanged;
        boolean actualPositionChanged;
        SessionPlayerEntity entity = session.getPlayerEntity();
        if (!session.isSpawned()) {
            return;
        }
        if (session.getUnconfirmedTeleport() != null) {
            session.confirmTeleport(packet.getPosition().toDouble().sub(0.0f, EntityDefinitions.PLAYER.offset(), 0.0f));
            return;
        }
        boolean bl = actualPositionChanged = !entity.getPosition().equals(packet.getPosition());
        if (actualPositionChanged) {
            session.getBookEditCache().checkForSend();
        }
        if (entity.getBedPosition() != null) {
            return;
        }
        float yaw = packet.getRotation().getY();
        float pitch = packet.getRotation().getX();
        float headYaw = packet.getRotation().getY();
        boolean hasVehicle = entity.getVehicle() != null;
        boolean positionChangedAndShouldUpdate = !hasVehicle && (session.getInputCache().shouldSendPositionReminder() || actualPositionChanged);
        boolean bl2 = rotationChanged = hasVehicle || entity.getYaw() != yaw || entity.getPitch() != pitch || entity.getHeadYaw() != headYaw;
        if (session.getLookBackScheduledFuture() != null) {
            rotationChanged |= !session.getLookBackScheduledFuture().isDone();
            session.getLookBackScheduledFuture().cancel(false);
            session.setLookBackScheduledFuture(null);
        }
        boolean isOnGround = hasVehicle ? (double)Math.abs(packet.getDelta().getY()) < 0.1 : packet.getInputData().contains((Object)PlayerAuthInputData.VERTICAL_COLLISION) && packet.getDelta().getY() < 0.0f;
        boolean horizontalCollision = packet.getInputData().contains((Object)PlayerAuthInputData.HORIZONTAL_COLLISION);
        if (!positionChangedAndShouldUpdate && rotationChanged) {
            ServerboundMovePlayerRotPacket playerRotationPacket = new ServerboundMovePlayerRotPacket(isOnGround, horizontalCollision, yaw, pitch);
            entity.setYaw(yaw);
            entity.setPitch(pitch);
            entity.setHeadYaw(headYaw);
            session.sendDownstreamGamePacket(playerRotationPacket);
            if (hasVehicle) {
                entity.setPositionManual(packet.getPosition());
                session.getSkullCache().updateVisibleSkulls();
            }
        } else if (positionChangedAndShouldUpdate) {
            if (BedrockMovePlayer.isValidMove(session, entity.getPosition(), packet.getPosition())) {
                CollisionResult result;
                if (!session.getWorldBorder().isPassingIntoBorderBoundaries(entity.getPosition(), true) && (result = session.getCollisionManager().adjustBedrockPosition(packet.getPosition(), isOnGround, packet.getInputData().contains((Object)PlayerAuthInputData.HANDLE_TELEPORT))) != null) {
                    MinecraftPacket movePacket;
                    int voidFloorLocation;
                    int floorY;
                    Vector3d position = result.correctedMovement();
                    boolean isBelowVoid = entity.isVoidPositionDesynched();
                    boolean teleportThroughVoidFloor = entity.getPosition().getY() >= packet.getPosition().getY() && !isBelowVoid ? (floorY = position.getFloorY()) <= (voidFloorLocation = entity.voidFloorPosition()) + 1 && floorY >= voidFloorLocation : false;
                    if (teleportThroughVoidFloor || isBelowVoid) {
                        isOnGround = false;
                    }
                    boolean mustResyncPosition = isBelowVoid ? (floorY = position.getFloorY()) < (voidFloorLocation = entity.voidFloorPosition()) && floorY >= voidFloorLocation - 1 : false;
                    double yPosition = position.getY();
                    if (entity.isVoidPositionDesynched()) {
                        yPosition += 4.0;
                    }
                    if (rotationChanged) {
                        movePacket = new ServerboundMovePlayerPosRotPacket(isOnGround, horizontalCollision, position.getX(), yPosition, position.getZ(), yaw, pitch);
                        entity.setYaw(yaw);
                        entity.setPitch(pitch);
                        entity.setHeadYaw(headYaw);
                    } else {
                        movePacket = new ServerboundMovePlayerPosPacket(isOnGround, horizontalCollision, position.getX(), yPosition, position.getZ());
                    }
                    entity.setPositionManual(packet.getPosition());
                    session.sendDownstreamGamePacket(movePacket);
                    if (teleportThroughVoidFloor) {
                        entity.teleportVoidFloorFix(false);
                    } else if (mustResyncPosition) {
                        entity.teleportVoidFloorFix(true);
                    }
                    session.getInputCache().markPositionPacketSent();
                    session.getSkullCache().updateVisibleSkulls();
                }
            } else {
                session.getGeyser().getLogger().debug("Recalculating position...");
                session.getCollisionManager().recalculatePosition();
            }
        } else if (horizontalCollision != session.getInputCache().lastHorizontalCollision() || isOnGround != entity.isOnGround()) {
            session.sendDownstreamGamePacket(new ServerboundMovePlayerStatusOnlyPacket(isOnGround, horizontalCollision));
        }
        session.getInputCache().setLastHorizontalCollision(horizontalCollision);
        entity.setOnGround(isOnGround);
        if (entity.getLeftParrot() != null) {
            entity.getLeftParrot().moveAbsolute(entity.getPosition(), entity.getYaw(), entity.getPitch(), entity.getHeadYaw(), true, false);
        }
        if (entity.getRightParrot() != null) {
            entity.getRightParrot().moveAbsolute(entity.getPosition(), entity.getYaw(), entity.getPitch(), entity.getHeadYaw(), true, false);
        }
    }

    private static boolean isInvalidNumber(float val) {
        return Float.isNaN(val) || Float.isInfinite(val);
    }

    private static boolean isValidMove(GeyserSession session, Vector3f currentPosition, Vector3f newPosition) {
        if (BedrockMovePlayer.isInvalidNumber(newPosition.getX()) || BedrockMovePlayer.isInvalidNumber(newPosition.getY()) || BedrockMovePlayer.isInvalidNumber(newPosition.getZ())) {
            return false;
        }
        if (currentPosition.distanceSquared(newPosition) > 300.0f) {
            session.getGeyser().getLogger().debug("\u00a7c" + session.bedrockUsername() + " moved too quickly. current position: " + String.valueOf(currentPosition) + ", new position: " + String.valueOf(newPosition));
            return false;
        }
        return true;
    }
}

