/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.neoforge;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import net.minecraft.server.MinecraftServer;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLPaths;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.api.util.PlatformType;
import org.geysermc.geyser.dump.BootstrapDumpInfo;
import org.geysermc.geyser.platform.mod.GeyserModBootstrap;
import org.geysermc.geyser.platform.mod.platform.GeyserModPlatform;
import org.geysermc.geyser.platform.neoforge.GeyserNeoForgeDumpInfo;

public class GeyserNeoForgePlatform
implements GeyserModPlatform {
    private final ModContainer container;

    public GeyserNeoForgePlatform(ModContainer container) {
        this.container = container;
    }

    @Override
    public @NonNull PlatformType platformType() {
        return PlatformType.NEOFORGE;
    }

    @Override
    public @NonNull String configPath() {
        return "Geyser-NeoForge";
    }

    @Override
    public @NonNull Path dataFolder(@NonNull String modId) {
        return FMLPaths.CONFIGDIR.get().resolve(modId);
    }

    @Override
    public @NonNull BootstrapDumpInfo dumpInfo(@NonNull MinecraftServer server) {
        return new GeyserNeoForgeDumpInfo(server);
    }

    @Override
    public boolean testFloodgatePluginPresent(@NonNull GeyserModBootstrap bootstrap) {
        if (ModList.get().isLoaded("floodgate")) {
            Path floodgateDataFolder = FMLPaths.CONFIGDIR.get().resolve("floodgate");
            bootstrap.getGeyserConfig().loadFloodgate(bootstrap, floodgateDataFolder);
            return true;
        }
        return false;
    }

    @Override
    public @Nullable InputStream resolveResource(@NonNull String resource) {
        try {
            return this.container.getModInfo().getOwningFile().getFile().getContents().openFile(resource);
        }
        catch (IOException e) {
            return null;
        }
    }
}

