/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.java.request;

import java.io.IOException;
import java.net.MalformedURLException;
import net.lenni0451.commons.gson.elements.GsonObject;
import net.lenni0451.commons.httpclient.HttpResponse;
import net.lenni0451.commons.httpclient.requests.impl.GetRequest;
import net.raphimc.minecraftauth.java.exception.MinecraftProfileNotFoundException;
import net.raphimc.minecraftauth.java.exception.MinecraftServicesRequestException;
import net.raphimc.minecraftauth.java.model.MinecraftProfile;
import net.raphimc.minecraftauth.java.model.MinecraftToken;
import net.raphimc.minecraftauth.java.responsehandler.MinecraftServicesResponseHandler;
import net.raphimc.minecraftauth.util.UuidUtil;

public class MinecraftProfileRequest
extends GetRequest
implements MinecraftServicesResponseHandler<MinecraftProfile> {
    public MinecraftProfileRequest(MinecraftToken token) throws MalformedURLException {
        super("https://api.minecraftservices.com/minecraft/profile");
        this.setHeader("Authorization", token.getAuthorizationHeader());
    }

    @Override
    public MinecraftProfile handle(HttpResponse response, GsonObject json) throws IOException {
        return new MinecraftProfile(UuidUtil.fromUndashedString(json.reqString("id")), json.reqString("name"));
    }

    @Override
    public void handleError(HttpResponse response, GsonObject json) throws IOException {
        try {
            MinecraftServicesResponseHandler.super.handleError(response, json);
        }
        catch (MinecraftServicesRequestException e) {
            if (e.getResponse().getStatusCode() == 404) {
                throw new MinecraftProfileNotFoundException(e);
            }
            throw e;
        }
    }
}

