/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.bedrock.data.biome;

import com.fasterxml.jackson.annotation.JsonCreator;
import org.cloudburstmc.protocol.bedrock.data.ExpressionOp;
import org.cloudburstmc.protocol.bedrock.data.RandomDistributionType;
import org.cloudburstmc.protocol.common.util.index.Indexable;
import org.cloudburstmc.protocol.common.util.index.Unindexed;

public final class BiomeCoordinateData {
    private final ExpressionOp minValueType;
    private final transient Indexable<String> minValue;
    private final ExpressionOp maxValueType;
    private final transient Indexable<String> maxValue;
    private final long gridOffset;
    private final long gridStepSize;
    private final RandomDistributionType distribution;

    @JsonCreator
    public BiomeCoordinateData(ExpressionOp minValueType, String minValue, ExpressionOp maxValueType, String maxValue, long gridOffset, long gridStepSize, RandomDistributionType distribution) {
        this.minValueType = minValueType;
        this.minValue = new Unindexed<String>(minValue);
        this.maxValueType = maxValueType;
        this.maxValue = new Unindexed<String>(maxValue);
        this.gridOffset = gridOffset;
        this.gridStepSize = gridStepSize;
        this.distribution = distribution;
    }

    public String getMinValue() {
        return this.minValue.get();
    }

    public String getMaxValue() {
        return this.maxValue.get();
    }

    public ExpressionOp getMinValueType() {
        return this.minValueType;
    }

    public ExpressionOp getMaxValueType() {
        return this.maxValueType;
    }

    public long getGridOffset() {
        return this.gridOffset;
    }

    public long getGridStepSize() {
        return this.gridStepSize;
    }

    public RandomDistributionType getDistribution() {
        return this.distribution;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BiomeCoordinateData)) {
            return false;
        }
        BiomeCoordinateData other = (BiomeCoordinateData)o;
        if (this.getGridOffset() != other.getGridOffset()) {
            return false;
        }
        if (this.getGridStepSize() != other.getGridStepSize()) {
            return false;
        }
        ExpressionOp this$minValueType = this.getMinValueType();
        ExpressionOp other$minValueType = other.getMinValueType();
        if (this$minValueType == null ? other$minValueType != null : !((Object)((Object)this$minValueType)).equals((Object)other$minValueType)) {
            return false;
        }
        ExpressionOp this$maxValueType = this.getMaxValueType();
        ExpressionOp other$maxValueType = other.getMaxValueType();
        if (this$maxValueType == null ? other$maxValueType != null : !((Object)((Object)this$maxValueType)).equals((Object)other$maxValueType)) {
            return false;
        }
        RandomDistributionType this$distribution = this.getDistribution();
        RandomDistributionType other$distribution = other.getDistribution();
        return !(this$distribution == null ? other$distribution != null : !((Object)((Object)this$distribution)).equals((Object)other$distribution));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $gridOffset = this.getGridOffset();
        result = result * 59 + (int)($gridOffset >>> 32 ^ $gridOffset);
        long $gridStepSize = this.getGridStepSize();
        result = result * 59 + (int)($gridStepSize >>> 32 ^ $gridStepSize);
        ExpressionOp $minValueType = this.getMinValueType();
        result = result * 59 + ($minValueType == null ? 43 : ((Object)((Object)$minValueType)).hashCode());
        ExpressionOp $maxValueType = this.getMaxValueType();
        result = result * 59 + ($maxValueType == null ? 43 : ((Object)((Object)$maxValueType)).hashCode());
        RandomDistributionType $distribution = this.getDistribution();
        result = result * 59 + ($distribution == null ? 43 : ((Object)((Object)$distribution)).hashCode());
        return result;
    }

    public String toString() {
        return "BiomeCoordinateData(minValueType=" + (Object)((Object)this.getMinValueType()) + ", minValue=" + this.getMinValue() + ", maxValueType=" + (Object)((Object)this.getMaxValueType()) + ", maxValue=" + this.getMaxValue() + ", gridOffset=" + this.getGridOffset() + ", gridStepSize=" + this.getGridStepSize() + ", distribution=" + (Object)((Object)this.getDistribution()) + ")";
    }

    @Deprecated
    public BiomeCoordinateData(ExpressionOp minValueType, Indexable<String> minValue, ExpressionOp maxValueType, Indexable<String> maxValue, long gridOffset, long gridStepSize, RandomDistributionType distribution) {
        this.minValueType = minValueType;
        this.minValue = minValue;
        this.maxValueType = maxValueType;
        this.maxValue = maxValue;
        this.gridOffset = gridOffset;
        this.gridStepSize = gridStepSize;
        this.distribution = distribution;
    }
}

