/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.text;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.protocol.bedrock.packet.TextPacket;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.Component;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.JoinConfiguration;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.TranslatableComponent;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.TranslationArgument;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.flattener.ComponentFlattener;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.format.NamedTextColor;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.format.Style;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.format.StyleBuilderApplicable;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.format.TextColor;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.format.TextDecoration;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.renderer.TranslatableComponentRenderer;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.serializer.legacy.CharacterAndFormat;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.registry.JavaRegistries;
import org.geysermc.geyser.text.ChatDecoration;
import org.geysermc.geyser.text.DummyLegacyHoverEventSerializer;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.text.MinecraftTranslationRegistry;
import org.geysermc.mcprotocollib.protocol.data.DefaultComponentSerializer;
import org.geysermc.mcprotocollib.protocol.data.game.Holder;
import org.geysermc.mcprotocollib.protocol.data.game.chat.ChatType;
import org.geysermc.mcprotocollib.protocol.data.game.chat.ChatTypeDecoration;

public class MessageTranslator {
    private static final TranslatableComponentRenderer<String> RENDERER = new MinecraftTranslationRegistry();
    private static final GsonComponentSerializer GSON_SERIALIZER;
    private static final LegacyComponentSerializer BEDROCK_SERIALIZER;
    private static final String BEDROCK_COLORS;
    private static final String BASE = "\u00a7";
    private static final String RESET = "\u00a7r";
    private static final Pattern RESET_PATTERN;
    private static final Pattern LOCALIZATION_PATTERN;

    public static String convertMessage(Component message, String locale) {
        return MessageTranslator.convertMessage(message, locale, true);
    }

    public static String convertMessageForTooltip(Component message, String locale) {
        return "\u00a7r\u00a77" + MessageTranslator.convertMessageRaw(message, locale);
    }

    public static String convertMessageRaw(Component message, String locale) {
        return MessageTranslator.convertMessage(message, locale, false);
    }

    private static String convertMessage(Component message, String locale, boolean addLeadingResetFormat) {
        try {
            message = RENDERER.render(message, locale);
            String legacy = BEDROCK_SERIALIZER.serialize(message);
            StringBuilder finalLegacy = new StringBuilder();
            char[] legacyChars = legacy.toCharArray();
            boolean lastFormatReset = !addLeadingResetFormat;
            for (int i = 0; i < legacyChars.length; ++i) {
                char next;
                char legacyChar = legacyChars[i];
                if (legacyChar != '\u00a7' || i >= legacyChars.length - 1) {
                    finalLegacy.append(legacyChar);
                    lastFormatReset = false;
                    continue;
                }
                if (BEDROCK_COLORS.indexOf(next = legacyChars[++i]) != -1 && !lastFormatReset) {
                    finalLegacy.append(RESET);
                }
                finalLegacy.append(BASE).append(next);
                lastFormatReset = next == 'r';
            }
            String finalLegacyString = finalLegacy.toString();
            if ((finalLegacyString = RESET_PATTERN.matcher(finalLegacyString).replaceAll(RESET)).endsWith(RESET)) {
                finalLegacyString = finalLegacyString.substring(0, finalLegacyString.length() - 2);
            }
            if (finalLegacyString.contains("\n")) {
                StringBuilder output = new StringBuilder();
                StringBuilder lastColors = new StringBuilder();
                for (int i = 0; i < finalLegacyString.length(); ++i) {
                    char c = finalLegacyString.charAt(i);
                    output.append(c);
                    if (c == '\u00a7') {
                        char newColor = finalLegacyString.charAt(i + 1);
                        if (newColor == 'r') {
                            lastColors = new StringBuilder();
                            continue;
                        }
                        lastColors.append('\u00a7').append(newColor);
                        continue;
                    }
                    if (c != '\n' || lastColors.isEmpty()) continue;
                    output.append((CharSequence)lastColors);
                }
                return output.toString();
            }
            return finalLegacyString;
        }
        catch (Exception e) {
            GeyserImpl.getInstance().getLogger().debug((String)GSON_SERIALIZER.serialize(message));
            GeyserImpl.getInstance().getLogger().error("Failed to parse message", e);
            return "";
        }
    }

    public static String convertJsonMessage(String message, String locale) {
        return MessageTranslator.convertMessage(GSON_SERIALIZER.deserialize(message), locale);
    }

    public static String convertMessage(GeyserSession session, Component message) {
        return MessageTranslator.convertMessage(message, session.locale());
    }

    public static String convertMessage(Component message) {
        return MessageTranslator.convertMessage(message, GeyserLocale.getDefaultLocale());
    }

    public static String convertMessageLenient(String message, String locale) {
        if (message == null) {
            return "";
        }
        if (message.isBlank()) {
            return message;
        }
        try {
            return MessageTranslator.convertJsonMessage(message, locale);
        }
        catch (Exception ignored) {
            Object convertedMessage = MessageTranslator.convertMessage(LegacyComponentSerializer.legacySection().deserialize(message), locale);
            if (message.startsWith(RESET) && !((String)convertedMessage).startsWith(RESET)) {
                convertedMessage = RESET + (String)convertedMessage;
            }
            return convertedMessage;
        }
    }

    public static String convertMessageLenient(String message) {
        return MessageTranslator.convertMessageLenient(message, GeyserLocale.getDefaultLocale());
    }

    public static String convertToPlainText(Component message, String locale) {
        if (message == null) {
            return "";
        }
        return PlainTextComponentSerializer.plainText().serialize(RENDERER.render(message, locale));
    }

    public static String convertToPlainText(String message) {
        char[] input = message.toCharArray();
        char[] output = new char[input.length];
        int outputSize = 0;
        int inputLength = input.length;
        for (int i = 0; i < inputLength; ++i) {
            char c = input[i];
            if (c == '\u00a7') {
                ++i;
                continue;
            }
            output[outputSize++] = c;
        }
        return new String(output, 0, outputSize);
    }

    public static String convertToPlainTextLenient(String message, String locale) {
        if (message == null) {
            return "";
        }
        Component messageComponent = null;
        if (message.startsWith("{") && message.endsWith("}")) {
            try {
                messageComponent = GSON_SERIALIZER.deserialize(message);
                messageComponent = RENDERER.render(messageComponent, locale);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (messageComponent == null) {
            messageComponent = LegacyComponentSerializer.legacySection().deserialize(message);
        }
        return PlainTextComponentSerializer.plainText().serialize(messageComponent);
    }

    public static void handleChatPacket(GeyserSession session, Component message, Holder<ChatType> chatTypeHolder, Component targetName, Component sender, @Nullable UUID senderUuid) {
        TextPacket textPacket = new TextPacket();
        textPacket.setPlatformChatId("");
        textPacket.setSourceName("");
        if (senderUuid == null) {
            textPacket.setXuid(session.getAuthData().xuid());
        } else {
            String xuid = "";
            GeyserSession playerSession = GeyserImpl.getInstance().connectionByUuid(senderUuid);
            if (playerSession != null) {
                xuid = playerSession.getAuthData().xuid();
            } else if (senderUuid.version() == 0) {
                xuid = Long.toString(senderUuid.getLeastSignificantBits());
            }
            textPacket.setXuid(xuid);
        }
        textPacket.setType(TextPacket.Type.CHAT);
        textPacket.setNeedsTranslation(false);
        ChatType chatType = chatTypeHolder.getOrCompute(session.getRegistryCache().registry(JavaRegistries.CHAT_TYPE)::byId);
        if (chatType != null && chatType.chat() != null) {
            ChatTypeDecoration chat = chatType.chat();
            TranslatableComponent.Builder withDecoration = (TranslatableComponent.Builder)Component.translatable().key(chat.translationKey()).style(ChatDecoration.getStyle(chat));
            List<ChatTypeDecoration.Parameter> parameters = chat.parameters();
            ArrayList<Component> args = new ArrayList<Component>(3);
            if (parameters.contains((Object)ChatTypeDecoration.Parameter.TARGET)) {
                args.add(targetName);
            }
            if (parameters.contains((Object)ChatTypeDecoration.Parameter.SENDER)) {
                args.add(sender);
            }
            if (parameters.contains((Object)ChatTypeDecoration.Parameter.CONTENT)) {
                args.add(message);
            }
            withDecoration.arguments(args);
            textPacket.setMessage(MessageTranslator.convertMessage((Component)withDecoration.build(), session.locale()));
        } else {
            session.getGeyser().getLogger().debug("Likely illegal chat type detection found.");
            if (session.getGeyser().config().debugMode()) {
                Thread.dumpStack();
            }
            textPacket.setMessage(MessageTranslator.convertMessage(message, session.locale()));
        }
        session.sendUpstreamPacket(textPacket);
    }

    public static boolean isTooLong(String message, GeyserSession session) {
        if (message.length() > 256) {
            session.sendMessage(GeyserLocale.getPlayerLocaleString("geyser.chat.too_long", session.locale(), message.length()));
            return true;
        }
        return false;
    }

    public static String normalizeSpace(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        int size = string.length();
        char[] newChars = new char[size];
        int count = 0;
        int whitespacesCount = 0;
        boolean startWhitespaces = true;
        for (int i = 0; i < size; ++i) {
            char actualChar = string.charAt(i);
            boolean isWhitespace = Character.isWhitespace(actualChar);
            if (isWhitespace) {
                if (whitespacesCount == 0 && !startWhitespaces) {
                    newChars[count++] = 32;
                }
                ++whitespacesCount;
                continue;
            }
            startWhitespaces = false;
            newChars[count++] = actualChar == '\u00a0' ? 32 : (int)actualChar;
            whitespacesCount = 0;
        }
        if (startWhitespaces) {
            return "";
        }
        return new String(newChars, 0, count - (whitespacesCount > 0 ? 1 : 0)).trim();
    }

    public static String deserializeDescription(GeyserSession session, NbtMap tag) {
        Object description = tag.get("description");
        Component parsed = MessageTranslator.componentFromNbtTag(description);
        return MessageTranslator.convertMessage(session, parsed);
    }

    public static String deserializeDescriptionForTooltip(GeyserSession session, NbtMap tag) {
        Object description = tag.get("description");
        Component parsed = MessageTranslator.componentFromNbtTag(description);
        return MessageTranslator.convertMessageForTooltip(parsed, session.locale());
    }

    public static @Nullable String convertFromNullableNbtTag(Optional<GeyserSession> session, @Nullable Object nbtTag) {
        if (nbtTag == null) {
            return null;
        }
        return session.map(present -> MessageTranslator.convertMessage(present, MessageTranslator.componentFromNbtTag(nbtTag))).orElse("MISSING GEYSER SESSION");
    }

    public static Component componentFromNbtTag(Object nbtTag) {
        return MessageTranslator.componentFromNbtTag(nbtTag, Style.empty());
    }

    public static List<String> signTextFromNbtTag(GeyserSession session, List<?> nbtTag) {
        List<Component> components = MessageTranslator.componentsFromNbtList(nbtTag, Style.empty());
        ArrayList<String> messages = new ArrayList<String>();
        for (Component component : components) {
            messages.add(MessageTranslator.convertMessageRaw(component, session.locale()));
        }
        return messages;
    }

    private static Component componentFromNbtTag(Object nbtTag, Style style) {
        if (nbtTag instanceof String) {
            String literal = (String)nbtTag;
            return Component.text(literal).style(style);
        }
        if (nbtTag instanceof List) {
            List list = (List)nbtTag;
            return Component.join(JoinConfiguration.noSeparators(), MessageTranslator.componentsFromNbtList(list, style));
        }
        if (nbtTag instanceof NbtMap) {
            NbtMap map = (NbtMap)nbtTag;
            Component component = null;
            String text = map.getString("text", map.getString("", null));
            if (text != null) {
                component = Component.text(text);
            } else {
                String translateKey = map.getString("translate", null);
                if (translateKey != null) {
                    String fallback = map.getString("fallback", null);
                    List<Component> args = new ArrayList<Component>();
                    Object with = map.get("with");
                    if (with instanceof List) {
                        List list = (List)with;
                        args = MessageTranslator.componentsFromNbtList(list, style);
                    } else if (with != null) {
                        args.add(MessageTranslator.componentFromNbtTag(with, style));
                    }
                    component = Component.translatable(translateKey, fallback, args, new StyleBuilderApplicable[0]);
                }
            }
            if (component != null) {
                Style newStyle = MessageTranslator.getStyleFromNbtMap(map, style);
                component = component.style(newStyle);
                Object extra = map.get("extra");
                if (extra != null) {
                    component = component.append(MessageTranslator.componentFromNbtTag(extra, newStyle));
                }
                return component;
            }
        }
        GeyserImpl.getInstance().getLogger().error("Expected tag to be a literal string, a list of components, or a component object with a text/translate key: " + String.valueOf(nbtTag));
        return Component.empty();
    }

    private static List<Component> componentsFromNbtList(List<?> list, Style style) {
        ArrayList<Component> components = new ArrayList<Component>();
        for (Object entry : list) {
            components.add(MessageTranslator.componentFromNbtTag(entry, style));
        }
        return components;
    }

    public static Style getStyleFromNbtMap(NbtMap map) {
        Style.Builder style = Style.style();
        String colorString = map.getString("color", null);
        if (colorString != null) {
            if (colorString.startsWith("#")) {
                style.color(TextColor.fromHexString(colorString));
            } else {
                style.color(NamedTextColor.NAMES.value(colorString));
            }
        }
        map.listenForBoolean("bold", value -> style.decoration(TextDecoration.BOLD, value));
        map.listenForBoolean("italic", value -> style.decoration(TextDecoration.ITALIC, value));
        map.listenForBoolean("underlined", value -> style.decoration(TextDecoration.UNDERLINED, value));
        map.listenForBoolean("strikethrough", value -> style.decoration(TextDecoration.STRIKETHROUGH, value));
        map.listenForBoolean("obfuscated", value -> style.decoration(TextDecoration.OBFUSCATED, value));
        return style.build();
    }

    public static Style getStyleFromNbtMap(NbtMap map, Style base) {
        return base.merge(MessageTranslator.getStyleFromNbtMap(map));
    }

    public static void init() {
    }

    static {
        RESET_PATTERN = Pattern.compile("(\u00a7r){2,}");
        LOCALIZATION_PATTERN = Pattern.compile("%(?:(\\d+)\\$)?s");
        GSON_SERIALIZER = ((GsonComponentSerializer.Builder)DefaultComponentSerializer.get().toBuilder()).legacyHoverEventSerializer(new DummyLegacyHoverEventSerializer()).build();
        DefaultComponentSerializer.set(GSON_SERIALIZER);
        ArrayList<CharacterAndFormat> formats = new ArrayList<CharacterAndFormat>(CharacterAndFormat.defaults());
        formats.remove(CharacterAndFormat.STRIKETHROUGH);
        formats.remove(CharacterAndFormat.UNDERLINED);
        formats.add(CharacterAndFormat.characterAndFormat('g', TextColor.color(221, 214, 5)));
        formats.add(CharacterAndFormat.characterAndFormat('h', TextColor.color(227, 212, 209)));
        formats.add(CharacterAndFormat.characterAndFormat('i', TextColor.color(206, 202, 202)));
        formats.add(CharacterAndFormat.characterAndFormat('j', TextColor.color(68, 58, 59)));
        formats.add(CharacterAndFormat.characterAndFormat('m', TextColor.color(151, 22, 7)));
        formats.add(CharacterAndFormat.characterAndFormat('n', TextColor.color(180, 104, 77)));
        formats.add(CharacterAndFormat.characterAndFormat('p', TextColor.color(222, 177, 45)));
        formats.add(CharacterAndFormat.characterAndFormat('q', TextColor.color(17, 160, 54)));
        formats.add(CharacterAndFormat.characterAndFormat('s', TextColor.color(44, 186, 168)));
        formats.add(CharacterAndFormat.characterAndFormat('t', TextColor.color(33, 73, 123)));
        formats.add(CharacterAndFormat.characterAndFormat('u', TextColor.color(154, 92, 198)));
        ComponentFlattener flattener = (ComponentFlattener)((ComponentFlattener.Builder)ComponentFlattener.basic().toBuilder()).nestingLimit(30).complexMapper(TranslatableComponent.class, (translatable, consumer) -> {
            String translated = translatable.key();
            Matcher matcher = LOCALIZATION_PATTERN.matcher(translated);
            List<TranslationArgument> args = translatable.arguments();
            int argPosition = 0;
            int lastIdx = 0;
            while (matcher.find()) {
                int idx;
                if (lastIdx < matcher.start()) {
                    consumer.accept(Component.text(translated.substring(lastIdx, matcher.start())));
                }
                lastIdx = matcher.end();
                @Nullable String argIdx = matcher.group(1);
                if (argIdx != null) {
                    try {
                        idx = Integer.parseInt(argIdx) - 1;
                        if (idx >= args.size()) continue;
                        consumer.accept(args.get(idx).asComponent());
                    }
                    catch (NumberFormatException idx2) {}
                    continue;
                }
                if ((idx = argPosition++) >= args.size()) continue;
                consumer.accept(args.get(idx).asComponent());
            }
            if (lastIdx < translated.length()) {
                consumer.accept(Component.text(translated.substring(lastIdx)));
            }
        }).build();
        BEDROCK_SERIALIZER = ((LegacyComponentSerializer.Builder)LegacyComponentSerializer.legacySection().toBuilder()).formats(formats).flattener(flattener).build();
        StringBuilder colorBuilder = new StringBuilder();
        for (CharacterAndFormat format : formats) {
            if (!(format.format() instanceof TextColor)) continue;
            colorBuilder.append(format.character());
        }
        BEDROCK_COLORS = colorBuilder.toString();
    }
}

