/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.advancement;

import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.Component;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;

public class Advancement {
    @lombok.NonNull
    private final String id;
    @lombok.NonNull
    private final List<List<String>> requirements;
    private final String parentId;
    private final DisplayData displayData;
    private final boolean sendsTelemetryEvent;

    public Advancement(@lombok.NonNull String id, @lombok.NonNull List<List<String>> requirements, boolean sendsTelemetryEvent) {
        this(id, requirements, null, null, sendsTelemetryEvent);
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (requirements == null) {
            throw new NullPointerException("requirements is marked non-null but is null");
        }
    }

    public Advancement(@lombok.NonNull String id, @lombok.NonNull List<List<String>> requirements, String parentId, boolean sendsTelemetryEvent) {
        this(id, requirements, parentId, null, sendsTelemetryEvent);
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (requirements == null) {
            throw new NullPointerException("requirements is marked non-null but is null");
        }
    }

    public Advancement(@lombok.NonNull String id, @lombok.NonNull List<List<String>> requirements, DisplayData displayData, boolean sendsTelemetryEvent) {
        this(id, requirements, null, displayData, sendsTelemetryEvent);
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (requirements == null) {
            throw new NullPointerException("requirements is marked non-null but is null");
        }
    }

    @lombok.NonNull
    public String getId() {
        return this.id;
    }

    @lombok.NonNull
    public List<List<String>> getRequirements() {
        return this.requirements;
    }

    public String getParentId() {
        return this.parentId;
    }

    public DisplayData getDisplayData() {
        return this.displayData;
    }

    public boolean isSendsTelemetryEvent() {
        return this.sendsTelemetryEvent;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Advancement)) {
            return false;
        }
        Advancement other = (Advancement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSendsTelemetryEvent() != other.isSendsTelemetryEvent()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        List<List<String>> this$requirements = this.getRequirements();
        List<List<String>> other$requirements = other.getRequirements();
        if (this$requirements == null ? other$requirements != null : !((Object)this$requirements).equals(other$requirements)) {
            return false;
        }
        String this$parentId = this.getParentId();
        String other$parentId = other.getParentId();
        if (this$parentId == null ? other$parentId != null : !this$parentId.equals(other$parentId)) {
            return false;
        }
        DisplayData this$displayData = this.getDisplayData();
        DisplayData other$displayData = other.getDisplayData();
        return !(this$displayData == null ? other$displayData != null : !((Object)this$displayData).equals(other$displayData));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof Advancement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSendsTelemetryEvent() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        List<List<String>> $requirements = this.getRequirements();
        result = result * 59 + ($requirements == null ? 43 : ((Object)$requirements).hashCode());
        String $parentId = this.getParentId();
        result = result * 59 + ($parentId == null ? 43 : $parentId.hashCode());
        DisplayData $displayData = this.getDisplayData();
        result = result * 59 + ($displayData == null ? 43 : ((Object)$displayData).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "Advancement(id=" + this.getId() + ", requirements=" + String.valueOf(this.getRequirements()) + ", parentId=" + this.getParentId() + ", displayData=" + String.valueOf(this.getDisplayData()) + ", sendsTelemetryEvent=" + this.isSendsTelemetryEvent() + ")";
    }

    public Advancement(@lombok.NonNull String id, @lombok.NonNull List<List<String>> requirements, String parentId, DisplayData displayData, boolean sendsTelemetryEvent) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (requirements == null) {
            throw new NullPointerException("requirements is marked non-null but is null");
        }
        this.id = id;
        this.requirements = requirements;
        this.parentId = parentId;
        this.displayData = displayData;
        this.sendsTelemetryEvent = sendsTelemetryEvent;
    }

    public static class DisplayData {
        @lombok.NonNull
        private final Component title;
        @lombok.NonNull
        private final Component description;
        private final @Nullable ItemStack icon;
        @lombok.NonNull
        private final AdvancementType advancementType;
        private final boolean showToast;
        private final boolean hidden;
        private final float posX;
        private final float posY;
        private final @Nullable String backgroundTexture;

        public DisplayData(@lombok.NonNull Component title, @lombok.NonNull Component description, @Nullable ItemStack icon, @lombok.NonNull AdvancementType advancementType, boolean showToast, boolean hidden, float posX, float posY) {
            this(title, description, icon, advancementType, showToast, hidden, posX, posY, null);
            if (title == null) {
                throw new NullPointerException("title is marked non-null but is null");
            }
            if (description == null) {
                throw new NullPointerException("description is marked non-null but is null");
            }
            if (advancementType == null) {
                throw new NullPointerException("advancementType is marked non-null but is null");
            }
        }

        @lombok.NonNull
        public Component getTitle() {
            return this.title;
        }

        @lombok.NonNull
        public Component getDescription() {
            return this.description;
        }

        public @Nullable ItemStack getIcon() {
            return this.icon;
        }

        @lombok.NonNull
        public AdvancementType getAdvancementType() {
            return this.advancementType;
        }

        public boolean isShowToast() {
            return this.showToast;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public float getPosX() {
            return this.posX;
        }

        public float getPosY() {
            return this.posY;
        }

        public @Nullable String getBackgroundTexture() {
            return this.backgroundTexture;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DisplayData)) {
                return false;
            }
            DisplayData other = (DisplayData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isShowToast() != other.isShowToast()) {
                return false;
            }
            if (this.isHidden() != other.isHidden()) {
                return false;
            }
            if (Float.compare(this.getPosX(), other.getPosX()) != 0) {
                return false;
            }
            if (Float.compare(this.getPosY(), other.getPosY()) != 0) {
                return false;
            }
            Component this$title = this.getTitle();
            Component other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                return false;
            }
            Component this$description = this.getDescription();
            Component other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            ItemStack this$icon = this.getIcon();
            ItemStack other$icon = other.getIcon();
            if (this$icon == null ? other$icon != null : !((Object)this$icon).equals(other$icon)) {
                return false;
            }
            AdvancementType this$advancementType = this.getAdvancementType();
            AdvancementType other$advancementType = other.getAdvancementType();
            if (this$advancementType == null ? other$advancementType != null : !((Object)((Object)this$advancementType)).equals((Object)other$advancementType)) {
                return false;
            }
            String this$backgroundTexture = this.getBackgroundTexture();
            String other$backgroundTexture = other.getBackgroundTexture();
            return !(this$backgroundTexture == null ? other$backgroundTexture != null : !this$backgroundTexture.equals(other$backgroundTexture));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof DisplayData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isShowToast() ? 79 : 97);
            result = result * 59 + (this.isHidden() ? 79 : 97);
            result = result * 59 + Float.floatToIntBits(this.getPosX());
            result = result * 59 + Float.floatToIntBits(this.getPosY());
            Component $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            Component $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            ItemStack $icon = this.getIcon();
            result = result * 59 + ($icon == null ? 43 : ((Object)$icon).hashCode());
            AdvancementType $advancementType = this.getAdvancementType();
            result = result * 59 + ($advancementType == null ? 43 : ((Object)((Object)$advancementType)).hashCode());
            String $backgroundTexture = this.getBackgroundTexture();
            result = result * 59 + ($backgroundTexture == null ? 43 : $backgroundTexture.hashCode());
            return result;
        }

        public @NonNull String toString() {
            return "Advancement.DisplayData(title=" + String.valueOf(this.getTitle()) + ", description=" + String.valueOf(this.getDescription()) + ", icon=" + String.valueOf(this.getIcon()) + ", advancementType=" + String.valueOf((Object)this.getAdvancementType()) + ", showToast=" + this.isShowToast() + ", hidden=" + this.isHidden() + ", posX=" + this.getPosX() + ", posY=" + this.getPosY() + ", backgroundTexture=" + this.getBackgroundTexture() + ")";
        }

        public DisplayData(@lombok.NonNull Component title, @lombok.NonNull Component description, @Nullable ItemStack icon, @lombok.NonNull AdvancementType advancementType, boolean showToast, boolean hidden, float posX, float posY, @Nullable String backgroundTexture) {
            if (title == null) {
                throw new NullPointerException("title is marked non-null but is null");
            }
            if (description == null) {
                throw new NullPointerException("description is marked non-null but is null");
            }
            if (advancementType == null) {
                throw new NullPointerException("advancementType is marked non-null but is null");
            }
            this.title = title;
            this.description = description;
            this.icon = icon;
            this.advancementType = advancementType;
            this.showToast = showToast;
            this.hidden = hidden;
            this.posX = posX;
            this.posY = posY;
            this.backgroundTexture = backgroundTexture;
        }

        public static enum AdvancementType {
            TASK,
            CHALLENGE,
            GOAL;

            private static final AdvancementType[] VALUES;

            public static AdvancementType from(int id) {
                return VALUES[id];
            }

            static {
                VALUES = AdvancementType.values();
            }
        }
    }
}

