/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.httpclient.utils;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import net.lenni0451.commons.httpclient.utils.URLCoder;
import org.jetbrains.annotations.ApiStatus;

public class URLWrapper {
    private String protocol;
    private String host;
    private int port = -1;
    private String path;
    private String query;
    private String userInfo;
    private String fragment;

    public static URLWrapper empty() {
        return new URLWrapper();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static URLWrapper of(String url) throws MalformedURLException {
        return URLWrapper.ofURL(url);
    }

    public static URLWrapper ofURL(String url) throws MalformedURLException {
        return new URLWrapper(new URL(url));
    }

    public static URLWrapper ofURI(String uri) throws IllegalArgumentException {
        return new URLWrapper(URI.create(uri));
    }

    public static URLWrapper of(URL url) {
        return new URLWrapper(url);
    }

    public static URLWrapper of(URI uri) {
        return new URLWrapper(uri);
    }

    public URLWrapper() {
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public URLWrapper(String url) throws MalformedURLException {
        this(new URL(url));
    }

    public URLWrapper(URL url) {
        this.protocol = url.getProtocol();
        this.host = this.emptyToNull(url.getHost());
        this.port = url.getPort();
        this.path = this.emptyToNull(url.getPath());
        this.query = this.emptyToNull(url.getQuery());
        this.userInfo = this.emptyToNull(url.getUserInfo());
        this.fragment = this.emptyToNull(url.getRef());
    }

    public URLWrapper(URI uri) {
        this.protocol = this.emptyToNull(uri.getScheme());
        this.host = this.emptyToNull(uri.getHost());
        this.port = uri.getPort();
        this.path = this.emptyToNull(uri.getPath());
        this.query = this.emptyToNull(uri.getQuery());
        this.userInfo = this.emptyToNull(uri.getUserInfo());
        this.fragment = this.emptyToNull(uri.getFragment());
    }

    public boolean hasProtocol() {
        return this.protocol != null;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getProtocolOr(String defaultProtocol) {
        return this.protocol == null ? defaultProtocol : this.protocol;
    }

    public URLWrapper setProtocol(String protocol) {
        this.protocol = this.emptyToNull(protocol);
        return this;
    }

    public boolean hasHost() {
        return this.host != null;
    }

    public String getHost() {
        return this.host;
    }

    public String getHostOr(String defaultHost) {
        return this.host == null ? defaultHost : this.host;
    }

    public URLWrapper setHost(String host) {
        this.host = this.emptyToNull(host);
        return this;
    }

    public boolean hasPort() {
        return this.port >= 0;
    }

    public int getPort() {
        return this.port;
    }

    public int getPortOr(int defaultPort) {
        return this.port < 0 ? defaultPort : this.port;
    }

    public URLWrapper setPort(int port) {
        if (port > 65535) {
            throw new IllegalArgumentException("Port must not be greater than 65535");
        }
        this.port = port;
        return this;
    }

    public boolean hasPath() {
        return this.path != null;
    }

    public String getPath() {
        return this.path;
    }

    public String getPathOr(String defaultPath) {
        return this.path == null ? defaultPath : this.path;
    }

    public URLWrapper setPath(String path) {
        this.path = this.emptyToNull(path);
        return this;
    }

    public boolean hasQuery() {
        return this.query != null;
    }

    public String getQuery() {
        return this.query;
    }

    public String getQueryOr(String defaultQuery) {
        return this.query;
    }

    public URLWrapper setQuery(String query) {
        this.query = this.emptyToNull(query);
        return this;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public QueryWrapper wrapQuery() {
        return new QueryWrapper();
    }

    public QueryParametersWrapper wrapQueryParameters() {
        return new QueryParametersWrapper();
    }

    public boolean hasUserInfo() {
        return this.userInfo != null;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getUserInfoOr(String defaultUserInfo) {
        return this.userInfo == null ? defaultUserInfo : this.userInfo;
    }

    public URLWrapper setUserInfo(String userInfo) {
        this.userInfo = this.emptyToNull(userInfo);
        return this;
    }

    public boolean hasFragment() {
        return this.fragment != null;
    }

    public String getFragment() {
        return this.fragment;
    }

    public String getFragmentOr(String defaultFragment) {
        return this.fragment == null ? defaultFragment : this.fragment;
    }

    public URLWrapper setFragment(String fragment) {
        this.fragment = this.emptyToNull(fragment);
        return this;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public String getReference() {
        return this.getFragment();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public URLWrapper setReference(String reference) {
        return this.setFragment(reference);
    }

    public URL toURL() throws MalformedURLException {
        return new URL(this.toString());
    }

    public URI toURI() {
        return URI.create(this.toString());
    }

    public String toString() {
        StringBuilder url = new StringBuilder();
        if (this.protocol != null) {
            url.append(this.protocol).append("://");
        }
        if (this.userInfo != null) {
            url.append(this.userInfo).append("@");
        }
        if (this.host != null) {
            url.append(this.host);
        }
        if (this.port >= 0) {
            url.append(":").append(this.port);
        }
        if (this.path != null) {
            if (!this.path.startsWith("/")) {
                url.append("/");
            }
            url.append(this.path);
        }
        if (this.query != null) {
            url.append("?").append(this.query);
        }
        if (this.fragment != null) {
            url.append("#").append(this.fragment);
        }
        return url.toString();
    }

    private String emptyToNull(String s) {
        return s == null || s.isEmpty() ? null : s;
    }

    public static class Parameter {
        private String key;
        @Nullable
        private String value;

        public Parameter(String key) {
            this.key = key;
        }

        public Parameter(String key, @Nullable String value) {
            this.key = key;
            this.value = value;
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Nullable
        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public void setKey(String key) {
            this.key = key;
        }

        @Generated
        public void setValue(@Nullable String value) {
            this.value = value;
        }
    }

    public class QueryParametersWrapper {
        private final List<Parameter> parameters = new ArrayList<Parameter>();

        public QueryParametersWrapper() {
            String query = URLWrapper.this.getQuery();
            if (query != null && !query.isEmpty()) {
                for (String queryPart : query.split("&")) {
                    String[] split = queryPart.split("=", 2);
                    if (split.length == 2) {
                        this.parameters.add(new Parameter(URLCoder.decode(split[0]), URLCoder.decode(split[1])));
                        continue;
                    }
                    this.parameters.add(new Parameter(URLCoder.decode(split[0])));
                }
            }
        }

        public List<String> getValues(String key) {
            return this.parameters.stream().filter(param -> param.getKey().equals(key)).map(Parameter::getValue).filter(Objects::nonNull).collect(Collectors.toList());
        }

        public Optional<String> getFirstValue(String key) {
            return this.parameters.stream().filter(param -> param.getKey().equals(key)).map(Parameter::getValue).filter(Objects::nonNull).findFirst();
        }

        public boolean hasParameter(String key) {
            return this.parameters.stream().anyMatch(param -> param.getKey().equals(key));
        }

        public QueryParametersWrapper addParameter(String key, @Nullable String value) {
            this.parameters.add(new Parameter(key, value));
            return this;
        }

        public QueryParametersWrapper addParameter(Parameter parameter) {
            this.parameters.add(parameter);
            return this;
        }

        public QueryParametersWrapper addParameters(Iterable<Parameter> parameters) {
            parameters.forEach(this.parameters::add);
            return this;
        }

        public QueryParametersWrapper addParameters(Parameter[] parameters) {
            Collections.addAll(this.parameters, parameters);
            return this;
        }

        public QueryParametersWrapper addParameters(Map<String, String> parameters) {
            parameters.forEach((key, value) -> this.parameters.add(new Parameter((String)key, (String)value)));
            return this;
        }

        public QueryParametersWrapper setParameter(String key, @Nullable String value) {
            this.parameters.removeIf(param -> param.getKey().equals(key));
            this.parameters.add(new Parameter(key, value));
            return this;
        }

        public QueryParametersWrapper setParameters(Map<String, String> parameters) {
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                this.setParameter(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public QueryParametersWrapper removeParameters(String key) {
            this.parameters.removeIf(param -> param.getKey().equals(key));
            return this;
        }

        public QueryParametersWrapper clearParameters() {
            this.parameters.clear();
            return this;
        }

        public URLWrapper apply() {
            StringBuilder query = new StringBuilder();
            for (Parameter parameter : this.parameters) {
                query.append(URLCoder.encode(parameter.getKey()));
                if (parameter.getValue() != null) {
                    query.append("=").append(URLCoder.encode(parameter.getValue()));
                }
                query.append("&");
            }
            if (query.length() > 0) {
                query.deleteCharAt(query.length() - 1);
            }
            URLWrapper.this.setQuery(query.toString());
            return URLWrapper.this;
        }

        @Generated
        public List<Parameter> getParameters() {
            return this.parameters;
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public class QueryWrapper {
        private final Map<String, String> queries = new HashMap<String, String>();

        private QueryWrapper() {
            String query = URLWrapper.this.getQuery();
            if (query != null && !query.isEmpty()) {
                for (String queryPart : query.split("&")) {
                    String[] split = queryPart.split("=", 2);
                    if (split.length == 2) {
                        this.queries.put(URLCoder.decode(split[0]), URLCoder.decode(split[1]));
                        continue;
                    }
                    this.queries.put(URLCoder.decode(split[0]), "");
                }
            }
        }

        public Map<String, String> getQueries() {
            return Collections.unmodifiableMap(this.queries);
        }

        public Optional<String> getQuery(String key) {
            return Optional.ofNullable(this.queries.get(key));
        }

        public QueryWrapper setQuery(String key, String value) {
            this.queries.put(key, value);
            return this;
        }

        public QueryWrapper addQueries(Map<String, String> queries) {
            this.queries.putAll(queries);
            return this;
        }

        public QueryWrapper removeQuery(String key) {
            this.queries.remove(key);
            return this;
        }

        public boolean hasQuery(String key) {
            return this.queries.containsKey(key);
        }

        public URLWrapper apply() {
            StringBuilder query = new StringBuilder();
            for (Map.Entry<String, String> entry : this.queries.entrySet()) {
                query.append(URLCoder.encode(entry.getKey())).append("=").append(URLCoder.encode(entry.getValue())).append("&");
            }
            if (query.length() > 0) {
                query.deleteCharAt(query.length() - 1);
            }
            URLWrapper.this.setQuery(query.toString());
            return URLWrapper.this;
        }

        public URLWrapper discard() {
            return URLWrapper.this;
        }
    }
}

