/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound;

import io.netty.buffer.ByteBuf;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;

public class ServerboundChatSessionUpdatePacket
implements MinecraftPacket {
    private final UUID sessionId;
    private final long expiresAt;
    private final PublicKey publicKey;
    private final byte[] keySignature;

    public ServerboundChatSessionUpdatePacket(ByteBuf in) {
        PublicKey publicKey;
        this.sessionId = MinecraftTypes.readUUID(in);
        this.expiresAt = in.readLong();
        byte[] keyBytes = MinecraftTypes.readByteArray(in);
        this.keySignature = MinecraftTypes.readByteArray(in);
        try {
            publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(keyBytes));
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("Could not decode public key.", e);
        }
        this.publicKey = publicKey;
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeUUID(out, this.sessionId);
        out.writeLong(this.expiresAt);
        MinecraftTypes.writeByteArray(out, this.publicKey.getEncoded());
        MinecraftTypes.writeByteArray(out, this.keySignature);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public UUID getSessionId() {
        return this.sessionId;
    }

    public long getExpiresAt() {
        return this.expiresAt;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public byte[] getKeySignature() {
        return this.keySignature;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundChatSessionUpdatePacket)) {
            return false;
        }
        ServerboundChatSessionUpdatePacket other = (ServerboundChatSessionUpdatePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getExpiresAt() != other.getExpiresAt()) {
            return false;
        }
        UUID this$sessionId = this.getSessionId();
        UUID other$sessionId = other.getSessionId();
        if (this$sessionId == null ? other$sessionId != null : !((Object)this$sessionId).equals(other$sessionId)) {
            return false;
        }
        PublicKey this$publicKey = this.getPublicKey();
        PublicKey other$publicKey = other.getPublicKey();
        if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
            return false;
        }
        return Arrays.equals(this.getKeySignature(), other.getKeySignature());
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundChatSessionUpdatePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $expiresAt = this.getExpiresAt();
        result = result * 59 + (int)($expiresAt >>> 32 ^ $expiresAt);
        UUID $sessionId = this.getSessionId();
        result = result * 59 + ($sessionId == null ? 43 : ((Object)$sessionId).hashCode());
        PublicKey $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        result = result * 59 + Arrays.hashCode(this.getKeySignature());
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundChatSessionUpdatePacket(sessionId=" + String.valueOf(this.getSessionId()) + ", expiresAt=" + this.getExpiresAt() + ", publicKey=" + String.valueOf(this.getPublicKey()) + ", keySignature=" + Arrays.toString(this.getKeySignature()) + ")";
    }

    public @NonNull ServerboundChatSessionUpdatePacket withSessionId(UUID sessionId) {
        return this.sessionId == sessionId ? this : new ServerboundChatSessionUpdatePacket(sessionId, this.expiresAt, this.publicKey, this.keySignature);
    }

    public @NonNull ServerboundChatSessionUpdatePacket withExpiresAt(long expiresAt) {
        return this.expiresAt == expiresAt ? this : new ServerboundChatSessionUpdatePacket(this.sessionId, expiresAt, this.publicKey, this.keySignature);
    }

    public @NonNull ServerboundChatSessionUpdatePacket withPublicKey(PublicKey publicKey) {
        return this.publicKey == publicKey ? this : new ServerboundChatSessionUpdatePacket(this.sessionId, this.expiresAt, publicKey, this.keySignature);
    }

    public @NonNull ServerboundChatSessionUpdatePacket withKeySignature(byte[] keySignature) {
        return this.keySignature == keySignature ? this : new ServerboundChatSessionUpdatePacket(this.sessionId, this.expiresAt, this.publicKey, keySignature);
    }

    public ServerboundChatSessionUpdatePacket(UUID sessionId, long expiresAt, PublicKey publicKey, byte[] keySignature) {
        this.sessionId = sessionId;
        this.expiresAt = expiresAt;
        this.publicKey = publicKey;
        this.keySignature = keySignature;
    }
}

