/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.math.immutable.vector;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.cloudburstmc.math.vector.Vector4i;

@ParametersAreNonnullByDefault
@Immutable
public class ImmutableVector4i
extends Vector4i {
    private static final long serialVersionUID = 1L;
    private final int x;
    private final int y;
    private final int z;
    private final int w;
    private volatile transient boolean hashed = false;
    private volatile transient int hashCode = 0;

    ImmutableVector4i(int x, int y, int z, int w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    @Override
    public int getW() {
        return this.w;
    }

    @Override
    @Nonnull
    public Vector4i add(int x, int y, int z, int w) {
        return Vector4i.from(this.x + x, this.y + y, this.z + z, this.w + w);
    }

    @Override
    @Nonnull
    public Vector4i sub(int x, int y, int z, int w) {
        return Vector4i.from(this.x - x, this.y - y, this.z - z, this.w - w);
    }

    @Override
    @Nonnull
    public Vector4i mul(int x, int y, int z, int w) {
        return Vector4i.from(this.x * x, this.y * y, this.z * z, this.w * w);
    }

    @Override
    @Nonnull
    public Vector4i div(int x, int y, int z, int w) {
        return Vector4i.from(this.x / x, this.y / y, this.z / z, this.w / w);
    }

    @Override
    @Nonnull
    public Vector4i project(int x, int y, int z, int w) {
        int lengthSquared = x * x + y * y + z * z + w * w;
        if (lengthSquared == 0) {
            throw new ArithmeticException("Cannot project onto the zero vector");
        }
        float a = (float)this.dot(x, y, z, w) / (float)lengthSquared;
        return Vector4i.from(a * (float)x, a * (float)y, a * (float)z, a * (float)w);
    }

    @Override
    @Nonnull
    public Vector4i pow(int power) {
        return Vector4i.from(Math.pow(this.x, power), Math.pow(this.y, power), Math.pow(this.z, power), Math.pow(this.w, power));
    }

    @Override
    @Nonnull
    public Vector4i abs() {
        return Vector4i.from(Math.abs(this.x), Math.abs(this.y), Math.abs(this.z), Math.abs(this.w));
    }

    @Override
    @Nonnull
    public Vector4i negate() {
        return Vector4i.from(-this.x, -this.y, -this.z, -this.w);
    }

    @Override
    @Nonnull
    public Vector4i min(int x, int y, int z, int w) {
        return Vector4i.from(Math.min(this.x, x), Math.min(this.y, y), Math.min(this.z, z), Math.min(this.w, w));
    }

    @Override
    @Nonnull
    public Vector4i max(int x, int y, int z, int w) {
        return Vector4i.from(Math.max(this.x, x), Math.max(this.y, y), Math.max(this.z, z), Math.max(this.w, w));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Vector4i)) {
            return false;
        }
        Vector4i vector4 = (Vector4i)o;
        if (vector4.getX() != this.x) {
            return false;
        }
        if (vector4.getY() != this.y) {
            return false;
        }
        if (vector4.getZ() != this.z) {
            return false;
        }
        return vector4.getW() == this.w;
    }

    public int hashCode() {
        if (!this.hashed) {
            int result = (float)this.x != 0.0f ? Integer.hashCode(this.x) : 0;
            result = 31 * result + ((float)this.y != 0.0f ? Integer.hashCode(this.y) : 0);
            result = 31 * result + ((float)this.z != 0.0f ? Integer.hashCode(this.z) : 0);
            this.hashCode = 31 * result + ((float)this.w != 0.0f ? Integer.hashCode(this.w) : 0);
            this.hashed = true;
        }
        return this.hashCode;
    }
}

