/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.entity;

import org.cloudburstmc.math.vector.Vector3f;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.FallingBlockEntity;
import org.geysermc.geyser.entity.type.FishingHookEntity;
import org.geysermc.geyser.entity.type.HangingEntity;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.skin.SkinManager;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.EnvironmentUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.Pose;
import org.geysermc.mcprotocollib.protocol.data.game.entity.object.Direction;
import org.geysermc.mcprotocollib.protocol.data.game.entity.object.FallingBlockData;
import org.geysermc.mcprotocollib.protocol.data.game.entity.object.ProjectileData;
import org.geysermc.mcprotocollib.protocol.data.game.entity.object.WardenData;
import org.geysermc.mcprotocollib.protocol.data.game.entity.type.EntityType;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity.ClientboundAddEntityPacket;

@Translator(packet=ClientboundAddEntityPacket.class)
public class JavaAddEntityTranslator
extends PacketTranslator<ClientboundAddEntityPacket> {
    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void translate(GeyserSession session, ClientboundAddEntityPacket packet) {
        void var9_15;
        WardenData wardenData;
        EntityDefinition definition = (EntityDefinition)Registries.ENTITY_DEFINITIONS.get(packet.getType());
        if (definition == null) {
            session.getGeyser().getLogger().debug("Could not find an entity definition with type " + String.valueOf((Object)packet.getType()));
            return;
        }
        Vector3f position = Vector3f.from((double)packet.getX(), (double)packet.getY(), (double)packet.getZ());
        Vector3f motion = Vector3f.from((double)packet.getMotionX(), (double)packet.getMotionY(), (double)packet.getMotionZ());
        float yaw = packet.getYaw();
        float pitch = packet.getPitch();
        float headYaw = packet.getHeadYaw();
        if (packet.getType() == EntityType.PLAYER) {
            void var9_11;
            if (packet.getUuid().equals(session.getPlayerEntity().getUuid())) {
                PlayerEntity playerEntity = new PlayerEntity(session, packet.getEntityId(), session.getEntityCache().getNextEntityId().incrementAndGet(), session.getPlayerEntity().getUuid(), position, motion, yaw, pitch, headYaw, session.getPlayerEntity().getUsername(), session.getPlayerEntity().getTexturesProperty());
            } else {
                PlayerEntity playerEntity = session.getEntityCache().getPlayerEntity(packet.getUuid());
                if (playerEntity == null) {
                    GeyserImpl.getInstance().getLogger().error(GeyserLocale.getLocaleStringLog("geyser.entity.player.failed_list", packet.getUuid()));
                    return;
                }
                playerEntity.setEntityId(packet.getEntityId());
                playerEntity.setPosition(position);
                playerEntity.setYaw(yaw);
                playerEntity.setPitch(pitch);
                playerEntity.setHeadYaw(headYaw);
                playerEntity.setMotion(motion);
            }
            var9_11.sendPlayer();
            if (EnvironmentUtils.IS_UNIT_TESTING) return;
            SkinManager.requestAndHandleSkinAndCape((PlayerEntity)var9_11, session, null);
            return;
        }
        if (packet.getType() == EntityType.FALLING_BLOCK) {
            FallingBlockEntity fallingBlockEntity = new FallingBlockEntity(session, packet.getEntityId(), session.getEntityCache().getNextEntityId().incrementAndGet(), packet.getUuid(), position, motion, yaw, pitch, headYaw, ((FallingBlockData)packet.getData()).getId());
        } else if (packet.getType() == EntityType.FISHING_BOBBER) {
            int ownerEntityId = ((ProjectileData)packet.getData()).getOwnerId();
            Entity owner = session.getEntityCache().getEntityByJavaId(ownerEntityId);
            if (!(owner instanceof PlayerEntity)) return;
            FishingHookEntity fishingHookEntity = new FishingHookEntity(session, packet.getEntityId(), session.getEntityCache().getNextEntityId().incrementAndGet(), packet.getUuid(), position, motion, yaw, pitch, headYaw, (PlayerEntity)owner);
        } else {
            Object t = definition.factory().create(session, packet.getEntityId(), session.getEntityCache().getNextEntityId().incrementAndGet(), packet.getUuid(), definition, position, motion, yaw, pitch, headYaw);
            if (t instanceof HangingEntity) {
                HangingEntity hanging = (HangingEntity)t;
                hanging.setDirection((Direction)packet.getData());
            }
        }
        if (packet.getType() == EntityType.WARDEN && (wardenData = (WardenData)packet.getData()).isEmerging()) {
            var9_15.setPose(Pose.EMERGING);
        }
        session.getEntityCache().spawnEntity((Entity)var9_15);
    }
}

