/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.bedrock.data.biome;

import java.util.List;

public final class BiomeReplacementData {
    private final int biome;
    private final int dimension;
    private final List<Short> targetBiomes;
    private final float amount;
    private final float noiseFrequencyScale;
    private final int replacementIndex;

    public BiomeReplacementData(int biome, int dimension, List<Short> targetBiomes, float amount, float noiseFrequencyScale, int replacementIndex) {
        this.biome = biome;
        this.dimension = dimension;
        this.targetBiomes = targetBiomes;
        this.amount = amount;
        this.noiseFrequencyScale = noiseFrequencyScale;
        this.replacementIndex = replacementIndex;
    }

    public int getBiome() {
        return this.biome;
    }

    public int getDimension() {
        return this.dimension;
    }

    public List<Short> getTargetBiomes() {
        return this.targetBiomes;
    }

    public float getAmount() {
        return this.amount;
    }

    public float getNoiseFrequencyScale() {
        return this.noiseFrequencyScale;
    }

    public int getReplacementIndex() {
        return this.replacementIndex;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BiomeReplacementData)) {
            return false;
        }
        BiomeReplacementData other = (BiomeReplacementData)o;
        if (this.getBiome() != other.getBiome()) {
            return false;
        }
        if (this.getDimension() != other.getDimension()) {
            return false;
        }
        if (Float.compare(this.getAmount(), other.getAmount()) != 0) {
            return false;
        }
        if (Float.compare(this.getNoiseFrequencyScale(), other.getNoiseFrequencyScale()) != 0) {
            return false;
        }
        if (this.getReplacementIndex() != other.getReplacementIndex()) {
            return false;
        }
        List<Short> this$targetBiomes = this.getTargetBiomes();
        List<Short> other$targetBiomes = other.getTargetBiomes();
        return !(this$targetBiomes == null ? other$targetBiomes != null : !((Object)this$targetBiomes).equals(other$targetBiomes));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBiome();
        result = result * 59 + this.getDimension();
        result = result * 59 + Float.floatToIntBits(this.getAmount());
        result = result * 59 + Float.floatToIntBits(this.getNoiseFrequencyScale());
        result = result * 59 + this.getReplacementIndex();
        List<Short> $targetBiomes = this.getTargetBiomes();
        result = result * 59 + ($targetBiomes == null ? 43 : ((Object)$targetBiomes).hashCode());
        return result;
    }

    public String toString() {
        return "BiomeReplacementData(biome=" + this.getBiome() + ", dimension=" + this.getDimension() + ", targetBiomes=" + this.getTargetBiomes() + ", amount=" + this.getAmount() + ", noiseFrequencyScale=" + this.getNoiseFrequencyScale() + ", replacementIndex=" + this.getReplacementIndex() + ")";
    }
}

