/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.extension;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.api.util.ApiVersion;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.api.GeyserApi;
import org.geysermc.geyser.api.event.ExtensionEventBus;
import org.geysermc.geyser.api.extension.Extension;
import org.geysermc.geyser.api.extension.ExtensionDescription;
import org.geysermc.geyser.api.extension.ExtensionLoader;
import org.geysermc.geyser.api.extension.ExtensionLogger;
import org.geysermc.geyser.api.extension.ExtensionManager;
import org.geysermc.geyser.api.extension.exception.InvalidDescriptionException;
import org.geysermc.geyser.api.extension.exception.InvalidExtensionException;
import org.geysermc.geyser.extension.GeyserExtensionClassLoader;
import org.geysermc.geyser.extension.GeyserExtensionContainer;
import org.geysermc.geyser.extension.GeyserExtensionDescription;
import org.geysermc.geyser.extension.GeyserExtensionLogger;
import org.geysermc.geyser.extension.event.GeyserExtensionEventBus;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.util.ThrowingBiConsumer;

public class GeyserExtensionLoader
extends ExtensionLoader {
    private static final Pattern[] EXTENSION_FILTERS = new Pattern[]{Pattern.compile("^.+\\.jar$")};
    private final Object2ObjectMap<String, Class<?>> classes = new Object2ObjectOpenHashMap();
    private final Map<String, GeyserExtensionClassLoader> classLoaders = new HashMap<String, GeyserExtensionClassLoader>();
    private final Map<Extension, GeyserExtensionContainer> extensionContainers = new HashMap<Extension, GeyserExtensionContainer>();
    private final Path extensionsDirectory = GeyserImpl.getInstance().getBootstrap().getConfigFolder().resolve("extensions");

    public GeyserExtensionContainer loadExtension(Path path, GeyserExtensionDescription description) throws Throwable {
        GeyserExtensionClassLoader loader;
        if (path == null) {
            throw new InvalidExtensionException("Path is null");
        }
        if (Files.notExists(path, new LinkOption[0])) {
            throw new InvalidExtensionException(String.valueOf(new NoSuchFileException(path.toString())) + " does not exist");
        }
        Path parentFile = path.getParent();
        Path oldDataFolder = parentFile.resolve(description.name());
        Path dataFolder = parentFile.resolve(description.id());
        if (Files.exists(oldDataFolder, new LinkOption[0]) && Files.isDirectory(oldDataFolder, new LinkOption[0]) && !oldDataFolder.equals(dataFolder)) {
            try {
                Files.move(oldDataFolder, dataFolder, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new InvalidExtensionException("Failed to move data folder for extension " + description.name(), e);
            }
        }
        if (Files.exists(dataFolder, new LinkOption[0]) && !Files.isDirectory(dataFolder, new LinkOption[0])) {
            throw new InvalidExtensionException("The folder " + String.valueOf(dataFolder) + " is not a directory and is the data folder for the extension " + description.name() + "!");
        }
        try {
            loader = new GeyserExtensionClassLoader(this, this.getClass().getClassLoader(), path, description);
        }
        catch (Throwable e) {
            throw new InvalidExtensionException(e);
        }
        this.classLoaders.put(description.id(), loader);
        try {
            Extension extension = loader.load();
            return this.setup(extension, description, dataFolder, new GeyserExtensionEventBus(GeyserImpl.getInstance().eventBus(), extension));
        }
        catch (Throwable e) {
            this.classLoaders.remove(description.id()).close();
            throw e;
        }
    }

    private GeyserExtensionContainer setup(Extension extension, GeyserExtensionDescription description, Path dataFolder, ExtensionEventBus eventBus) {
        GeyserExtensionLogger logger = new GeyserExtensionLogger(GeyserImpl.getInstance().getLogger(), description.id());
        return new GeyserExtensionContainer(extension, dataFolder, description, this, logger, eventBus);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public GeyserExtensionDescription extensionDescription(Path path) throws InvalidDescriptionException {
        HashMap environment = new HashMap();
        try (FileSystem fileSystem = FileSystems.newFileSystem(path, environment, null);){
            GeyserExtensionDescription geyserExtensionDescription;
            block14: {
                Path extensionYml = fileSystem.getPath("extension.yml", new String[0]);
                BufferedReader reader = Files.newBufferedReader(extensionYml);
                try {
                    geyserExtensionDescription = GeyserExtensionDescription.fromYaml(reader);
                    if (reader == null) break block14;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ((Reader)reader).close();
            }
            return geyserExtensionDescription;
        }
        catch (IOException ex) {
            throw new InvalidDescriptionException("Failed to load extension description for " + String.valueOf(path), ex);
        }
    }

    public Pattern[] extensionFilters() {
        return EXTENSION_FILTERS;
    }

    public Class<?> classByName(String name) throws ClassNotFoundException {
        GeyserExtensionClassLoader loader;
        Class<?> clazz = (Class<?>)this.classes.get(name);
        if (clazz != null) {
            return clazz;
        }
        Iterator<GeyserExtensionClassLoader> iterator = this.classLoaders.values().iterator();
        while (iterator.hasNext() && (clazz = (loader = iterator.next()).findClass(name, false)) == null) {
        }
        return clazz;
    }

    void setClass(String name, Class<?> clazz) {
        this.classes.putIfAbsent(name, clazz);
    }

    @Override
    protected void loadAllExtensions(@NonNull ExtensionManager extensionManager) {
        GeyserLogger logger = GeyserImpl.getInstance().getLogger();
        try {
            if (Files.notExists(this.extensionsDirectory, new LinkOption[0])) {
                Files.createDirectory(this.extensionsDirectory, new FileAttribute[0]);
            }
            LinkedHashMap extensions = new LinkedHashMap();
            LinkedHashMap loadedExtensions = new LinkedHashMap();
            Path updateDirectory = this.extensionsDirectory.resolve("update");
            if (Files.isDirectory(updateDirectory, new LinkOption[0])) {
                HashMap extensionFiles = new HashMap();
                this.processExtensionsFolder(this.extensionsDirectory, (path, description) -> extensionFiles.computeIfAbsent(description.id(), k -> new ArrayList()).add(path), (path, e) -> {});
                this.processExtensionsFolder(updateDirectory, (path, description) -> {
                    List oldExtensionFiles = (List)extensionFiles.get(description.id());
                    if (oldExtensionFiles != null) {
                        for (Path oldExtensionFile : oldExtensionFiles) {
                            Files.delete(oldExtensionFile);
                        }
                    }
                    Files.move(path, this.extensionsDirectory.resolve(path.getFileName()), StandardCopyOption.REPLACE_EXISTING);
                }, (path, e) -> logger.error(GeyserLocale.getLocaleStringLog("geyser.extensions.update.failed", path.getFileName()), (Throwable)e));
            }
            this.processExtensionsFolder(this.extensionsDirectory, (path, description) -> {
                String name = description.name();
                String id = description.id();
                if (extensions.containsKey(id) || extensionManager.extension(id) != null) {
                    logger.warning(GeyserLocale.getLocaleStringLog("geyser.extensions.load.duplicate", name, path.toString()));
                    return;
                }
                ApiVersion.Compatibility compatibility = GeyserApi.api().geyserApiVersion().supportsRequestedVersion(description.humanApiVersion(), description.majorApiVersion(), description.minorApiVersion());
                if (compatibility != ApiVersion.Compatibility.COMPATIBLE) {
                    if (compatibility == ApiVersion.Compatibility.HUMAN_DIFFER && description.humanApiVersion() == 1) {
                        logger.warning("The extension %s requested the Base API version %s, which is deprecated in favor of specifying the Geyser API version. Please update the extension, or contact its developer.".formatted(name, description.apiVersion()));
                    } else {
                        logger.error(GeyserLocale.getLocaleStringLog("geyser.extensions.load.failed_api_version", name, description.apiVersion()));
                        return;
                    }
                }
                GeyserExtensionContainer container = this.loadExtension((Path)path, (GeyserExtensionDescription)description);
                extensions.put(id, path);
                loadedExtensions.put(id, container);
            }, (path, e) -> logger.error(GeyserLocale.getLocaleStringLog("geyser.extensions.load.failed_with_name", path.getFileName(), path.toAbsolutePath()), (Throwable)e));
            for (GeyserExtensionContainer container : loadedExtensions.values()) {
                this.extensionContainers.put(container.extension(), container);
                this.register(container.extension(), extensionManager);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void processExtensionsFolder(Path directory, ThrowingBiConsumer<Path, GeyserExtensionDescription> accept, BiConsumer<Path, Throwable> reject) throws IOException {
        List<Path> extensionPaths = Files.list(directory).toList();
        Pattern[] extensionFilters = this.extensionFilters();
        extensionPaths.forEach(path -> {
            if (Files.isDirectory(path, new LinkOption[0])) {
                return;
            }
            for (Pattern filter : extensionFilters) {
                if (filter.matcher(path.getFileName().toString()).matches()) continue;
                return;
            }
            try {
                GeyserExtensionDescription description = this.extensionDescription((Path)path);
                accept.acceptThrows((Path)path, description);
            }
            catch (Throwable e) {
                reject.accept((Path)path, e);
            }
        });
    }

    @Override
    protected boolean isEnabled(@NonNull Extension extension) {
        return this.extensionContainers.get((Object)extension).enabled;
    }

    @Override
    protected void setEnabled(@NonNull Extension extension, boolean enabled) {
        this.extensionContainers.get((Object)extension).enabled = enabled;
    }

    @Override
    protected @NonNull Path dataFolder(@NonNull Extension extension) {
        return this.extensionContainers.get(extension).dataFolder();
    }

    @Override
    protected @NonNull ExtensionDescription description(@NonNull Extension extension) {
        return this.extensionContainers.get(extension).description();
    }

    @Override
    protected @NonNull ExtensionEventBus eventBus(@NonNull Extension extension) {
        return this.extensionContainers.get(extension).eventBus();
    }

    @Override
    protected @NonNull ExtensionLogger logger(@NonNull Extension extension) {
        return this.extensionContainers.get(extension).logger();
    }
}

