/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.PotionMixData;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.recipe.MultiRecipeData;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.recipe.RecipeData;
import org.cloudburstmc.protocol.bedrock.packet.CraftingDataPacket;
import org.cloudburstmc.protocol.bedrock.packet.PlayerListPacket;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.InventoryUtils;
import org.geysermc.geyser.util.PlayerListUtils;
import org.geysermc.mcprotocollib.protocol.packet.configuration.clientbound.ClientboundFinishConfigurationPacket;

@Translator(packet=ClientboundFinishConfigurationPacket.class)
public class JavaFinishConfigurationTranslator
extends PacketTranslator<ClientboundFinishConfigurationPacket> {
    private static final List<RecipeData> CARTOGRAPHY_RECIPES;

    @Override
    public void translate(GeyserSession session, ClientboundFinishConfigurationPacket packet) {
        ArrayList<PlayerListPacket.Entry> entries = new ArrayList<PlayerListPacket.Entry>();
        for (PlayerEntity otherEntity : session.getEntityCache().getAllPlayerEntities()) {
            entries.add(new PlayerListPacket.Entry(otherEntity.getTabListUuid()));
        }
        PlayerListUtils.batchSendPlayerList(session, entries, PlayerListPacket.Action.REMOVE);
        session.getEntityCache().removeAllPlayerEntities();
        CraftingDataPacket craftingDataPacket = new CraftingDataPacket();
        craftingDataPacket.setCleanRecipes(true);
        craftingDataPacket.getCraftingData().addAll(CARTOGRAPHY_RECIPES);
        craftingDataPacket.getPotionMixData().addAll((Collection<PotionMixData>)Registries.POTION_MIXES.forVersion(session.getUpstream().getProtocolVersion()));
        if (session.isSentSpawnPacket()) {
            session.getUpstream().sendPacket(craftingDataPacket);
            if (session.getStonecutterRecipes() != null) {
                session.getCraftingRecipes().clear();
                session.getJavaToBedrockRecipeIds().clear();
                session.getSmithingRecipes().clear();
                session.getStonecutterRecipes().clear();
            }
        } else {
            session.getUpstream().queuePostStartGamePacket(craftingDataPacket);
        }
        session.getWorldCache().resetScoreboard();
    }

    static {
        int n = InventoryUtils.LAST_RECIPE_NET_ID + 1;
        InventoryUtils.LAST_RECIPE_NET_ID = n;
        int n2 = InventoryUtils.LAST_RECIPE_NET_ID + 1;
        InventoryUtils.LAST_RECIPE_NET_ID = n2;
        InventoryUtils.LAST_RECIPE_NET_ID = InventoryUtils.LAST_RECIPE_NET_ID + 1;
        CARTOGRAPHY_RECIPES = List.of(MultiRecipeData.of(UUID.fromString("8b36268c-1829-483c-a0f1-993b7156a8f2"), n), MultiRecipeData.of(UUID.fromString("442d85ed-8272-4543-a6f1-418f90ded05d"), n2), MultiRecipeData.of(UUID.fromString("98c84b38-1085-46bd-b1ce-dd38c159e6cc"), InventoryUtils.LAST_RECIPE_NET_ID), MultiRecipeData.of(UUID.fromString("602234e4-cac1-4353-8bb7-b1ebff70024b"), ++InventoryUtils.LAST_RECIPE_NET_ID));
    }
}

