/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache;

import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.CooldownUtils;

public class PreferencesCache {
    private final GeyserSession session;
    private boolean prefersShowCoordinates = true;
    private boolean allowShowCoordinates;
    private boolean prefersCustomSkulls;
    private CooldownUtils.CooldownType cooldownPreference = CooldownUtils.getDefaultShowCooldown();

    public PreferencesCache(GeyserSession session) {
        this.session = session;
        this.prefersCustomSkulls = session.getGeyser().getConfig().isAllowCustomSkulls();
    }

    public void updateShowCoordinates() {
        this.allowShowCoordinates = !this.session.isReducedDebugInfo() && this.session.getGeyser().getConfig().isShowCoordinates();
        this.session.sendGameRule("showcoordinates", this.allowShowCoordinates && this.prefersShowCoordinates);
    }

    public boolean showCustomSkulls() {
        return this.prefersCustomSkulls && this.session.getGeyser().getConfig().isAllowCustomSkulls();
    }

    public GeyserSession getSession() {
        return this.session;
    }

    public boolean isPrefersShowCoordinates() {
        return this.prefersShowCoordinates;
    }

    public boolean isAllowShowCoordinates() {
        return this.allowShowCoordinates;
    }

    public boolean isPrefersCustomSkulls() {
        return this.prefersCustomSkulls;
    }

    public CooldownUtils.CooldownType getCooldownPreference() {
        return this.cooldownPreference;
    }

    public void setPrefersShowCoordinates(boolean prefersShowCoordinates) {
        this.prefersShowCoordinates = prefersShowCoordinates;
    }

    public void setPrefersCustomSkulls(boolean prefersCustomSkulls) {
        this.prefersCustomSkulls = prefersCustomSkulls;
    }

    public void setCooldownPreference(CooldownUtils.CooldownType cooldownPreference) {
        this.cooldownPreference = cooldownPreference;
    }
}

