/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.loader;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.registry.loader.RegistryLoader;

public class BiomeIdentifierRegistryLoader
implements RegistryLoader<String, Object2IntMap<String>> {
    @Override
    public Object2IntMap<String> load(String input) {
        Map biomeEntries;
        TypeReference<Map<String, BiomeEntry>> biomeEntriesType = new TypeReference<Map<String, BiomeEntry>>(){};
        try (InputStream stream = GeyserImpl.getInstance().getBootstrap().getResourceOrThrow("mappings/biomes.json");){
            biomeEntries = (Map)GeyserImpl.JSON_MAPPER.readValue(stream, (TypeReference)biomeEntriesType);
        }
        catch (IOException e) {
            throw new AssertionError("Unable to load Bedrock runtime biomes", e);
        }
        Object2IntOpenHashMap biomes = new Object2IntOpenHashMap();
        for (Map.Entry biome : biomeEntries.entrySet()) {
            biomes.put((Object)((String)biome.getKey()), ((BiomeEntry)biome.getValue()).bedrockId);
        }
        return biomes;
    }

    private static class BiomeEntry {
        @JsonProperty(value="bedrock_id")
        private int bedrockId;

        private BiomeEntry() {
        }
    }
}

