/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.scoreboard.Scoreboard;
import org.geysermc.geyser.scoreboard.ScoreboardUpdater;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.SetTitlePacket;
import org.geysermc.geyser.util.ChunkUtils;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.UseCooldown;
import org.geysermc.mcprotocollib.protocol.data.game.setting.Difficulty;

public final class WorldCache {
    private final GeyserSession session;
    private final ScoreboardUpdater.ScoreboardSession scoreboardSession;
    private @NonNull Scoreboard scoreboard;
    private Difficulty difficulty = Difficulty.EASY;
    private boolean titleTimesNeedReset = false;
    private int trueTitleFadeInTime;
    private int trueTitleStayTime;
    private int trueTitleFadeOutTime;
    private int currentSequence;
    private final Object2IntMap<Vector3i> unverifiedPredictions = new Object2IntOpenHashMap(1);
    private final Map<Vector3i, String> activeRecords = new Object2ObjectOpenHashMap(1);
    private boolean editingSignOnFront;
    private final Object2IntMap<String> activeCooldowns = new Object2IntOpenHashMap(2);

    public WorldCache(GeyserSession session) {
        this.session = session;
        this.scoreboard = new Scoreboard(session);
        this.scoreboardSession = new ScoreboardUpdater.ScoreboardSession(session);
        this.resetTitleTimes(false);
    }

    public void resetScoreboard() {
        this.scoreboard.removeScoreboard();
        this.scoreboard = new Scoreboard(this.session);
    }

    public int increaseAndGetScoreboardPacketsPerSecond() {
        int pendingPps = this.scoreboardSession.getPendingPacketsPerSecond().incrementAndGet();
        int pps = this.scoreboardSession.getPacketsPerSecond();
        return Math.max(pps, pendingPps);
    }

    public void markTitleTimesAsIncorrect() {
        this.titleTimesNeedReset = true;
    }

    public void setTitleTimes(int fadeInTime, int stayTime, int fadeOutTime) {
        this.trueTitleFadeInTime = fadeInTime;
        this.trueTitleStayTime = stayTime;
        this.trueTitleFadeOutTime = fadeOutTime;
        this.titleTimesNeedReset = false;
    }

    public void synchronizeCorrectTitleTimes() {
        if (this.titleTimesNeedReset) {
            this.forceSyncCorrectTitleTimes();
        }
    }

    private void forceSyncCorrectTitleTimes() {
        SetTitlePacket titlePacket = new SetTitlePacket();
        titlePacket.setType(SetTitlePacket.Type.TIMES);
        titlePacket.setText("");
        int tickrateMultiplier = Math.round(this.session.getMillisecondsPerTick()) / 50;
        titlePacket.setFadeInTime(this.trueTitleFadeInTime * tickrateMultiplier);
        titlePacket.setStayTime(this.trueTitleStayTime * tickrateMultiplier);
        titlePacket.setFadeOutTime(this.trueTitleFadeOutTime * tickrateMultiplier);
        titlePacket.setPlatformOnlineId("");
        titlePacket.setXuid("");
        this.session.sendUpstreamPacket(titlePacket);
        this.titleTimesNeedReset = false;
    }

    public void resetTitleTimes(boolean clientSync) {
        this.trueTitleFadeInTime = 10;
        this.trueTitleStayTime = 70;
        this.trueTitleFadeOutTime = 20;
        if (clientSync) {
            this.forceSyncCorrectTitleTimes();
        }
    }

    public int nextPredictionSequence() {
        return ++this.currentSequence;
    }

    public void markPositionInSequence(Vector3i position) {
        if (this.session.isEmulatePost1_18Logic()) {
            this.unverifiedPredictions.put((Object)position, this.currentSequence);
        }
    }

    public void updateServerCorrectBlockState(Vector3i position, int blockState) {
        Vector3i clientBreakPos;
        if (!this.unverifiedPredictions.isEmpty()) {
            this.unverifiedPredictions.removeInt((Object)position);
        }
        if ((clientBreakPos = this.session.getBlockBreakHandler().getCurrentBlockPos()) != null && Objects.equals(clientBreakPos, position)) {
            this.session.getBlockBreakHandler().setUpdatedServerBlockStateId(blockState);
        }
        ChunkUtils.updateBlock(this.session, blockState, position);
    }

    public void endPredictionsUpTo(int sequence) {
        if (this.unverifiedPredictions.isEmpty()) {
            return;
        }
        ObjectIterator it = Object2IntMaps.fastIterator(this.unverifiedPredictions);
        while (it.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)it.next();
            if (entry.getIntValue() > sequence) continue;
            Vector3i position = (Vector3i)entry.getKey();
            ChunkUtils.updateBlockClientSide(this.session, this.session.getGeyser().getWorldManager().blockAt(this.session, position), position);
            it.remove();
        }
    }

    public void addActiveRecord(Vector3i pos, String bedrockPlaySound) {
        this.activeRecords.put(pos, bedrockPlaySound);
    }

    public @Nullable String removeActiveRecord(Vector3i pos) {
        return this.activeRecords.remove(pos);
    }

    public void setCooldown(Key cooldownGroup, int ticks) {
        if (ticks == 0) {
            this.activeCooldowns.removeInt((Object)cooldownGroup.asString());
            return;
        }
        this.activeCooldowns.put((Object)cooldownGroup.asString(), this.session.getTicks() + ticks);
    }

    public boolean hasCooldown(GeyserItemStack item) {
        UseCooldown cooldown = item.getComponent(DataComponentTypes.USE_COOLDOWN);
        String cooldownGroup = cooldown != null && cooldown.cooldownGroup() != null ? cooldown.cooldownGroup().asString() : item.asItem().javaIdentifier();
        return this.activeCooldowns.containsKey((Object)cooldownGroup);
    }

    public void tick() {
        if (!this.activeCooldowns.isEmpty()) {
            int ticks = this.session.getTicks();
            ObjectIterator it = Object2IntMaps.fastIterator(this.activeCooldowns);
            while (it.hasNext()) {
                Object2IntMap.Entry entry = (Object2IntMap.Entry)it.next();
                if (entry.getIntValue() > ticks) continue;
                it.remove();
            }
        }
    }

    public ScoreboardUpdater.ScoreboardSession getScoreboardSession() {
        return this.scoreboardSession;
    }

    public @NonNull Scoreboard getScoreboard() {
        return this.scoreboard;
    }

    public Difficulty getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(Difficulty difficulty) {
        this.difficulty = difficulty;
    }

    public boolean isEditingSignOnFront() {
        return this.editingSignOnFront;
    }

    public void setEditingSignOnFront(boolean editingSignOnFront) {
        this.editingSignOnFront = editingSignOnFront;
    }
}

