/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.v291;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NBTInputStream;
import org.cloudburstmc.nbt.NBTOutputStream;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtUtils;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.BaseBedrockCodecHelper;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.BedrockCodecHelper;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.EntityDataTypeMap;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.GameRuleData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.command.CommandEnumConstraint;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.command.CommandEnumData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.command.CommandOriginData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.command.CommandOriginType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.definitions.ItemDefinition;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityDataFormat;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityDataMap;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityDataType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityLinkData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.transformer.EntityDataTransformer;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.util.Preconditions;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.util.TriConsumer;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.util.TypeMap;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.util.VarInts;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.util.stream.LittleEndianByteBufOutputStream;

public class BedrockCodecHelper_v291
extends BaseBedrockCodecHelper {
    public BedrockCodecHelper_v291(EntityDataTypeMap entityData, TypeMap<Class<?>> gameRulesTypes) {
        super(entityData, gameRulesTypes);
    }

    @Override
    public EntityLinkData readEntityLink(ByteBuf buffer) {
        long from = VarInts.readLong(buffer);
        long to = VarInts.readLong(buffer);
        short type = buffer.readUnsignedByte();
        boolean immediate = buffer.readBoolean();
        return new EntityLinkData(from, to, EntityLinkData.Type.values()[type], immediate);
    }

    @Override
    public void writeEntityLink(ByteBuf buffer, EntityLinkData entityLink) {
        Preconditions.checkNotNull(entityLink, "entityLink");
        VarInts.writeLong(buffer, entityLink.getFrom());
        VarInts.writeLong(buffer, entityLink.getTo());
        buffer.writeByte(entityLink.getType().ordinal());
        buffer.writeBoolean(entityLink.isImmediate());
    }

    @Override
    public ItemData readNetItem(ByteBuf buffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeNetItem(ByteBuf buffer, ItemData item) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ItemData readItem(ByteBuf buffer) {
        int runtimeId = VarInts.readInt(buffer);
        if (runtimeId == 0) {
            return ItemData.AIR;
        }
        ItemDefinition definition = (ItemDefinition)this.itemDefinitions.getDefinition(runtimeId);
        int aux = VarInts.readInt(buffer);
        int damage = aux >> 8;
        if (damage == Short.MAX_VALUE) {
            damage = -1;
        }
        int count = aux & 0xFF;
        short nbtSize = buffer.readShortLE();
        NbtMap compoundTag = null;
        if (nbtSize > 0) {
            try (NBTInputStream reader = NbtUtils.createReaderLE((InputStream)new ByteBufInputStream(buffer.readSlice((int)nbtSize)), (long)this.encodingSettings.maxItemNBTSize());){
                Object tag = reader.readTag();
                if (tag instanceof NbtMap) {
                    compoundTag = (NbtMap)tag;
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to load NBT data", e);
            }
        }
        String[] canPlace = this.readArray(buffer, new String[0], this::readString);
        String[] canBreak = this.readArray(buffer, new String[0], this::readString);
        return ItemData.builder().definition(definition).damage(damage).count(count).tag(compoundTag).canPlace(canPlace).canBreak(canBreak).build();
    }

    @Override
    public void writeItem(ByteBuf buffer, ItemData item) {
        Preconditions.checkNotNull(item, "item");
        ItemDefinition definition = item.getDefinition();
        if (BedrockCodecHelper_v291.isAir(definition)) {
            buffer.writeByte(0);
            return;
        }
        VarInts.writeInt(buffer, definition.getRuntimeId());
        int damage = item.getDamage();
        if (damage == -1) {
            damage = Short.MAX_VALUE;
        }
        VarInts.writeInt(buffer, damage << 8 | item.getCount() & 0xFF);
        int sizeIndex = buffer.writerIndex();
        buffer.writeShortLE(0);
        if (item.getTag() != null) {
            int afterSizeIndex = buffer.writerIndex();
            try (NBTOutputStream stream = new NBTOutputStream((DataOutput)((Object)new LittleEndianByteBufOutputStream(buffer)));){
                stream.writeTag((Object)item.getTag());
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to save NBT data", e);
            }
            buffer.setShortLE(sizeIndex, buffer.writerIndex() - afterSizeIndex);
        }
        this.writeArray(buffer, item.getCanPlace(), this::writeString);
        this.writeArray(buffer, item.getCanBreak(), this::writeString);
    }

    @Override
    public ItemData readItemInstance(ByteBuf buffer) {
        return this.readItem(buffer);
    }

    @Override
    public void writeItemInstance(ByteBuf buffer, ItemData item) {
        this.writeItem(buffer, item);
    }

    @Override
    public CommandOriginData readCommandOrigin(ByteBuf buffer) {
        CommandOriginType origin = CommandOriginType.values()[VarInts.readUnsignedInt(buffer)];
        UUID uuid = this.readUuid(buffer);
        String requestId = this.readString(buffer);
        long varLong = -1L;
        if (origin == CommandOriginType.DEV_CONSOLE || origin == CommandOriginType.TEST) {
            varLong = VarInts.readLong(buffer);
        }
        return new CommandOriginData(origin, uuid, requestId, varLong);
    }

    @Override
    public void writeCommandOrigin(ByteBuf buffer, CommandOriginData originData) {
        Preconditions.checkNotNull(originData, "commandOriginData");
        VarInts.writeUnsignedInt(buffer, originData.getOrigin().ordinal());
        this.writeUuid(buffer, originData.getUuid());
        this.writeString(buffer, originData.getRequestId());
        if (originData.getOrigin() == CommandOriginType.DEV_CONSOLE || originData.getOrigin() == CommandOriginType.TEST) {
            VarInts.writeLong(buffer, originData.getEvent());
        }
    }

    @Override
    public GameRuleData<?> readGameRule(ByteBuf buffer) {
        String name = this.readString(buffer);
        int type = VarInts.readUnsignedInt(buffer);
        switch (type) {
            case 1: {
                return new GameRuleData<Boolean>(name, buffer.readBoolean());
            }
            case 2: {
                return new GameRuleData<Integer>(name, VarInts.readUnsignedInt(buffer));
            }
            case 3: {
                return new GameRuleData<Float>(name, Float.valueOf(buffer.readFloatLE()));
            }
        }
        throw new IllegalStateException("Invalid gamerule type received");
    }

    @Override
    public void writeGameRule(ByteBuf buffer, GameRuleData<?> gameRule) {
        Preconditions.checkNotNull(gameRule, "gameRule");
        Object value = gameRule.getValue();
        int type = this.gameRuleType.getId(value.getClass());
        this.writeString(buffer, gameRule.getName());
        VarInts.writeUnsignedInt(buffer, type);
        switch (type) {
            case 1: {
                buffer.writeBoolean(((Boolean)value).booleanValue());
                break;
            }
            case 2: {
                VarInts.writeUnsignedInt(buffer, (Integer)value);
                break;
            }
            case 3: {
                buffer.writeFloatLE(((Float)value).floatValue());
            }
        }
    }

    @Override
    public GameRuleData<?> readGameRuleInStartGame(ByteBuf buffer) {
        return this.readGameRule(buffer);
    }

    @Override
    public void writeGameRuleInStartGame(ByteBuf buffer, GameRuleData<?> gameRule) {
        this.writeGameRule(buffer, gameRule);
    }

    @Override
    public void readEntityData(ByteBuf buffer, EntityDataMap entityDataMap) {
        Preconditions.checkNotNull(entityDataMap, "entityDataDictionary");
        int length = VarInts.readUnsignedInt(buffer);
        Preconditions.checkArgument(this.encodingSettings.maxListSize() <= 0 || length <= this.encodingSettings.maxListSize(), "Entity data size is too big: %s", length);
        for (int i = 0; i < length; ++i) {
            Object value;
            int id = VarInts.readUnsignedInt(buffer);
            EntityDataFormat format = EntityDataFormat.values()[VarInts.readUnsignedInt(buffer)];
            switch (format) {
                case BYTE: {
                    value = buffer.readByte();
                    break;
                }
                case SHORT: {
                    value = buffer.readShortLE();
                    break;
                }
                case INT: {
                    value = VarInts.readInt(buffer);
                    break;
                }
                case FLOAT: {
                    value = Float.valueOf(buffer.readFloatLE());
                    break;
                }
                case STRING: {
                    value = this.readString(buffer);
                    break;
                }
                case NBT: {
                    value = this.readItem(buffer).getTag();
                    break;
                }
                case VECTOR3I: {
                    value = this.readVector3i(buffer);
                    break;
                }
                case LONG: {
                    value = VarInts.readLong(buffer);
                    break;
                }
                case VECTOR3F: {
                    value = this.readVector3f(buffer);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown entity data type received");
                }
            }
            EntityDataTypeMap.Definition<?>[] definitions = this.entityData.fromId(id, format);
            if (definitions != null) {
                for (EntityDataTypeMap.Definition<?> definition : definitions) {
                    EntityDataTransformer<?, ?> transformer = definition.getTransformer();
                    Object transformedValue = transformer.deserialize(this, entityDataMap, value);
                    if (transformedValue == null) continue;
                    entityDataMap.put(definition.getType(), transformer.deserialize(this, entityDataMap, value));
                }
                continue;
            }
            log.debug("Unknown entity data: {} type {} value {}", new Object[]{id, format, value});
        }
    }

    @Override
    public void writeEntityData(ByteBuf buffer, EntityDataMap entityDataMap) {
        Preconditions.checkNotNull(entityDataMap, "entityDataDictionary");
        VarInts.writeUnsignedInt(buffer, entityDataMap.size());
        for (Map.Entry<EntityDataType<?>, Object> entry : entityDataMap.entrySet()) {
            EntityDataTypeMap.Definition<?> definition = this.entityData.fromType(entry.getKey());
            VarInts.writeUnsignedInt(buffer, definition.getId());
            VarInts.writeUnsignedInt(buffer, definition.getFormat().ordinal());
            try {
                Object value = definition.getTransformer().serialize(this, entityDataMap, entry.getValue());
                switch (definition.getFormat()) {
                    case BYTE: {
                        buffer.writeByte((int)((Byte)value).byteValue());
                        break;
                    }
                    case SHORT: {
                        buffer.writeShortLE((int)((Short)value).shortValue());
                        break;
                    }
                    case INT: {
                        VarInts.writeInt(buffer, (Integer)value);
                        break;
                    }
                    case FLOAT: {
                        buffer.writeFloatLE(((Float)value).floatValue());
                        break;
                    }
                    case STRING: {
                        this.writeString(buffer, (String)value);
                        break;
                    }
                    case NBT: {
                        this.writeItem(buffer, ItemData.builder().definition(ItemDefinition.LEGACY_FIREWORK).damage(0).count(1).tag((NbtMap)value).build());
                        break;
                    }
                    case VECTOR3I: {
                        this.writeVector3i(buffer, (Vector3i)value);
                        break;
                    }
                    case LONG: {
                        VarInts.writeLong(buffer, (Long)value);
                        break;
                    }
                    case VECTOR3F: {
                        this.writeVector3f(buffer, (Vector3f)value);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown entity data type " + (Object)((Object)definition.getFormat()));
                    }
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to encode EntityData " + definition.getId() + " of " + definition.getType().getTypeName(), e);
            }
        }
    }

    @Override
    public CommandEnumData readCommandEnum(ByteBuf buffer, boolean soft) {
        String name = this.readString(buffer);
        int count = VarInts.readUnsignedInt(buffer);
        LinkedHashMap<String, Set<CommandEnumConstraint>> values = new LinkedHashMap<String, Set<CommandEnumConstraint>>();
        for (int i = 0; i < count; ++i) {
            values.put(this.readString(buffer), Collections.emptySet());
        }
        return new CommandEnumData(name, values, soft);
    }

    @Override
    public void writeCommandEnum(ByteBuf buffer, CommandEnumData enumData) {
        Preconditions.checkNotNull(enumData, "enumData");
        this.writeString(buffer, enumData.getName());
        Set<String> values = enumData.getValues().keySet();
        VarInts.writeUnsignedInt(buffer, values.size());
        for (String value : values) {
            this.writeString(buffer, value);
        }
    }

    @Override
    public <O> O readOptional(ByteBuf buffer, O emptyValue, Function<ByteBuf, O> function) {
        if (buffer.readBoolean()) {
            return function.apply(buffer);
        }
        return emptyValue;
    }

    public <O> O readOptional(ByteBuf buffer, O emptyValue, BiFunction<ByteBuf, BedrockCodecHelper, O> function) {
        if (buffer.readBoolean()) {
            return function.apply(buffer, this);
        }
        return emptyValue;
    }

    @Override
    public <T> void writeOptional(ByteBuf buffer, Predicate<T> isPresent, T object, BiConsumer<ByteBuf, T> consumer) {
        Preconditions.checkNotNull(consumer, "read consumer");
        boolean exists = isPresent.test(object);
        buffer.writeBoolean(exists);
        if (exists) {
            consumer.accept(buffer, (ByteBuf)object);
        }
    }

    @Override
    public <T> void writeOptional(ByteBuf buffer, Predicate<T> isPresent, T object, TriConsumer<ByteBuf, BedrockCodecHelper, T> consumer) {
        Preconditions.checkNotNull(consumer, "read consumer");
        boolean exists = isPresent.test(object);
        buffer.writeBoolean(exists);
        if (exists) {
            consumer.accept(buffer, this, (ByteBuf)object);
        }
    }

    @Override
    public <T> void writeOptionalNull(ByteBuf buffer, T object, BiConsumer<ByteBuf, T> consumer) {
        this.writeOptional(buffer, Objects::nonNull, object, consumer);
    }

    @Override
    public <T> void writeOptionalNull(ByteBuf buffer, T object, TriConsumer<ByteBuf, BedrockCodecHelper, T> consumer) {
        this.writeOptional(buffer, Objects::nonNull, object, consumer);
    }
}

