/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.v582.serializer;

import io.netty.buffer.ByteBuf;
import org.cloudburstmc.nbt.NbtMap;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.BedrockCodecHelper;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.BedrockPacketSerializer;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.CompressedBiomeDefinitionListPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.util.VarInts;

public class CompressedBiomeDefinitionListSerializer_v582
implements BedrockPacketSerializer<CompressedBiomeDefinitionListPacket> {
    public static final CompressedBiomeDefinitionListSerializer_v582 INSTANCE = new CompressedBiomeDefinitionListSerializer_v582();
    protected static final byte[] COMPRESSED_INDICATOR = new byte[]{67, 79, 77, 80, 82, 69, 83, 83, 69, 68};

    @Override
    public void serialize(ByteBuf buffer, BedrockCodecHelper helper, CompressedBiomeDefinitionListPacket packet) {
        ByteBuf compressed = buffer.alloc().ioBuffer();
        this.writeCompressed(packet.getDefinitions(), compressed, helper);
        VarInts.writeUnsignedInt(buffer, compressed.readableBytes());
        buffer.writeBytes(compressed);
    }

    @Override
    public void deserialize(ByteBuf buffer, BedrockCodecHelper helper, CompressedBiomeDefinitionListPacket packet) {
        int length = VarInts.readUnsignedInt(buffer);
        packet.setDefinitions(this.readCompressed(buffer.readBytes(length), helper, COMPRESSED_INDICATOR.length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NbtMap readCompressed(ByteBuf buffer, BedrockCodecHelper helper, int length) {
        buffer.skipBytes(length);
        ByteBuf[] dictionary = new ByteBuf[buffer.readUnsignedShortLE()];
        ByteBuf decompressed = buffer.alloc().ioBuffer();
        try {
            for (int index = 0; index < dictionary.length; ++index) {
                dictionary[index] = buffer.readBytes((int)buffer.readUnsignedByte());
            }
            while (buffer.isReadable()) {
                short key = buffer.readUnsignedByte();
                if (key != 255) {
                    decompressed.writeByte((int)key);
                    continue;
                }
                int index = buffer.readUnsignedShortLE();
                if (index >= 0 && index < dictionary.length) {
                    decompressed.writeBytes(dictionary[index].slice());
                    continue;
                }
                decompressed.writeByte((int)key);
            }
            NbtMap nbtMap = helper.readTag(decompressed, NbtMap.class);
            return nbtMap;
        }
        finally {
            decompressed.release();
            for (ByteBuf buf : dictionary) {
                if (buf == null) continue;
                buf.release();
            }
        }
    }

    private void writeCompressed(NbtMap nbtMap, ByteBuf buffer, BedrockCodecHelper helper) {
        buffer.writeBytes(COMPRESSED_INDICATOR);
        buffer.writeShortLE(0);
        ByteBuf serialized = buffer.alloc().ioBuffer();
        helper.writeTag(serialized, nbtMap);
        while (serialized.isReadable()) {
            short key = serialized.readUnsignedByte();
            buffer.writeByte((int)key);
            if (key != 255) continue;
            buffer.writeShortLE(1);
        }
    }

    protected CompressedBiomeDefinitionListSerializer_v582() {
    }
}

