/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.v859.serializer;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.BedrockCodecHelper;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.v844.serializer.BiomeDefinitionListSerializer_v844;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.biome.BiomeCappedSurfaceData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.biome.BiomeClimateData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.biome.BiomeDefinitionChunkGenData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.biome.BiomeLegacyWorldGenRulesData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.biome.BiomeMesaSurfaceData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.biome.BiomeMountainParamsData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.biome.BiomeMultinoiseGenRulesData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.biome.BiomeOverworldGenRulesData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.biome.BiomeReplacementData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.biome.BiomeSurfaceMaterialAdjustmentData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.biome.BiomeSurfaceMaterialData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.util.SequencedHashSet;

public class BiomeDefinitionListSerializer_v859
extends BiomeDefinitionListSerializer_v844 {
    public static final BiomeDefinitionListSerializer_v859 INSTANCE = new BiomeDefinitionListSerializer_v859();

    @Override
    protected void writeDefinitionChunkGen(ByteBuf buffer, BedrockCodecHelper helper, BiomeDefinitionChunkGenData definitionChunkGen, SequencedHashSet<String> strings) {
        super.writeDefinitionChunkGen(buffer, helper, definitionChunkGen, strings);
        helper.writeOptionalNull(buffer, definitionChunkGen.getBiomeReplacementData(), this::writeBiomeReplacementData);
    }

    @Override
    protected BiomeDefinitionChunkGenData readDefinitionChunkGen(ByteBuf buffer, BedrockCodecHelper helper, List<String> strings) {
        BiomeClimateData climate = helper.readOptional(buffer, null, this::readClimate);
        List consolidatedFeatures = helper.readOptional(buffer, null, (buf, aHelper) -> this.readConsolidatedFeatures((ByteBuf)buf, (BedrockCodecHelper)aHelper, strings));
        BiomeMountainParamsData mountainParams = helper.readOptional(buffer, null, this::readMountainParamsData);
        BiomeSurfaceMaterialAdjustmentData surfaceMaterialAdjustment = helper.readOptional(buffer, null, (buf, aHelper) -> this.readSurfaceMaterialAdjustment((ByteBuf)buf, (BedrockCodecHelper)aHelper, strings));
        BiomeSurfaceMaterialData surfaceMaterial = helper.readOptional(buffer, null, this::readSurfaceMaterial);
        boolean hasDefaultOverworldSurface = buffer.readBoolean();
        boolean hasSwampSurface = buffer.readBoolean();
        boolean hasFrozenOceanSurface = buffer.readBoolean();
        boolean hasTheEndSurface = buffer.readBoolean();
        BiomeMesaSurfaceData mesaSurface = helper.readOptional(buffer, null, this::readMesaSurface);
        BiomeCappedSurfaceData cappedSurface = helper.readOptional(buffer, null, this::readCappedSurface);
        BiomeOverworldGenRulesData overworldGenRules = helper.readOptional(buffer, null, (buf, aHelper) -> this.readOverworldGenRules((ByteBuf)buf, (BedrockCodecHelper)aHelper, strings));
        BiomeMultinoiseGenRulesData multinoiseGenRules = helper.readOptional(buffer, null, this::readMultinoiseGenRules);
        BiomeLegacyWorldGenRulesData legacyWorldGenRules = helper.readOptional(buffer, null, (buf, aHelper) -> this.readLegacyWorldGenRules((ByteBuf)buf, (BedrockCodecHelper)aHelper, strings));
        BiomeReplacementData replacementData = helper.readOptional(buffer, null, this::readBiomeReplacementData);
        return new BiomeDefinitionChunkGenData(climate, consolidatedFeatures, mountainParams, surfaceMaterialAdjustment, surfaceMaterial, hasDefaultOverworldSurface, hasSwampSurface, hasFrozenOceanSurface, hasTheEndSurface, mesaSurface, cappedSurface, overworldGenRules, multinoiseGenRules, legacyWorldGenRules, replacementData);
    }

    protected void writeBiomeReplacementData(ByteBuf buffer, BedrockCodecHelper helper, BiomeReplacementData replacementData) {
        buffer.writeShortLE(replacementData.getBiome());
        buffer.writeShortLE(replacementData.getDimension());
        helper.writeArray(buffer, replacementData.getTargetBiomes(), (buf, value) -> buf.writeShortLE((int)value.shortValue()));
        buffer.writeFloatLE(replacementData.getAmount());
        buffer.writeFloatLE(replacementData.getNoiseFrequencyScale());
        buffer.writeIntLE(replacementData.getReplacementIndex());
    }

    protected BiomeReplacementData readBiomeReplacementData(ByteBuf buffer, BedrockCodecHelper helper) {
        short biome = buffer.readShortLE();
        short dimension = buffer.readShortLE();
        ArrayList<Short> targetBiomes = new ArrayList<Short>();
        helper.readArray(buffer, targetBiomes, (buf, aHelper) -> buf.readShortLE());
        float amount = buffer.readFloatLE();
        float noiseFrequencyScale = buffer.readFloatLE();
        int replacementIndex = buffer.readIntLE();
        return new BiomeReplacementData(biome, dimension, targetBiomes, amount, noiseFrequencyScale, replacementIndex);
    }
}

