/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.biome;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.List;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.CoordinateEvaluationOrder;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.ExpressionOp;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.biome.BiomeCoordinateData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.util.index.Indexable;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.util.index.Unindexed;

public final class BiomeScatterParamData {
    private final List<BiomeCoordinateData> coordinates;
    private final CoordinateEvaluationOrder evalOrder;
    private final ExpressionOp chancePercentType;
    private final transient Indexable<String> chancePercent;
    private final int chanceNumerator;
    private final int changeDenominator;
    private final ExpressionOp iterationsType;
    private final transient Indexable<String> iterations;

    @JsonCreator
    public BiomeScatterParamData(List<BiomeCoordinateData> coordinates, CoordinateEvaluationOrder evalOrder, ExpressionOp chancePercentType, String chancePercent, int chanceNumerator, int changeDenominator, ExpressionOp iterationsType, String iterations) {
        this.coordinates = coordinates;
        this.evalOrder = evalOrder;
        this.chancePercentType = chancePercentType;
        this.chancePercent = new Unindexed<String>(chancePercent);
        this.chanceNumerator = chanceNumerator;
        this.changeDenominator = changeDenominator;
        this.iterationsType = iterationsType;
        this.iterations = new Unindexed<String>(iterations);
    }

    public String getChancePercent() {
        return this.chancePercent.get();
    }

    public String getIterations() {
        return this.iterations.get();
    }

    public List<BiomeCoordinateData> getCoordinates() {
        return this.coordinates;
    }

    public CoordinateEvaluationOrder getEvalOrder() {
        return this.evalOrder;
    }

    public ExpressionOp getChancePercentType() {
        return this.chancePercentType;
    }

    public int getChanceNumerator() {
        return this.chanceNumerator;
    }

    public int getChangeDenominator() {
        return this.changeDenominator;
    }

    public ExpressionOp getIterationsType() {
        return this.iterationsType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BiomeScatterParamData)) {
            return false;
        }
        BiomeScatterParamData other = (BiomeScatterParamData)o;
        if (this.getChanceNumerator() != other.getChanceNumerator()) {
            return false;
        }
        if (this.getChangeDenominator() != other.getChangeDenominator()) {
            return false;
        }
        List<BiomeCoordinateData> this$coordinates = this.getCoordinates();
        List<BiomeCoordinateData> other$coordinates = other.getCoordinates();
        if (this$coordinates == null ? other$coordinates != null : !((Object)this$coordinates).equals(other$coordinates)) {
            return false;
        }
        CoordinateEvaluationOrder this$evalOrder = this.getEvalOrder();
        CoordinateEvaluationOrder other$evalOrder = other.getEvalOrder();
        if (this$evalOrder == null ? other$evalOrder != null : !((Object)((Object)this$evalOrder)).equals((Object)other$evalOrder)) {
            return false;
        }
        ExpressionOp this$chancePercentType = this.getChancePercentType();
        ExpressionOp other$chancePercentType = other.getChancePercentType();
        if (this$chancePercentType == null ? other$chancePercentType != null : !((Object)((Object)this$chancePercentType)).equals((Object)other$chancePercentType)) {
            return false;
        }
        ExpressionOp this$iterationsType = this.getIterationsType();
        ExpressionOp other$iterationsType = other.getIterationsType();
        return !(this$iterationsType == null ? other$iterationsType != null : !((Object)((Object)this$iterationsType)).equals((Object)other$iterationsType));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getChanceNumerator();
        result = result * 59 + this.getChangeDenominator();
        List<BiomeCoordinateData> $coordinates = this.getCoordinates();
        result = result * 59 + ($coordinates == null ? 43 : ((Object)$coordinates).hashCode());
        CoordinateEvaluationOrder $evalOrder = this.getEvalOrder();
        result = result * 59 + ($evalOrder == null ? 43 : ((Object)((Object)$evalOrder)).hashCode());
        ExpressionOp $chancePercentType = this.getChancePercentType();
        result = result * 59 + ($chancePercentType == null ? 43 : ((Object)((Object)$chancePercentType)).hashCode());
        ExpressionOp $iterationsType = this.getIterationsType();
        result = result * 59 + ($iterationsType == null ? 43 : ((Object)((Object)$iterationsType)).hashCode());
        return result;
    }

    public String toString() {
        return "BiomeScatterParamData(coordinates=" + this.getCoordinates() + ", evalOrder=" + (Object)((Object)this.getEvalOrder()) + ", chancePercentType=" + (Object)((Object)this.getChancePercentType()) + ", chancePercent=" + this.getChancePercent() + ", chanceNumerator=" + this.getChanceNumerator() + ", changeDenominator=" + this.getChangeDenominator() + ", iterationsType=" + (Object)((Object)this.getIterationsType()) + ", iterations=" + this.getIterations() + ")";
    }

    @Deprecated
    public BiomeScatterParamData(List<BiomeCoordinateData> coordinates, CoordinateEvaluationOrder evalOrder, ExpressionOp chancePercentType, Indexable<String> chancePercent, int chanceNumerator, int changeDenominator, ExpressionOp iterationsType, Indexable<String> iterations) {
        this.coordinates = coordinates;
        this.evalOrder = evalOrder;
        this.chancePercentType = chancePercentType;
        this.chancePercent = chancePercent;
        this.chanceNumerator = chanceNumerator;
        this.changeDenominator = changeDenominator;
        this.iterationsType = iterationsType;
        this.iterations = iterations;
    }
}

