/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock;

import java.util.concurrent.TimeUnit;
import org.geysermc.cumulus.form.CustomForm;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.impl.FormDefinitions;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.ServerSettingsRequestPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.ServerSettingsResponsePacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.SetDifficultyPacket;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.SettingsUtils;
import org.geysermc.mcprotocollib.protocol.data.game.setting.Difficulty;

@Translator(packet=ServerSettingsRequestPacket.class)
public class BedrockServerSettingsRequestTranslator
extends PacketTranslator<ServerSettingsRequestPacket> {
    private final FormDefinitions formDefinitions = FormDefinitions.instance();

    @Override
    public void translate(GeyserSession session, ServerSettingsRequestPacket packet) {
        if (!session.isLoggedIn()) {
            return;
        }
        if (session.getWorldCache().getDifficulty() == Difficulty.PEACEFUL) {
            SetDifficultyPacket setDifficultyPacket = new SetDifficultyPacket();
            setDifficultyPacket.setDifficulty(Difficulty.PEACEFUL.ordinal());
            session.sendUpstreamPacket(setDifficultyPacket);
        }
        CustomForm form = SettingsUtils.buildForm(session);
        int formId = session.getFormCache().addForm((Form)form);
        String jsonData = this.formDefinitions.codecFor((Form)form).jsonData((Form)form);
        session.scheduleInEventLoop(() -> {
            ServerSettingsResponsePacket serverSettingsResponsePacket = new ServerSettingsResponsePacket();
            serverSettingsResponsePacket.setFormData(jsonData);
            serverSettingsResponsePacket.setFormId(formId);
            session.sendUpstreamPacket(serverSettingsResponsePacket);
        }, 1L, TimeUnit.SECONDS);
    }
}

