/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.dialog.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.kyori.adventure.key.Key;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.nbt.NbtMap;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.dialog.Dialog;
import org.geysermc.geyser.session.dialog.input.ParsedInputs;
import org.geysermc.geyser.util.MinecraftKey;
import org.geysermc.mcprotocollib.network.packet.Packet;
import org.geysermc.mcprotocollib.protocol.data.game.Holder;
import org.geysermc.mcprotocollib.protocol.packet.common.serverbound.ServerboundCustomClickActionPacket;

public interface DialogAction {
    public static Optional<DialogAction> read(Object tag, Dialog.IdGetter idGetter) {
        if (!(tag instanceof NbtMap)) {
            return Optional.empty();
        }
        NbtMap map = (NbtMap)tag;
        Key type = MinecraftKey.key(map.getString("type"));
        if (type.equals(OpenUrl.TYPE)) {
            return Optional.of(new OpenUrl(map.getString("url")));
        }
        if (type.equals(RunCommand.TYPE)) {
            return Optional.of(new RunCommand(map.getString("command")));
        }
        if (type.equals(ShowDialog.TYPE)) {
            return Optional.of(ShowDialog.read(map.get((Object)"dialog"), idGetter));
        }
        if (type.equals(Custom.TYPE)) {
            return Optional.of(new Custom(MinecraftKey.key(map.getString("id")), map.getCompound("payload")));
        }
        if (type.equals(DynamicRunCommand.TYPE)) {
            return Optional.of(DynamicRunCommand.read(map.getString("template")));
        }
        if (type.equals(DynamicCustom.TYPE)) {
            return Optional.of(new DynamicCustom(MinecraftKey.key(map.getString("id")), map.getCompound("additions")));
        }
        return Optional.empty();
    }

    public void run(GeyserSession var1, ParsedInputs var2);

    public record OpenUrl(String url) implements DialogAction
    {
        public static final Key TYPE = MinecraftKey.key("open_url");

        @Override
        public void run(GeyserSession session, ParsedInputs inputs) {
            throw new IllegalCallerException("Should be implemented elsewhere to open a form");
        }
    }

    public record RunCommand(String command) implements CommandAction
    {
        public static final Key TYPE = MinecraftKey.key("run_command");

        @Override
        public String command(GeyserSession session, ParsedInputs inputs) {
            return this.command;
        }
    }

    public record ShowDialog(Optional<Dialog> dialog, Holder<NbtMap> holder) implements DialogAction
    {
        public static final Key TYPE = MinecraftKey.key("show_dialog");

        public ShowDialog(Dialog dialog) {
            this(Optional.of(dialog), null);
        }

        private static ShowDialog read(Object dialog, Dialog.IdGetter idGetter) {
            if (dialog instanceof NbtMap) {
                NbtMap map = (NbtMap)dialog;
                return new ShowDialog(Optional.empty(), (Holder<NbtMap>)Holder.ofCustom((Object)map));
            }
            if (dialog instanceof String) {
                String string = (String)dialog;
                return new ShowDialog(Optional.empty(), (Holder<NbtMap>)Holder.ofId((int)idGetter.applyAsInt(MinecraftKey.key(string))));
            }
            throw new IllegalArgumentException("Expected dialog in show_dialog action to be a NBT map or a resource location");
        }

        @Override
        public void run(GeyserSession session, ParsedInputs inputs) {
            this.dialog.ifPresentOrElse(normal -> session.getDialogManager().openDialog((Dialog)normal), () -> session.getDialogManager().openDialog(this.holder));
        }
    }

    public record Custom(Key id, @Nullable NbtMap tag) implements DialogAction
    {
        public static final Key TYPE = MinecraftKey.key("custom");

        @Override
        public void run(GeyserSession session, ParsedInputs inputs) {
            session.sendDownstreamPacket((Packet)new ServerboundCustomClickActionPacket(this.id, this.tag));
        }
    }

    public record DynamicRunCommand(List<String> segments, List<String> variables) implements CommandAction
    {
        public static final Key TYPE = MinecraftKey.key("dynamic/run_command");

        private static DynamicRunCommand read(String command) {
            int length = command.length();
            int lastVariable = 0;
            int nextVariable = command.indexOf(36);
            ArrayList<String> segments = new ArrayList<String>();
            ArrayList<String> variables = new ArrayList<String>();
            while (nextVariable != -1) {
                if (nextVariable != length - 1 && command.charAt(nextVariable + 1) == '(') {
                    segments.add(command.substring(lastVariable, nextVariable));
                    int variableEnd = command.indexOf(41, nextVariable + 1);
                    if (variableEnd == -1) {
                        throw new IllegalArgumentException("Command ended with an open variable");
                    }
                    variables.add(command.substring(nextVariable + 2, variableEnd));
                    lastVariable = variableEnd + 1;
                    nextVariable = command.indexOf(36, lastVariable);
                    continue;
                }
                nextVariable = command.indexOf(36, nextVariable + 1);
            }
            if (lastVariable == 0) {
                throw new IllegalArgumentException("No variables in command template");
            }
            if (lastVariable != length) {
                segments.add(command.substring(lastVariable));
            }
            return new DynamicRunCommand(segments, variables);
        }

        @Override
        public String command(GeyserSession session, ParsedInputs inputs) {
            StringBuilder command = new StringBuilder();
            List<String> parsedVariables = this.variables.stream().map(inputs::getSubstitution).toList();
            for (int i = 0; i < this.variables.size(); ++i) {
                command.append(this.segments.get(i)).append(parsedVariables.get(i));
            }
            if (this.segments.size() > this.variables.size()) {
                command.append(this.segments.get(this.segments.size() - 1));
            }
            return command.toString();
        }
    }

    public record DynamicCustom(Key id, NbtMap additions) implements DialogAction
    {
        public static final Key TYPE = MinecraftKey.key("dynamic/custom");

        @Override
        public void run(GeyserSession session, ParsedInputs inputs) {
            NbtMap map = inputs.asNbtMap();
            map.putAll((Map)this.additions);
            session.sendDownstreamPacket((Packet)new ServerboundCustomClickActionPacket(this.id, map));
        }
    }

    public static interface CommandAction
    extends DialogAction {
        public String command(GeyserSession var1, ParsedInputs var2);

        default public String trimmedCommand(GeyserSession session, ParsedInputs inputs) {
            String command = this.command(session, inputs);
            if (command.startsWith("/")) {
                return command.substring(1);
            }
            return command;
        }

        @Override
        default public void run(GeyserSession session, ParsedInputs inputs) {
            throw new IllegalCallerException("Should be implemented elsewhere to run with a confirmation form");
        }
    }
}

