/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.bedrock.codec.v354.serializer;

import io.netty.buffer.ByteBuf;
import java.util.List;
import org.cloudburstmc.protocol.bedrock.codec.BedrockCodecHelper;
import org.cloudburstmc.protocol.bedrock.codec.BedrockPacketSerializer;
import org.cloudburstmc.protocol.bedrock.data.MapDecoration;
import org.cloudburstmc.protocol.bedrock.data.MapTrackedObject;
import org.cloudburstmc.protocol.bedrock.packet.ClientboundMapItemDataPacket;
import org.cloudburstmc.protocol.common.util.VarInts;
import org.geysermc.geyser.platform.velocity.shaded.it.unimi.dsi.fastutil.longs.LongList;
import org.geysermc.geyser.platform.velocity.shaded.it.unimi.dsi.fastutil.longs.LongListIterator;

public class ClientboundMapItemDataSerializer_v354
implements BedrockPacketSerializer<ClientboundMapItemDataPacket> {
    public static final ClientboundMapItemDataSerializer_v354 INSTANCE = new ClientboundMapItemDataSerializer_v354();
    protected static final int FLAG_TEXTURE_UPDATE = 2;
    protected static final int FLAG_DECORATION_UPDATE = 4;
    protected static final int FLAG_MAP_CREATION = 8;
    protected static final int FLAG_ALL = 14;

    @Override
    public void serialize(ByteBuf buffer, BedrockCodecHelper helper, ClientboundMapItemDataPacket packet) {
        LongList trackedEntityIds;
        VarInts.writeLong(buffer, packet.getUniqueMapId());
        int type = 0;
        int[] colors = packet.getColors();
        if (colors != null && colors.length > 0) {
            type |= 2;
        }
        List<MapDecoration> decorations = packet.getDecorations();
        List<MapTrackedObject> trackedObjects = packet.getTrackedObjects();
        if (!decorations.isEmpty() && !trackedObjects.isEmpty()) {
            type |= 4;
        }
        if (!(trackedEntityIds = packet.getTrackedEntityIds()).isEmpty()) {
            type |= 8;
        }
        VarInts.writeUnsignedInt(buffer, type);
        buffer.writeByte(packet.getDimensionId());
        buffer.writeBoolean(packet.isLocked());
        if ((type & 8) != 0) {
            this.writeMapCreation(buffer, helper, packet);
        }
        if ((type & 0xE) != 0) {
            buffer.writeByte(packet.getScale());
        }
        if ((type & 4) != 0) {
            this.writeMapDecorations(buffer, helper, packet);
        }
        if ((type & 2) != 0) {
            this.writeTextureUpdate(buffer, helper, packet);
        }
    }

    @Override
    public void deserialize(ByteBuf buffer, BedrockCodecHelper helper, ClientboundMapItemDataPacket packet) {
        packet.setUniqueMapId(VarInts.readLong(buffer));
        int type = VarInts.readUnsignedInt(buffer);
        packet.setDimensionId(buffer.readUnsignedByte());
        packet.setLocked(buffer.readBoolean());
        if ((type & 8) != 0) {
            this.readMapCreation(buffer, helper, packet);
        }
        if ((type & 0xE) != 0) {
            packet.setScale(buffer.readUnsignedByte());
        }
        if ((type & 4) != 0) {
            this.writeMapDecorations(buffer, helper, packet);
        }
        if ((type & 2) != 0) {
            this.readTextureUpdate(buffer, helper, packet);
        }
    }

    protected void writeMapCreation(ByteBuf buffer, BedrockCodecHelper helper, ClientboundMapItemDataPacket packet) {
        VarInts.writeUnsignedInt(buffer, packet.getTrackedEntityIds().size());
        LongListIterator longListIterator = packet.getTrackedEntityIds().iterator();
        while (longListIterator.hasNext()) {
            long trackedEntityId = (Long)longListIterator.next();
            VarInts.writeLong(buffer, trackedEntityId);
        }
    }

    protected void readMapCreation(ByteBuf buffer, BedrockCodecHelper helper, ClientboundMapItemDataPacket packet) {
        LongList trackedEntityIds = packet.getTrackedEntityIds();
        int length = VarInts.readUnsignedInt(buffer);
        for (int i = 0; i < length; ++i) {
            trackedEntityIds.add(VarInts.readLong(buffer));
        }
    }

    protected void writeMapDecorations(ByteBuf buffer, BedrockCodecHelper helper, ClientboundMapItemDataPacket packet) {
        List<MapDecoration> decorations = packet.getDecorations();
        List<MapTrackedObject> trackedObjects = packet.getTrackedObjects();
        VarInts.writeUnsignedInt(buffer, trackedObjects.size());
        for (MapTrackedObject object : trackedObjects) {
            switch (object.getType()) {
                case BLOCK: {
                    buffer.writeIntLE(object.getType().ordinal());
                    helper.writeBlockPosition(buffer, object.getPosition());
                    break;
                }
                case ENTITY: {
                    buffer.writeIntLE(object.getType().ordinal());
                    VarInts.writeLong(buffer, object.getEntityId());
                }
            }
        }
        VarInts.writeUnsignedInt(buffer, decorations.size());
        for (MapDecoration decoration : decorations) {
            buffer.writeByte(decoration.getImage());
            buffer.writeByte(decoration.getRotation());
            buffer.writeByte(decoration.getXOffset());
            buffer.writeByte(decoration.getYOffset());
            helper.writeString(buffer, decoration.getLabel());
            VarInts.writeUnsignedInt(buffer, decoration.getColor());
        }
    }

    protected void readMapDecorations(ByteBuf buffer, BedrockCodecHelper helper, ClientboundMapItemDataPacket packet) {
        List<MapTrackedObject> trackedObjects = packet.getTrackedObjects();
        int length = VarInts.readUnsignedInt(buffer);
        block4: for (int i = 0; i < length; ++i) {
            MapTrackedObject.Type objectType = MapTrackedObject.Type.values()[buffer.readIntLE()];
            switch (objectType) {
                case BLOCK: {
                    trackedObjects.add(new MapTrackedObject(helper.readBlockPosition(buffer)));
                    continue block4;
                }
                case ENTITY: {
                    trackedObjects.add(new MapTrackedObject(VarInts.readLong(buffer)));
                }
            }
        }
        List<MapDecoration> decorations = packet.getDecorations();
        length = VarInts.readUnsignedInt(buffer);
        for (int i = 0; i < length; ++i) {
            short image = buffer.readUnsignedByte();
            short rotation = buffer.readUnsignedByte();
            short xOffset = buffer.readUnsignedByte();
            short yOffset = buffer.readUnsignedByte();
            String label = helper.readString(buffer);
            int color = VarInts.readUnsignedInt(buffer);
            decorations.add(new MapDecoration(image, rotation, xOffset, yOffset, label, color));
        }
    }

    protected void writeTextureUpdate(ByteBuf buffer, BedrockCodecHelper helper, ClientboundMapItemDataPacket packet) {
        VarInts.writeInt(buffer, packet.getWidth());
        VarInts.writeInt(buffer, packet.getHeight());
        VarInts.writeInt(buffer, packet.getXOffset());
        VarInts.writeInt(buffer, packet.getYOffset());
        int length = packet.getColors().length;
        VarInts.writeUnsignedInt(buffer, length);
        for (int color : packet.getColors()) {
            VarInts.writeUnsignedInt(buffer, color);
        }
    }

    protected void readTextureUpdate(ByteBuf buffer, BedrockCodecHelper helper, ClientboundMapItemDataPacket packet) {
        packet.setWidth(VarInts.readInt(buffer));
        packet.setHeight(VarInts.readInt(buffer));
        packet.setXOffset(VarInts.readInt(buffer));
        packet.setYOffset(VarInts.readInt(buffer));
        int length = VarInts.readUnsignedInt(buffer);
        int[] colors = new int[length];
        for (int i = 0; i < length; ++i) {
            colors[i] = VarInts.readUnsignedInt(buffer);
        }
        packet.setColors(colors);
    }

    protected ClientboundMapItemDataSerializer_v354() {
    }
}

