/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.level.block;

import java.util.BitSet;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.Fluid;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.block.type.PistonBlock;
import org.geysermc.geyser.level.physics.PistonBehavior;
import org.geysermc.geyser.registry.BlockRegistries;

public final class BlockStateValues {
    public static final int NUM_FLUID_LEVELS = 9;

    public static boolean isBlockSticky(BlockState state) {
        Block block = state.block();
        return block == Blocks.SLIME_BLOCK || block == Blocks.HONEY_BLOCK;
    }

    public static boolean isBlockAttached(BlockState stateA, BlockState stateB) {
        boolean aSticky = BlockStateValues.isBlockSticky(stateA);
        boolean bSticky = BlockStateValues.isBlockSticky(stateB);
        if (aSticky && bSticky) {
            return stateA.block() == stateB.block();
        }
        return aSticky || bSticky;
    }

    public static boolean canPistonDestroyBlock(BlockState state) {
        return state.block().pushReaction() == PistonBehavior.DESTROY;
    }

    public static boolean canPistonMoveBlock(BlockState state, boolean isPushing) {
        Block block = state.block();
        if (block == Blocks.AIR) {
            return true;
        }
        if (block == Blocks.OBSIDIAN || block == Blocks.CRYING_OBSIDIAN || block == Blocks.RESPAWN_ANCHOR || block == Blocks.REINFORCED_DEEPSLATE) {
            return false;
        }
        if (block instanceof PistonBlock) {
            return state.getValue(Properties.EXTENDED) == false;
        }
        if (block.destroyTime() == -1.0f) {
            return false;
        }
        return switch (block.pushReaction()) {
            case PistonBehavior.BLOCK, PistonBehavior.DESTROY -> false;
            case PistonBehavior.PUSH_ONLY -> isPushing;
            default -> !block.hasBlockEntity();
        };
    }

    public static Fluid getFluid(int state) {
        BlockState blockState = BlockState.of(state);
        if (blockState.is(Blocks.WATER) || ((BitSet)BlockRegistries.WATERLOGGED.get()).get(state)) {
            return Fluid.WATER;
        }
        if (blockState.is(Blocks.LAVA)) {
            return Fluid.LAVA;
        }
        return Fluid.EMPTY;
    }

    public static int getWaterLevel(int state) {
        BlockState blockState = BlockState.of(state);
        if (!blockState.is(Blocks.WATER)) {
            return -1;
        }
        return blockState.getValue(Properties.LEVEL);
    }

    public static double getWaterHeight(int state) {
        int waterLevel = BlockStateValues.getWaterLevel(state);
        if (((BitSet)BlockRegistries.WATERLOGGED.get()).get(state)) {
            waterLevel = 0;
        }
        if (waterLevel >= 0) {
            double waterHeight = 1.0 - (double)(waterLevel + 1) / 9.0;
            if (waterLevel >= 8) {
                waterHeight = 1.0;
            }
            return waterHeight;
        }
        return -1.0;
    }

    public static int getLavaLevel(int state) {
        BlockState blockState = BlockState.of(state);
        if (!blockState.is(Blocks.LAVA)) {
            return -1;
        }
        return blockState.getValue(Properties.LEVEL);
    }

    public static double getLavaHeight(int state) {
        int lavaLevel = BlockStateValues.getLavaLevel(state);
        if (lavaLevel >= 0) {
            double lavaHeight = 1.0 - (double)(lavaLevel + 1) / 9.0;
            if (lavaLevel >= 8) {
                lavaHeight = 1.0;
            }
            return lavaHeight;
        }
        return -1.0;
    }

    public static float getSlipperiness(BlockState state) {
        Block block = state.block();
        if (block == Blocks.SLIME_BLOCK) {
            return 0.8f;
        }
        if (block == Blocks.ICE || block == Blocks.PACKED_ICE) {
            return 0.98f;
        }
        if (block == Blocks.BLUE_ICE) {
            return 0.989f;
        }
        return 0.6f;
    }

    private BlockStateValues() {
    }
}

