/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.level.block.type;

import java.util.Objects;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.ChunkUtils;

public class DoorBlock
extends Block {
    public DoorBlock(String javaIdentifier, Block.Builder builder) {
        super(javaIdentifier, builder);
    }

    @Override
    public void updateBlock(GeyserSession session, BlockState state, Vector3i position) {
        BlockState oldBlockState;
        String doubleBlockHalf = state.getValue(Properties.DOUBLE_BLOCK_HALF);
        Vector3i lastLowerDoor = session.getLastLowerDoorPosition();
        session.setLastLowerDoorPosition(null);
        if (Objects.equals(lastLowerDoor, position) && doubleBlockHalf.equals("lower") && (oldBlockState = session.getGeyser().getWorldManager().blockAt(session, position)) == state) {
            return;
        }
        super.updateBlock(session, state, position);
        if (doubleBlockHalf.equals("upper")) {
            Vector3i belowDoorPosition = position.down(1);
            BlockState belowDoorBlockState = session.getGeyser().getWorldManager().blockAt(session, belowDoorPosition.getX(), belowDoorPosition.getY(), belowDoorPosition.getZ());
            if (belowDoorBlockState.block() instanceof DoorBlock) {
                belowDoorBlockState = belowDoorBlockState.withValue(Properties.OPEN, state.getValue(Properties.OPEN));
                ChunkUtils.updateBlock(session, belowDoorBlockState, belowDoorPosition);
                session.setLastLowerDoorPosition(belowDoorPosition);
            }
        }
    }
}

