/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal.tameable;

import java.util.Collections;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.packet.AddEntityPacket;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.UpdateAttributesPacket;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.living.animal.VariantIntHolder;
import org.geysermc.geyser.entity.type.living.animal.tameable.TameableEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.enchantment.EnchantmentComponent;
import org.geysermc.geyser.item.type.DyeItem;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.registry.JavaRegistries;
import org.geysermc.geyser.session.cache.registry.JavaRegistryKey;
import org.geysermc.geyser.session.cache.tags.ItemTag;
import org.geysermc.geyser.session.cache.tags.Tag;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;
import org.geysermc.geyser.util.ItemUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.ByteEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.IntEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.GameMode;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.HolderSet;

public class WolfEntity
extends TameableEntity
implements VariantIntHolder {
    private byte collarColor = (byte)14;
    private HolderSet repairableItems = null;
    private boolean isCurseOfBinding = false;

    public WolfEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    @Override
    public void addAdditionalSpawnData(AddEntityPacket addEntityPacket) {
        this.propertyManager.add("minecraft:sound_variant", "default");
        this.propertyManager.applyIntProperties(addEntityPacket.getProperties().getIntProperties());
    }

    @Override
    public void setTameableFlags(ByteEntityMetadata entityMetadata) {
        super.setTameableFlags(entityMetadata);
        if (this.getFlag(EntityFlag.ANGRY)) {
            this.dirtyMetadata.put(EntityDataTypes.COLOR, (byte)0);
        } else if (this.getFlag(EntityFlag.TAMED)) {
            this.updateCollarColor();
            UpdateAttributesPacket packet = new UpdateAttributesPacket();
            packet.setRuntimeEntityId(this.geyserId);
            packet.setAttributes(Collections.singletonList(this.createHealthAttribute()));
            this.session.sendUpstreamPacket((BedrockPacket)packet);
        }
    }

    public void setCollarColor(IntEntityMetadata entityMetadata) {
        this.collarColor = (byte)entityMetadata.getPrimitiveValue();
        if (!this.getFlag(EntityFlag.ANGRY) && this.getFlag(EntityFlag.TAMED)) {
            this.updateCollarColor();
        }
    }

    private void updateCollarColor() {
        this.dirtyMetadata.put(EntityDataTypes.COLOR, this.collarColor);
        if (this.ownerBedrockId == 0L) {
            this.dirtyMetadata.put(EntityDataTypes.OWNER_EID, this.session.getPlayerEntity().getGeyserId());
        }
    }

    public void setWolfAngerTime(IntEntityMetadata entityMetadata) {
        int time = entityMetadata.getPrimitiveValue();
        this.setFlag(EntityFlag.ANGRY, time != 0);
        this.dirtyMetadata.put(EntityDataTypes.COLOR, time != 0 ? (byte)0 : this.collarColor);
    }

    @Override
    public JavaRegistryKey<BuiltInVariant> variantRegistry() {
        return JavaRegistries.WOLF_VARIANT;
    }

    @Override
    public void setBedrockVariantId(int bedrockId) {
        this.dirtyMetadata.put(EntityDataTypes.VARIANT, bedrockId);
    }

    @Override
    protected @Nullable Tag<Item> getFoodTag() {
        return ItemTag.WOLF_FOOD;
    }

    @Override
    public void setBody(ItemStack stack) {
        super.setBody(stack);
        this.isCurseOfBinding = ItemUtils.hasEffect(this.session, stack, EnchantmentComponent.PREVENT_ARMOR_CHANGE);
        this.repairableItems = (HolderSet)GeyserItemStack.from(stack).getComponent(DataComponentTypes.REPAIRABLE);
    }

    @Override
    public boolean canBeLeashed() {
        return !this.getFlag(EntityFlag.ANGRY) && super.canBeLeashed();
    }

    @Override
    protected @NonNull InteractiveTag testMobInteraction(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        if (this.getFlag(EntityFlag.ANGRY)) {
            return InteractiveTag.NONE;
        }
        if (itemInHand.asItem() == Items.BONE && !this.getFlag(EntityFlag.TAMED)) {
            return InteractiveTag.TAME;
        }
        if (this.getFlag(EntityFlag.TAMED) && this.ownerBedrockId == this.session.getPlayerEntity().getGeyserId()) {
            Item item = itemInHand.asItem();
            if (item instanceof DyeItem) {
                DyeItem dyeItem = (DyeItem)item;
                if (dyeItem.dyeColor() != this.collarColor) {
                    return InteractiveTag.DYE;
                }
                return super.testMobInteraction(hand, itemInHand);
            }
            if (itemInHand.asItem() == Items.WOLF_ARMOR && !this.body.isValid() && !this.getFlag(EntityFlag.BABY)) {
                return InteractiveTag.EQUIP_WOLF_ARMOR;
            }
            if (itemInHand.asItem() == Items.SHEARS && this.body.isValid() && (!this.isCurseOfBinding || this.session.getGameMode().equals((Object)GameMode.CREATIVE))) {
                return InteractiveTag.REMOVE_WOLF_ARMOR;
            }
            if (this.getFlag(EntityFlag.SITTING) && this.session.getTagCache().isItem(this.repairableItems, itemInHand.asItem()) && this.body.isValid() && this.body.getTag() != null && this.body.getTag().getInt("Damage") > 0) {
                return InteractiveTag.REPAIR_WOLF_ARMOR;
            }
            return this.getFlag(EntityFlag.SITTING) ? InteractiveTag.STAND : InteractiveTag.SIT;
        }
        return super.testMobInteraction(hand, itemInHand);
    }

    @Override
    protected @NonNull InteractionResult mobInteract(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        if (this.ownerBedrockId == this.session.getPlayerEntity().getGeyserId() || this.getFlag(EntityFlag.TAMED) || itemInHand.asItem() == Items.BONE && !this.getFlag(EntityFlag.ANGRY)) {
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public static enum BuiltInVariant implements VariantIntHolder.BuiltIn
    {
        PALE,
        ASHEN,
        BLACK,
        CHESTNUT,
        RUSTY,
        SNOWY,
        SPOTTED,
        STRIPED,
        WOODS;

    }
}

