/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock;

import java.util.concurrent.TimeUnit;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.ContainerClosePacket;
import org.cloudburstmc.protocol.bedrock.packet.NetworkStackLatencyPacket;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.InventoryHolder;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.MerchantInventoryTranslator;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.InventoryUtils;

@Translator(packet=ContainerClosePacket.class)
public class BedrockContainerCloseTranslator
extends PacketTranslator<ContainerClosePacket> {
    @Override
    public void translate(GeyserSession session, ContainerClosePacket packet) {
        GeyserImpl.getInstance().getLogger().debug(session, packet.toString(), new Object[0]);
        byte bedrockId = packet.getId();
        session.sendUpstreamPacket((BedrockPacket)packet);
        session.setClosingInventory(false);
        InventoryHolder<? extends Inventory> holder = session.getInventoryHolder();
        if (bedrockId == -1 && holder != null) {
            if (holder.translator() instanceof MerchantInventoryTranslator) {
                bedrockId = (byte)holder.bedrockId();
            } else if (holder.bedrockId() == session.getPendingOrCurrentBedrockInventoryId()) {
                if (holder.containerOpenAttempts() < 7) {
                    holder.incrementContainerOpenAttempts();
                    holder.pending(true);
                    session.scheduleInEventLoop(() -> {
                        NetworkStackLatencyPacket latencyPacket = new NetworkStackLatencyPacket();
                        latencyPacket.setFromServer(true);
                        latencyPacket.setTimestamp(-9876543210L);
                        session.sendUpstreamPacket((BedrockPacket)latencyPacket);
                        GeyserImpl.getInstance().getLogger().debug(session, "Unable to open a virtual inventory, sent another latency packet!", new Object[0]);
                    }, 150L, TimeUnit.MILLISECONDS);
                    return;
                }
                GeyserImpl.getInstance().getLogger().warning(session.bedrockUsername() + " exceeded 7 attempts to open a virtual inventory!");
                GeyserImpl.getInstance().getLogger().debug(session, String.valueOf(packet) + " " + holder.inventory().getClass().getSimpleName(), new Object[0]);
                bedrockId = (byte)holder.bedrockId();
            }
        }
        session.setPendingOrCurrentBedrockInventoryId(-1);
        if (holder != null) {
            if (bedrockId == holder.bedrockId()) {
                InventoryUtils.sendJavaContainerClose(holder);
                InventoryUtils.closeInventory(session, holder, false);
                return;
            }
            InventoryUtils.openPendingInventory(session);
        }
    }
}

