/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.geysermc.geyser.shaded.com.fasterxml.jackson.databind.node.ArrayNode;
import org.geysermc.geyser.shaded.com.fasterxml.jackson.databind.node.ObjectNode;

public class Metrics {
    public static final int B_STATS_VERSION = 1;
    private static final String URL = "https://bStats.org/submitData/server-implementation";
    private static boolean logFailedRequests = false;
    private static Logger logger = Logger.getLogger("bStats");
    private final String name;
    private final String serverUUID;
    private final List<CustomChart> charts = new ArrayList<CustomChart>();
    private static final ObjectMapper mapper = new ObjectMapper();
    private final GeyserImpl geyser;

    public Metrics(GeyserImpl geyser, String name, String serverUUID, boolean logFailedRequests, Logger logger) {
        this.geyser = geyser;
        this.name = name;
        this.serverUUID = serverUUID;
        Metrics.logFailedRequests = logFailedRequests;
        Metrics.logger = logger;
        this.startSubmitting();
    }

    public void addCustomChart(CustomChart chart) {
        if (chart == null) {
            throw new IllegalArgumentException("Chart cannot be null!");
        }
        this.charts.add(chart);
    }

    private void startSubmitting() {
        this.geyser.getScheduledThread().scheduleAtFixedRate(this::submitData, 1L, 30L, TimeUnit.MINUTES);
    }

    private ObjectNode getPluginData() {
        ObjectNode data = mapper.createObjectNode();
        data.put("pluginName", this.name);
        data.put("pluginVersion", "2.7.1-b845 (git-master-d63e82c)");
        ArrayNode customCharts = mapper.createArrayNode();
        for (CustomChart customChart : this.charts) {
            ObjectNode chart = customChart.getRequestJsonNode();
            if (chart == null) continue;
            customCharts.add(chart);
        }
        data.set("customCharts", customCharts);
        return data;
    }

    private ObjectNode getServerData() {
        String osName = System.getProperty("os.name");
        String osArch = System.getProperty("os.arch");
        String osVersion = System.getProperty("os.version");
        int coreCount = Runtime.getRuntime().availableProcessors();
        ObjectNode data = mapper.createObjectNode();
        data.put("serverUUID", this.serverUUID);
        data.put("osName", osName);
        data.put("osArch", osArch);
        data.put("osVersion", osVersion);
        data.put("coreCount", coreCount);
        return data;
    }

    private void submitData() {
        ObjectNode data = this.getServerData();
        ArrayNode pluginData = mapper.createArrayNode();
        pluginData.add(this.getPluginData());
        data.putPOJO("plugins", pluginData);
        new Thread(() -> {
            block2: {
                try {
                    Metrics.sendData(data);
                }
                catch (Exception e) {
                    if (!logFailedRequests) break block2;
                    logger.log(Level.WARNING, "Could not submit stats of " + this.name, e);
                }
            }
        }).start();
    }

    private static void sendData(ObjectNode data) throws Exception {
        if (data == null) {
            throw new IllegalArgumentException("Data cannot be null!");
        }
        HttpsURLConnection connection = (HttpsURLConnection)new URL(URL).openConnection();
        byte[] compressedData = Metrics.compress(data.toString());
        connection.setRequestMethod("POST");
        connection.addRequestProperty("Accept", "application/json");
        connection.addRequestProperty("Connection", "close");
        connection.addRequestProperty("Content-Encoding", "gzip");
        connection.addRequestProperty("Content-Length", String.valueOf(compressedData.length));
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("User-Agent", "MC-Server/1");
        connection.setDoOutput(true);
        DataOutputStream outputStream = new DataOutputStream(connection.getOutputStream());
        outputStream.write(compressedData);
        outputStream.flush();
        outputStream.close();
        connection.getInputStream().close();
    }

    private static byte @NonNull [] compress(@NonNull String str) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(outputStream);
        gzip.write(str.getBytes(StandardCharsets.UTF_8));
        gzip.close();
        return outputStream.toByteArray();
    }

    public static abstract class CustomChart {
        final String chartId;

        CustomChart(String chartId) {
            if (chartId == null || chartId.isEmpty()) {
                throw new IllegalArgumentException("ChartId cannot be null or empty!");
            }
            this.chartId = chartId;
        }

        private @Nullable ObjectNode getRequestJsonNode() {
            ObjectNode chart = new ObjectMapper().createObjectNode();
            chart.put("chartId", this.chartId);
            try {
                ObjectNode data = this.getChartData();
                if (data == null) {
                    return null;
                }
                chart.putPOJO("data", data);
            }
            catch (Throwable t) {
                if (logFailedRequests) {
                    logger.log(Level.WARNING, "Failed to get data for custom chart with id " + this.chartId, t);
                }
                return null;
            }
            return chart;
        }

        protected abstract ObjectNode getChartData() throws Exception;
    }

    public static class SingleLineChart
    extends CustomChart {
        private final Callable<Integer> callable;

        public SingleLineChart(String chartId, Callable<Integer> callable) {
            super(chartId);
            this.callable = callable;
        }

        @Override
        protected @Nullable ObjectNode getChartData() throws Exception {
            ObjectNode data = mapper.createObjectNode();
            int value = this.callable.call();
            if (value == 0) {
                return null;
            }
            data.put("value", value);
            return data;
        }
    }

    public static class DrilldownPie
    extends CustomChart {
        private final Callable<Map<String, Map<String, Integer>>> callable;

        public DrilldownPie(String chartId, Callable<Map<String, Map<String, Integer>>> callable) {
            super(chartId);
            this.callable = callable;
        }

        @Override
        public @Nullable ObjectNode getChartData() throws Exception {
            ObjectNode data = mapper.createObjectNode();
            ObjectNode values = mapper.createObjectNode();
            Map<String, Map<String, Integer>> map = this.callable.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean reallyAllSkipped = true;
            for (Map.Entry<String, Map<String, Integer>> entryValues : map.entrySet()) {
                ObjectNode value = mapper.createObjectNode();
                boolean allSkipped = true;
                for (Map.Entry<String, Integer> valueEntry : map.get(entryValues.getKey()).entrySet()) {
                    value.put(valueEntry.getKey(), valueEntry.getValue());
                    allSkipped = false;
                }
                if (allSkipped) continue;
                reallyAllSkipped = false;
                values.putPOJO(entryValues.getKey(), value);
            }
            if (reallyAllSkipped) {
                return null;
            }
            data.putPOJO("values", values);
            return data;
        }
    }

    public static class AdvancedPie
    extends CustomChart {
        private final Callable<Map<String, Integer>> callable;

        public AdvancedPie(String chartId, Callable<Map<String, Integer>> callable) {
            super(chartId);
            this.callable = callable;
        }

        @Override
        protected @Nullable ObjectNode getChartData() throws Exception {
            ObjectNode data = mapper.createObjectNode();
            ObjectNode values = mapper.createObjectNode();
            Map<String, Integer> map = this.callable.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean allSkipped = true;
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                if (entry.getValue() == 0) continue;
                allSkipped = false;
                values.put(entry.getKey(), entry.getValue());
            }
            if (allSkipped) {
                return null;
            }
            data.putPOJO("values", values);
            return data;
        }
    }

    public static class SimplePie
    extends CustomChart {
        private final Callable<String> callable;

        public SimplePie(String chartId, Callable<String> callable) {
            super(chartId);
            this.callable = callable;
        }

        @Override
        protected @Nullable ObjectNode getChartData() throws Exception {
            ObjectNode data = mapper.createObjectNode();
            String value = this.callable.call();
            if (value == null || value.isEmpty()) {
                return null;
            }
            data.put("value", value);
            return data;
        }
    }
}

