/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache;

import java.util.Set;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.cloudburstmc.math.vector.Vector2f;
import org.cloudburstmc.protocol.bedrock.data.InputInteractionModel;
import org.cloudburstmc.protocol.bedrock.data.InputMode;
import org.cloudburstmc.protocol.bedrock.data.PlayerAuthInputData;
import org.cloudburstmc.protocol.bedrock.packet.PlayerAuthInputPacket;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.mcprotocollib.network.packet.Packet;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.level.ServerboundPlayerInputPacket;

public final class InputCache {
    private final GeyserSession session;
    private ServerboundPlayerInputPacket inputPacket = new ServerboundPlayerInputPacket(false, false, false, false, false, false, false);
    private boolean lastHorizontalCollision;
    private int ticksSinceLastMovePacket;
    private int jumpingTicks;
    private float jumpScale;
    private @MonotonicNonNull InputMode inputMode;

    public InputCache(GeyserSession session) {
        this.session = session;
    }

    public void processInputs(SessionPlayerEntity entity, PlayerAuthInputPacket packet) {
        boolean right;
        boolean left;
        boolean down;
        boolean up;
        boolean isMobileAndClassicMovement;
        Set bedrockInput = packet.getInputData();
        ServerboundPlayerInputPacket oldInputPacket = this.inputPacket;
        this.inputMode = packet.getInputMode();
        boolean bl = isMobileAndClassicMovement = this.inputMode == InputMode.TOUCH && packet.getInputInteractionModel() == InputInteractionModel.CLASSIC;
        if (this.inputMode == InputMode.MOUSE || isMobileAndClassicMovement) {
            up = bedrockInput.contains(PlayerAuthInputData.UP);
            down = bedrockInput.contains(PlayerAuthInputData.DOWN);
            left = bedrockInput.contains(PlayerAuthInputData.LEFT);
            right = bedrockInput.contains(PlayerAuthInputData.RIGHT);
            if (isMobileAndClassicMovement) {
                if (bedrockInput.contains(PlayerAuthInputData.UP_LEFT)) {
                    up = true;
                    left = true;
                }
                if (bedrockInput.contains(PlayerAuthInputData.UP_RIGHT)) {
                    up = true;
                    right = true;
                }
                if (bedrockInput.contains(PlayerAuthInputData.DOWN_LEFT)) {
                    down = true;
                    left = true;
                }
                if (bedrockInput.contains(PlayerAuthInputData.DOWN_RIGHT)) {
                    down = true;
                    right = true;
                }
            }
        } else {
            Vector2f analogMovement = packet.getAnalogMoveVector();
            up = analogMovement.getY() > 0.0f;
            down = analogMovement.getY() < 0.0f;
            left = analogMovement.getX() > 0.0f;
            right = analogMovement.getX() < 0.0f;
        }
        boolean sneaking = this.isSneaking(bedrockInput);
        this.inputPacket = this.inputPacket.withForward(up).withBackward(down).withLeft(left).withRight(right).withJump(bedrockInput.contains(PlayerAuthInputData.JUMP_CURRENT_RAW) || bedrockInput.contains(PlayerAuthInputData.JUMP_DOWN)).withShift(this.session.isShouldSendSneak() || sneaking).withSprint(bedrockInput.contains(PlayerAuthInputData.SPRINT_DOWN));
        if (this.session.isSneaking() != sneaking) {
            if (sneaking) {
                this.session.startSneaking(true);
            } else {
                this.session.stopSneaking(true);
            }
        }
        if (oldInputPacket != this.inputPacket) {
            this.session.sendDownstreamGamePacket((Packet)this.inputPacket);
        }
    }

    public boolean wasJumping() {
        return this.inputPacket.isJump();
    }

    public void markPositionPacketSent() {
        this.ticksSinceLastMovePacket = 0;
    }

    public boolean shouldSendPositionReminder() {
        return ++this.ticksSinceLastMovePacket >= 20;
    }

    public boolean lastHorizontalCollision() {
        return this.lastHorizontalCollision;
    }

    public boolean isSneaking(Set<PlayerAuthInputData> authInputData) {
        if (this.session.isFlying()) {
            return authInputData.contains(PlayerAuthInputData.DESCEND) || authInputData.contains(PlayerAuthInputData.SNEAK_DOWN);
        }
        boolean sneaking = this.session.isSneaking();
        for (PlayerAuthInputData authInput : authInputData) {
            switch (authInput) {
                case STOP_SNEAKING: {
                    sneaking = false;
                    break;
                }
                case START_SNEAKING: {
                    sneaking = true;
                    break;
                }
                case PERSIST_SNEAK: {
                    if (this.inputMode != InputMode.TOUCH || !this.session.getPlayerEntity().isInsideScaffolding()) break;
                    return authInputData.contains(PlayerAuthInputData.DESCEND_BLOCK) && authInputData.contains(PlayerAuthInputData.SNEAK_CURRENT_RAW);
                }
            }
        }
        return sneaking;
    }

    public void setLastHorizontalCollision(boolean lastHorizontalCollision) {
        this.lastHorizontalCollision = lastHorizontalCollision;
    }

    public int getJumpingTicks() {
        return this.jumpingTicks;
    }

    public void setJumpingTicks(int jumpingTicks) {
        this.jumpingTicks = jumpingTicks;
    }

    public float getJumpScale() {
        return this.jumpScale;
    }

    public void setJumpScale(float jumpScale) {
        this.jumpScale = jumpScale;
    }

    public @MonotonicNonNull InputMode getInputMode() {
        return this.inputMode;
    }

    public void setInputMode(@MonotonicNonNull InputMode inputMode) {
        this.inputMode = inputMode;
    }
}

