/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.dialog;

import java.util.List;
import java.util.Optional;
import org.cloudburstmc.nbt.NbtMap;
import org.geysermc.cumulus.component.DropdownComponent;
import org.geysermc.cumulus.form.CustomForm;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.response.CustomFormResponse;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.dialog.Dialog;
import org.geysermc.geyser.session.dialog.DialogButton;
import org.geysermc.geyser.session.dialog.DialogHolder;
import org.geysermc.geyser.session.dialog.input.ParsedInputs;
import org.geysermc.geyser.text.GeyserLocale;

public abstract class DialogWithButtons
extends Dialog {
    protected final Optional<DialogButton> exitAction;

    protected DialogWithButtons(GeyserSession session, NbtMap map, Optional<DialogButton> exitAction) {
        super(session, map);
        this.exitAction = exitAction;
    }

    protected abstract List<DialogButton> buttons(DialogHolder var1);

    @Override
    protected void addCustomComponents(DialogHolder holder, CustomForm.Builder builder) {
        List<DialogButton> buttons = this.buttons(holder);
        DropdownComponent.Builder dropdown = DropdownComponent.builder();
        dropdown.text(GeyserLocale.getPlayerLocaleString("geyser.dialogs.select_action", holder.session().locale()));
        for (DialogButton button2 : buttons) {
            dropdown.option(button2.label());
        }
        this.exitAction.ifPresent(button -> dropdown.option(button.label()));
        builder.dropdown(dropdown);
        builder.validResultHandler(response -> this.parseInput(holder, (CustomFormResponse)response).ifPresent(inputs -> {
            int selection = response.asDropdown();
            if (selection == buttons.size()) {
                holder.runButton(this.exitAction, (ParsedInputs)inputs);
            } else {
                holder.runButton(Optional.of((DialogButton)buttons.get(selection)), (ParsedInputs)inputs);
            }
        }));
    }

    @Override
    protected void addCustomComponents(DialogHolder holder, SimpleForm.Builder builder) {
        List<DialogButton> buttons = this.buttons(holder);
        for (DialogButton button2 : buttons) {
            builder.button(button2.label());
        }
        this.exitAction.ifPresent(button -> builder.button(button.label()));
        builder.validResultHandler(response -> {
            if (response.clickedButtonId() == buttons.size()) {
                holder.runButton(this.exitAction, ParsedInputs.EMPTY);
            } else {
                holder.runButton(Optional.of((DialogButton)buttons.get(response.clickedButtonId())), ParsedInputs.EMPTY);
            }
        });
    }

    @Override
    protected Optional<DialogButton> onCancel() {
        return this.exitAction;
    }

    protected static Optional<DialogButton> readDefaultExitAction(GeyserSession session, NbtMap map, Dialog.IdGetter idGetter) {
        return DialogButton.read(session, map.get((Object)"exit_action"), idGetter);
    }
}

