/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.properties;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityProperty;
import org.geysermc.geyser.entity.properties.type.PropertyType;
import org.geysermc.geyser.registry.Registries;

public class GeyserEntityProperties {
    private static final Pattern ENTITY_PROPERTY_PATTERN = Pattern.compile("^[a-z0-9_.:-]*:[a-z0-9_.:-]*$");
    private ObjectArrayList<PropertyType<?, ?>> properties;
    private Object2IntMap<String> propertyIndices;

    public NbtMap toNbtMap(String entityType) {
        NbtMapBuilder mapBuilder = NbtMap.builder();
        ArrayList<NbtMap> nbtProperties = new ArrayList<NbtMap>();
        for (PropertyType property : this.properties) {
            nbtProperties.add(property.nbtMap());
        }
        mapBuilder.putList("properties", NbtType.COMPOUND, nbtProperties);
        return mapBuilder.putString("type", entityType).build();
    }

    public <T> void add(String entityType, @NonNull PropertyType<T, ? extends EntityProperty> property) {
        if (!((Set)Registries.BEDROCK_ENTITY_PROPERTIES.get()).isEmpty()) {
            throw new IllegalStateException("Cannot add properties outside the GeyserDefineEntityProperties event!");
        }
        if (this.properties == null || this.propertyIndices == null) {
            this.properties = new ObjectArrayList(0);
            this.propertyIndices = new Object2IntOpenHashMap(0);
        }
        if (this.properties.size() > 32) {
            throw new IllegalArgumentException("Cannot register more than 32 properties for entity type " + entityType);
        }
        Objects.requireNonNull(property, "property cannot be null!");
        String name = property.identifier().toString();
        if (this.propertyIndices.containsKey((Object)name)) {
            throw new IllegalArgumentException("Property with name " + name + " already exists on builder!");
        }
        if (!ENTITY_PROPERTY_PATTERN.matcher(name).matches()) {
            throw new IllegalArgumentException("Cannot register property with name " + name + " because property name is invalid! Must match: " + ENTITY_PROPERTY_PATTERN.pattern());
        }
        this.properties.add(property);
        this.propertyIndices.put((Object)name, this.properties.size() - 1);
    }

    public @NonNull List<PropertyType<?, ?>> getProperties() {
        return this.properties == null ? List.of() : this.properties;
    }

    public boolean isEmpty() {
        return this.properties == null || this.properties.isEmpty();
    }

    public int getPropertyIndex(String name) {
        return this.propertyIndices.getOrDefault((Object)name, -1);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeyserEntityProperties)) {
            return false;
        }
        GeyserEntityProperties other = (GeyserEntityProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<PropertyType<?, ?>> this$properties = this.getProperties();
        List<PropertyType<?, ?>> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        Object2IntMap<String> this$propertyIndices = this.propertyIndices;
        Object2IntMap<String> other$propertyIndices = other.propertyIndices;
        return !(this$propertyIndices == null ? other$propertyIndices != null : !this$propertyIndices.equals(other$propertyIndices));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GeyserEntityProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<PropertyType<?, ?>> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        Object2IntMap<String> $propertyIndices = this.propertyIndices;
        result = result * 59 + ($propertyIndices == null ? 43 : $propertyIndices.hashCode());
        return result;
    }

    public String toString() {
        return "GeyserEntityProperties(properties=" + String.valueOf(this.getProperties()) + ", propertyIndices=" + String.valueOf(this.propertyIndices) + ")";
    }

    public static class Builder {
        private GeyserEntityProperties properties;
        private final String identifier;

        public Builder(String identifier) {
            this.identifier = identifier;
        }

        public <T> Builder add(@NonNull PropertyType<T, ? extends EntityProperty> property) {
            Objects.requireNonNull(property, "property cannot be null!");
            if (this.properties == null) {
                this.properties = new GeyserEntityProperties();
            }
            this.properties.add(this.identifier, property);
            return this;
        }

        public @Nullable GeyserEntityProperties build() {
            return this.properties;
        }
    }
}

